
.PHONY: distdir
distdir:
	@echo "Distributing into $(distdir)"
	@rm -rf $(distdir)
	@mkdir $(distdir)
	@list="$(DISTFILES)"; for i in $$list; do \
	  if test -d $(srcdir)/$$i; then \
	    echo "cp -pr $(srcdir)/$$i $(distdir)/$$i"; \
	    cp -pr $(srcdir)/$$i $(distdir)/$$i; \
	  else \
	    echo "cp -p $(srcdir)/$$i $(distdir)/$$i"; \
	    cp -p $(srcdir)/$$i $(distdir)/$$i; \
	  fi; \
	done
	@list="$(DISTDIRS)"; for i in $$list; do \
	  if test -n "$$i" -a "$$i" != .; then \
	    test -d $(distdir)/$$i || mkdir $(distdir)/$$i || exit 1; \
	    $(MAKE) -C $$i $(DISTMAKEFLAGS) distdir=../$(distdir)/$$i distdir; \
	  fi; \
	done
	@list="$(NODISTFILES)"; for i in $$list; do \
	  echo "rm -f $(distdir)/$$i"; \
	  rm -f $(distdir)/$$i; \
	done

$(distdir)/MD5SUMS:
	@echo "Computing MD5 sums..."
	-@if test -x "$(MD5SUM)"; then \
	  (cd $(distdir); find . -type f -exec $(MD5SUM) {} \; > /tmp/MD5SUM$$$$); \
	  if test -s /tmp/MD5SUM$$$$; then \
	    mv -f /tmp/MD5SUM$$$$ $(distdir)/MD5SUMS; \
	  else \
	    rm -f /tmp/MD5SUM$$$$; \
	  fi; \
	fi
