dnl Requires the `AC_ARG_WITHX' macros from with.m4
dnl
dnl AC_CHECK_LIBOPTIONS(SHORTNAME, NAME, HEADERS, FUNCTION)
dnl SHORTNAME=name used for sh variables and such
dnl NAME="official" name of the library, used for -l
dnl
AC_DEFUN(AC_CHECK_LIBOPTIONS, [
  define([LIB], translit($1,[a-z-],[A-Z_]))
  define([NAME], translit($1,[A-Z],[a-z]))
AC_ARG_WITHX(NAME[-headers], [location of the $1 headers],
  [case "$withval" in
    yes) AC_MSG_WARN([no value specified for [--with-]NAME[-headers]] ;;
    no)  NAME[_headers]= ;;
    *)   NAME[_headers]=$withval ;;
  esac], ,[=DIR])
AC_ARG_WITHX(NAME[-library], [location of the $1 library],
  [case "$withval" in
    yes) AC_MSG_WARN([no value specified for [--with-]NAME[-library]] ;;
    no)  NAME[_library]= ;;
    *)   NAME[_library]=$withval ;;
  esac], ,[=DIR])
  AC_SUBST(LIB[_CFLAGS])
  AC_SUBST(LIB[_LDFLAGS])
  AC_SUBST(LIB[_LIBS])
  LIB[_CFLAGS]=
  LIB[_LDFLAGS]=
  [have_]NAME[_headers]=no
  [have_]NAME[_library]=no
[#] Check for $2 headers
  AC_MSG_CHECKING([for $2 headers])
  OCF=$CFLAGS;
  TMPCFLAGS=
  [#] If we were given PATH/lib, try PATH/include
  if test -z "[$]NAME[_headers]"; then
    test -n "[$]NAME[_library]" && NAME[_headers]=[$]NAME[_library]/../include
  fi
  test -n "[$]NAME[_headers]" && TMPCFLAGS="-I[$]NAME[_headers]"
  CFLAGS="$OCF $TMPCFLAGS"
  AC_TRY_COMPILE([$3], [$4],
    [[have_]NAME[_headers]=yes; LIB[_CFLAGS]=$TMPCFLAGS],
    [if test -n "[$]NAME[_headers]"; then
      TMPCFLAGS="-I[$]NAME[_headers]/.."
      CFLAGS="$OCF $TMPCFLAGS"
      AC_TRY_COMPILE([$3], [$4],
        [[have_]NAME[_headers]=yes; LIB[_CFLAGS]=$TMPCFLAGS],
        [[have_]NAME[_headers]=no; LIB[_CFLAGS]=])
    fi])
  AC_MSG_RESULT([$have_]NAME[_headers])
[#] Check for the $2 library
  AC_MSG_CHECKING([for the $2 library])
  OLD=$LDFLAGS; OLI=$LIBS
  TMPLDFLAGS=
  [#] If we were given PATH/include, try PATH/lib
  if test -z "[$]NAME[_library]"; then
    test -n "[$]NAME[_headers]" && NAME[_library]=[$]NAME[_headers]/../lib
  fi
  test -n "[$]NAME[_library]" && TMPLDFLAGS="-L[$]NAME[_library]"
  LDFLAGS="$OLD $TMPLDFLAGS"
  LIBS="$LIBS -l$2"
  AC_TRY_LINK([$3], [$4],
    [[have_]NAME[_library]=yes; LIB[_LDFLAGS]=$TMPLDFLAGS],
    [[have_]NAME[_library]=no; LIB[_LDFLAGS]=])
  AC_MSG_RESULT([$have_]NAME[_library])
  if test "[$have_]NAME[_headers]" = yes -a "[$have_]NAME[_library]" = yes; then
    LIB[_LIBS]="-l$2"
  fi
undefine([LIB])
  TMPCFLAGS=
  TMPLDFLAGS=
[#] Restore things
  CFLAGS=$OCF
  LDFLAGS=$OLD
  LIBS=$OLI
])
AC_DEFUN(AC_SAVE_FLAGS, [
ac_mdvi_CFLAGS="$CFLAGS"
ac_mdvi_LDFLAGS="$LDFLAGS"
ac_mdvi_LIBS="$LIBS"
])
AC_DEFUN(AC_RESTORE_FLAGS, [
CFLAGS="$ac_mdvi_CFLAGS"
LDFLAGS="$ac_mdvi_LDFLAGS"
LIBS="$ac_mdvi_LIBS"
])
AC_DEFUN(AC_CHANGE_FLAGS, [
AC_SAVE_FLAGS
ifelse([$1], , ,CFLAGS="$CFLAGS $1")
ifelse([$2], , ,LDFLAGS="$LDFLAGS $2")
ifelse([$3], , ,LIBS="$3 $LIBS")
])
