<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
								xmlns:w="http://schemas.microsoft.com/office/word/2003/wordml" 
								xmlns:wx="http://schemas.microsoft.com/office/word/2003/auxHint" 
								xmlns:aml="http://schemas.microsoft.com/aml/2001/core" 
								xmlns:sl="http://schemas.microsoft.com/schemaLibrary/2003/core" 
								xmlns:o="urn:schemas-microsoft-com:office:office" 
								xmlns:w10="urn:schemas-microsoft-com:office:word" 
								xmlns:v="urn:schemas-microsoft-com:vml" 
								xmlns:dt="uuid:C2F41010-65B3-11d1-A29F-00AA00C14882">
<!-- 
This is wordml2latex, a xsl to translate a wordprocessingML document in a latex source file.
Copyright (C) 2005 Ruggero Dambra

This program is free software; you can redistribute it and/or modify 
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

Ruggero Dambra
ruggdam@fastwebnet.it
http://www25.brinkster.com/ruggdam
-->

<xsl:output method="text" encoding="utf-8"/>

<!-- Variables declaration -->
<xsl:variable name="version">1.0</xsl:variable><!-- carriage return -->
<xsl:variable name="cr"><xsl:text>&#xA;</xsl:text></xsl:variable><!-- carriage return -->
<xsl:variable name="par"><xsl:text>&#xA;&#xA;</xsl:text></xsl:variable><!-- new paragraph -->
<xsl:variable name="wordcharacters">’</xsl:variable><!-- sequence of single characters found in word, to be translated -->
<xsl:variable name="latexcharacters">'</xsl:variable><!-- sequence of single characters translation of wordcharacters -->

<!-- Retrieves documentclass from the document properties -->
<xsl:template name="GetDocumentClass">
	<xsl:choose>
		<xsl:when test="o:Category='article'">article</xsl:when>
		<xsl:when test="o:Category='book'">book</xsl:when>
		<xsl:when test="o:Category='letter'">letter</xsl:when>
		<xsl:when test="o:Category='report'">report</xsl:when>
		<xsl:when test="o:Category='slides'">slides</xsl:when>
		<xsl:otherwise>article</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Retrieves default font size -->
<xsl:template name="GetFontSize">
	<xsl:choose>
		<xsl:when test="/w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val='22'">11pt</xsl:when>
		<xsl:when test="/w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val='20'">10pt</xsl:when>
		<xsl:otherwise>12pt</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Retrieves default document language -->
<xsl:template name="GetDocumentLanguage">
	<xsl:choose>
		<xsl:when test="/w:wordDocument/w:docPr/w:activeWritingStyle[@w:lang='IT'] or /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:lang[@w:val='IT']">italian</xsl:when>
		<!-- add here other languages ... -->
		<xsl:otherwise>english</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Retrieves page size and orientation based upon the first section of the word document -->
<xsl:template name="GetPageSize">
	<xsl:choose>
		<xsl:when test="/w:wordDocument/w:body/wx:sect[1]//w:sectPr/w:pgSz[(@w:w='11907' and @w:h='16840') or (@w:h='11907' and @w:w='16840')]">a4paper</xsl:when>
		<xsl:when test="/w:wordDocument/w:body/wx:sect[1]//w:sectPr/w:pgSz[(@w:w='8420' and @w:h='11907') or (@w:h='8420' and @w:w='11907')]">a5paper</xsl:when>
		<xsl:when test="/w:wordDocument/w:body/wx:sect[1]//w:sectPr/w:pgSz[(@w:w='10319' and @w:h='14572') or (@w:h='10319' and @w:w='14572')]">b5paper</xsl:when>
		<xsl:when test="/w:wordDocument/w:body/wx:sect[1]//w:sectPr/w:pgSz[(@w:w='12242' and @w:h='15842') or (@w:h='12242' and @w:w='15842')]">letterpaper</xsl:when>
		<xsl:when test="/w:wordDocument/w:body/wx:sect[1]//w:sectPr/w:pgSz[(@w:w='12242' and @w:h='20163') or (@w:h='12242' and @w:w='20163')]">legalpaper</xsl:when>
		<xsl:when test="/w:wordDocument/w:body/wx:sect[1]//w:sectPr/w:pgSz[(@w:w='10438' and @w:h='15122') or (@w:h='10438' and @w:w='15122')]">executivepaper</xsl:when>
		<xsl:otherwise>a4paper</xsl:otherwise>
	</xsl:choose>
	<xsl:if test="/w:wordDocument/w:body/wx:sect[1]//w:sectPr/w:pgSz/@w:orient='landscape'">
		<xsl:text>,landscape</xsl:text>
	</xsl:if>
	<xsl:if test="/w:wordDocument/w:body/wx:sect[1]/descendant-or-self::w:sectPr[1]/w:cols/@w:num='2'">
		<xsl:text>,twocolumn</xsl:text>
	</xsl:if>
</xsl:template>

<!-- Retrieves page margins based upon the first section of the word document -->
<xsl:template name="GetGeometry">
	<xsl:text>top=</xsl:text><xsl:value-of select="//w:sectPr/w:pgMar/@w:top div 568.18"/><xsl:text>cm,</xsl:text>
	<xsl:text>bottom=</xsl:text><xsl:value-of select="//w:sectPr/w:pgMar/@w:bottom div 568.18"/><xsl:text>cm,</xsl:text>
	<xsl:text>left=</xsl:text><xsl:value-of select="//w:sectPr/w:pgMar/@w:left div 568.18"/><xsl:text>cm,</xsl:text>
	<xsl:text>right=</xsl:text><xsl:value-of select="//w:sectPr/w:pgMar/@w:right div 568.18"/><xsl:text>cm</xsl:text>
</xsl:template>

<!-- Retrieves a specific table column width -->
<xsl:template name="GetColumnWidth">
	<xsl:param name="colNumber" select="1"/>
	<xsl:variable name="width"><xsl:value-of select="ancestor::w:tbl[1]//w:tblGrid/w:gridCol[$colNumber]/@w:w"/></xsl:variable>
	<xsl:value-of select="($width * 100 - ($width * 100 mod 568.18)) div 568.18 div 100"/>
	<xsl:text>cm</xsl:text>
</xsl:template>

<!-- Retrieves the table cell widths -->
<xsl:template name="GetCellAlignment">
	<xsl:variable name="tableStyle"><xsl:value-of select="w:tblPr/w:tblStyle/@w:val"/></xsl:variable>
	<xsl:if test="w:tblPr/w:tblBorders/*/@w:val!='none' or /w:wordDocument/w:styles/w:style[@w:styleId=$tableStyle]/w:tblPr/w:tblBorders/*/@w:val!='none'">
		<xsl:text>|</xsl:text>
	</xsl:if>
	<xsl:for-each select="w:tblGrid/w:gridCol">
		<xsl:text>p{</xsl:text>
		<xsl:value-of select="(@w:w * 100 - (@w:w * 100 mod 568.18)) div 568.18 div 100"/>
		<xsl:text>cm}</xsl:text>
		<xsl:if test="../../w:tblPr/w:tblBorders/*/@w:val!='none' or /w:wordDocument/w:styles/w:style[@w:styleId=$tableStyle]/w:tblPr/w:tblBorders/*/@w:val!='none'">
			<xsl:text>|</xsl:text>
		</xsl:if>
	</xsl:for-each>
</xsl:template>

<!-- Retrieves the name of a bookmark -->
<xsl:template name="GetBookmarkName">
	<xsl:param name="bookmarkID"/>
	<xsl:value-of select="/*//aml:annotation[@aml:id=$bookmarkID and @w:type='Word.Bookmark.Start']/@w:name"/>
</xsl:template>

<!-- Retrieves image properties -->
<xsl:template name="GetImageProperties">
	<xsl:text>width=</xsl:text>
	<xsl:value-of select="substring-before(substring-after(v:shape/@style,'width:'),';')"/>
	<xsl:text>,height=</xsl:text>
	<xsl:value-of select="substring-after(v:shape/@style,'height:')"/>
</xsl:template>

<xsl:template name="GetRGBColors">
	<xsl:param name="rrggbb"/>
	<xsl:call-template name="ConvHex2Dec">
		<xsl:with-param name="hexValue" select="substring($rrggbb,1,2)"/> 
		<xsl:with-param name="length" select="2"/> 
	</xsl:call-template>
	<xsl:text>,</xsl:text>
	<xsl:call-template name="ConvHex2Dec">
		<xsl:with-param name="hexValue" select="substring($rrggbb,3,2)"/> 
		<xsl:with-param name="length" select="2"/> 
	</xsl:call-template>
	<xsl:text>,</xsl:text>
	<xsl:call-template name="ConvHex2Dec">
		<xsl:with-param name="hexValue" select="substring($rrggbb,5,2)"/> 
		<xsl:with-param name="length" select="2"/> 
	</xsl:call-template>
</xsl:template>

<!-- Retrieves list type -->
<xsl:template name="GetListType">
	<xsl:param name="listIndexerFont"/>
	<xsl:choose>
    	<xsl:when test="/w:wordDocument/w:fonts/w:font[@w:name=$listIndexerFont]/w:family/@w:val='Auto' or $listIndexerFont='Symbol'">itemize</xsl:when>
    	<xsl:otherwise>enumerate</xsl:otherwise>
	</xsl:choose>          
</xsl:template>

<!-- Retrieves font family -->
<xsl:template name="GetFontFamily">
	<xsl:param name="font"/>
	<xsl:choose>
    	<xsl:when test="/w:wordDocument/w:fonts/w:font[@w:name=$font]/w:family/@w:val='Swiss'"><xsl:text>{\sffamily </xsl:text></xsl:when>
		<xsl:when test="/w:wordDocument/w:fonts/w:font[@w:name=$font]/w:family/@w:val='Modern'"><xsl:text>{\ttfamily </xsl:text></xsl:when>
		<xsl:when test="/w:wordDocument/w:fonts/w:font[@w:name=$font]/w:family/@w:val='Roman'"><xsl:text>{\rmfamily </xsl:text></xsl:when>
		<xsl:when test="/w:wordDocument/w:fonts/w:font[@w:name=$font]/w:family/@w:val='Script'"><xsl:text>{\textsl </xsl:text></xsl:when>
		<xsl:when test="/w:wordDocument/w:fonts/w:font[@w:name=$font]/w:family/@w:val='Auto'"><xsl:text>{\textsl </xsl:text></xsl:when>
		<xsl:otherwise>{</xsl:otherwise>
	</xsl:choose>          
</xsl:template>

<!-- Converts hexadecimal numbers into decimal (with base 0 and ceiling 1) -->
<xsl:template name="ConvHex2Dec">
	<xsl:param name="hexValue"/>
	<xsl:param name="workValue" select="0"/>
	<xsl:param name="i" select="1"/> 
	<xsl:param name="length" select="2"/> 
	<xsl:variable name="hexDigit" select="substring($hexValue,$length,1)"/> 
	<xsl:choose>
		<xsl:when test="not($length = 0)">
			<xsl:choose>
				<xsl:when test="$hexDigit = 'A'">
					<xsl:call-template name="ConvHex2Dec">
						<xsl:with-param name="hexValue" select="$hexValue"/> 
						<xsl:with-param name="workValue" select="10 * $i + $workValue"/>
						<xsl:with-param name="i" select="$i * 16"/> 
						<xsl:with-param name="length" select="$length - 1"/> 
					</xsl:call-template>
				</xsl:when> 
				<xsl:when test="$hexDigit = 'B'">
					<xsl:call-template name="ConvHex2Dec">
						<xsl:with-param name="hexValue" select="$hexValue"/> 
						<xsl:with-param name="workValue" select="11 * $i + $workValue"/>
						<xsl:with-param name="i" select="$i * 16"/> 
						<xsl:with-param name="length" select="$length - 1"/> 
					</xsl:call-template>
				</xsl:when> 
				<xsl:when test="$hexDigit = 'C'">
					<xsl:call-template name="ConvHex2Dec">
						<xsl:with-param name="hexValue" select="$hexValue"/> 
						<xsl:with-param name="workValue" select="12 * $i + $workValue"/>
						<xsl:with-param name="i" select="$i * 16"/> 
						<xsl:with-param name="length" select="$length - 1"/> 
					</xsl:call-template>
				</xsl:when> 
				<xsl:when test="$hexDigit = 'D'">
					<xsl:call-template name="ConvHex2Dec">
						<xsl:with-param name="hexValue" select="$hexValue"/> 
						<xsl:with-param name="workValue" select="13 * $i + $workValue"/>
						<xsl:with-param name="i" select="$i * 16"/> 
						<xsl:with-param name="length" select="$length - 1"/> 
					</xsl:call-template>
				</xsl:when> 
				<xsl:when test="$hexDigit = 'E'">
					<xsl:call-template name="ConvHex2Dec">
						<xsl:with-param name="hexValue" select="$hexValue"/> 
						<xsl:with-param name="workValue" select="14 * $i + $workValue"/>
						<xsl:with-param name="i" select="$i * 16"/> 
						<xsl:with-param name="length" select="$length - 1"/> 
					</xsl:call-template>
				</xsl:when> 
				<xsl:when test="$hexDigit = 'F'">
					<xsl:call-template name="ConvHex2Dec">
						<xsl:with-param name="hexValue" select="$hexValue"/> 
						<xsl:with-param name="workValue" select="15 * $i + $workValue"/>
						<xsl:with-param name="i" select="$i * 16"/> 
						<xsl:with-param name="length" select="$length - 1"/> 
					</xsl:call-template>
				</xsl:when> 
				<xsl:otherwise>
					<xsl:call-template name="ConvHex2Dec">
						<xsl:with-param name="hexValue" select="$hexValue"/> 
						<xsl:with-param name="workValue" select="$hexDigit * $i + $workValue"/>
						<xsl:with-param name="i" select="$i * 16"/> 
						<xsl:with-param name="length" select="$length - 1"/> 
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$workValue div 255"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Substitute all special characters in strings -->
<xsl:template name="CharacterSubst">
	<xsl:param name="string"/>
	<xsl:choose>
		<xsl:when test="contains(translate($string,'WORDML2ATEX','wordml2atex'), 'wordml2latex')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'à')"/>
			</xsl:call-template>
			<xsl:text>\wl{}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'à')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'à')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'à')"/>
			</xsl:call-template>
			<xsl:text>\`a</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'à')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'è')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'è')"/>
			</xsl:call-template>
			<xsl:text>\`e</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'è')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'é')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'é')"/>
			</xsl:call-template>
			<xsl:text>\'e</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'é')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'È')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'È')"/>
			</xsl:call-template>
			<xsl:text>\`E</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'È')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'ì')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'ì')"/>
			</xsl:call-template>
			<xsl:text>\`i</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'ì')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'ò')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'ò')"/>
			</xsl:call-template>
			<xsl:text>\`o</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'ò')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'ù')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'ù')"/>
			</xsl:call-template>
			<xsl:text>\`u</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'ù')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '#')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'#')"/>
			</xsl:call-template>
			<xsl:text>\#</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'#')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '$')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'$')"/>
			</xsl:call-template>
			<xsl:text>\$</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'$')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '%')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'%')"/>
			</xsl:call-template>
			<xsl:text>\%</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'%')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '&amp;')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'&amp;')"/>
			</xsl:call-template>
			<xsl:text>\&amp;</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'&amp;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '~')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'~')"/>
			</xsl:call-template>
			<xsl:text>\~</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'~')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '_')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'_')"/>
			</xsl:call-template>
			<xsl:text>\_</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'_')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '^')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'^')"/>
			</xsl:call-template>
			<xsl:text>$\hat{}$</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'^')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '\')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'\')"/>
			</xsl:call-template>
			<xsl:text>$\backslash$</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'\')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '{')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'{')"/>
			</xsl:call-template>
			<xsl:text>\{</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'{')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '}')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'}')"/>
			</xsl:call-template>
			<xsl:text>\}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'}')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '€')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'€')"/>
			</xsl:call-template>
			<xsl:text>{\euro}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'€')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '’')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'’')"/>
			</xsl:call-template>
			<xsl:text>'</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'’')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '“')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'“')"/>
			</xsl:call-template>
			<xsl:text>``</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'“')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '”')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'”')"/>
			</xsl:call-template>
			<xsl:text>''</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'”')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '”')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'”')"/>
			</xsl:call-template>
			<xsl:text>''</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'”')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '”')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'”')"/>
			</xsl:call-template>
			<xsl:text>''</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'”')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, 'Ç')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'Ç')"/>
			</xsl:call-template>
			<xsl:text>\c c</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'Ç')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '£')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'£')"/>
			</xsl:call-template>
			<xsl:text>{\pounds}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'£')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '°')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'°')"/>
			</xsl:call-template>
			<xsl:text>$^{\circ}$</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'°')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '§')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'§')"/>
			</xsl:call-template>
			<xsl:text>\S</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'§')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '&#8211;')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'&#8211;')"/>
			</xsl:call-template>
			<xsl:text>--</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'&#8211;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '&#8212;')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'&#8212;')"/>
			</xsl:call-template>
			<xsl:text>---</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'&#8212;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '&#8230;')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'&#8230;')"/>
			</xsl:call-template>
			<xsl:text>{\ldots}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'&#8230;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '•')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'•')"/>
			</xsl:call-template>
			<xsl:text>{\textbullet}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'•')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '®')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'®')"/>
			</xsl:call-template>
			<xsl:text>{\textregistered}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'®')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '©')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'©')"/>
			</xsl:call-template>
			<xsl:text>{\copyright}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'©')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '™')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'™')"/>
			</xsl:call-template>
			<xsl:text>{\texttrademark}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'™')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '†')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'†')"/>
			</xsl:call-template>
			<xsl:text>{\dag}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'†')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($string, '‡')">
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-before($string,'‡')"/>
			</xsl:call-template>
			<xsl:text>{\ddag}</xsl:text>
			<xsl:call-template name="CharacterSubst">
				<xsl:with-param name="string" select="substring-after($string,'‡')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="translate($string, $wordcharacters, $latexcharacters)"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Tries to translate EQ (equation) field --> 
<xsl:template name="TranslateEQ">
	<xsl:param name="equation"/>
	<xsl:choose>
		<xsl:when test="contains($equation, '\A') or contains($equation, '\B') or contains($equation, '\D') or contains($equation, '\I') or contains($equation, '\L') or contains($equation, '\O') or contains($equation, '\X')">
			<xsl:text>Sorry,\ WordML2LaTeX couldn't\ translate\ MS\ EQ\ Field</xsl:text>
		</xsl:when>
		<xsl:when test="contains($equation, '\F(')">
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-before($equation,'\F(')"/>
			</xsl:call-template>
			<xsl:text>\frac{</xsl:text>
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-after($equation,'\F(')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($equation, '\R(2;')">
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-before($equation,'\R(2;')"/>
			</xsl:call-template>
			<xsl:text>\sqrt{</xsl:text>
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-after($equation,'\R(2;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($equation, '\R(3;')">
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-before($equation,'\R(3;')"/>
			</xsl:call-template>
			<xsl:text>\sqrt[3]{</xsl:text>
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-after($equation,'\R(3;')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($equation, '\S(')">
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-before($equation,'\S(')"/>
			</xsl:call-template>
			<xsl:text>^{</xsl:text>
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-after($equation,'\S(')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($equation, '\S\DO(')">
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-before($equation,'\S\DO(')"/>
			</xsl:call-template>
			<xsl:text>_{</xsl:text>
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-after($equation,'\S\DO(')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($equation, ';')">
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-before($equation,';')"/>
			</xsl:call-template>
			<xsl:text>}{</xsl:text>
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-after($equation,';')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:when test="contains($equation, ')')">
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-before($equation,')')"/>
			</xsl:call-template>
			<xsl:text>}</xsl:text>
			<xsl:call-template name="TranslateEQ">
				<xsl:with-param name="equation" select="substring-after($equation,')')"/>
			</xsl:call-template>
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="$equation"/>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Closes nested lists -->
<xsl:template name="EndList">
	<xsl:param name="listItem" select="."/>
	<xsl:param name="tab" select="w:pPr/w:listPr/wx:t/@wx:wTabBefore"/>
	<xsl:param name="returnTab" select="-1"/>
	<xsl:value-of select="$cr"/>
	<xsl:text>\end{</xsl:text>
	<xsl:call-template name="GetListType">
		<xsl:with-param name="listIndexerFont" select="$listItem/w:pPr/w:listPr/wx:font/@wx:val"/>
	</xsl:call-template>
	<xsl:text>}</xsl:text>
	<xsl:if test="preceding-sibling::w:p[w:pPr/w:listPr/wx:t/@wx:wTabBefore &lt; $tab]/w:pPr/w:listPr/wx:t/@wx:wTabBefore > $returnTab">
		<xsl:call-template name="EndList">
			<xsl:with-param name="listItem" select="preceding-sibling::w:p[w:pPr/w:listPr/wx:t/@wx:wTabBefore &lt; $tab]"/>
			<xsl:with-param name="tab" select="preceding-sibling::w:p[w:pPr/w:listPr/wx:t/@wx:wTabBefore &lt; $tab]/w:pPr/w:listPr/wx:t/@wx:wTabBefore"/>
			<xsl:with-param name="returnTab" select="$returnTab"/>
		</xsl:call-template>
	</xsl:if>
</xsl:template>

<!-- Text -->
<xsl:template name="Text" match="w:t">
	<xsl:call-template name="CharacterSubst">
		<xsl:with-param name="string" select="."/>
	</xsl:call-template>
</xsl:template>

<!-- Leaf container -->
<xsl:template name="Run" match="w:r">
	<xsl:choose>
		<!-- fields (reference and inline equations) -->
		<xsl:when test="(preceding-sibling::w:r/w:fldChar/@w:fldCharType='begin') and (following-sibling::w:r/w:fldChar/@w:fldCharType='end')">
			<xsl:if test="w:instrText">
				<xsl:choose>
					<xsl:when test="contains(.,' REF ')">
						<xsl:text>\ref{</xsl:text>
						<xsl:value-of select="substring-before(substring-after(w:instrText,'REF '),' ')"/>
						<xsl:text>}</xsl:text>
					</xsl:when>	
					<xsl:when test="contains(.,' PAGEREF ')">
						<xsl:text>\pageref{</xsl:text>
						<xsl:value-of select="substring-before(substring-after(w:instrText,'PAGEREF '),' ')"/>
						<xsl:text>}</xsl:text>
					</xsl:when>
					<xsl:when test="contains(.,' EQ ')">
						<xsl:text>$</xsl:text>
						<xsl:call-template name="TranslateEQ">
							<xsl:with-param name="equation" select="normalize-space(substring-after(w:instrText,'EQ'))"/>
						</xsl:call-template>
						<xsl:text>$</xsl:text>
					</xsl:when>
				</xsl:choose>
			</xsl:if>
		</xsl:when>
		<!-- new page command -->
		<xsl:when test="w:br/@w:type='page'">
			<xsl:value-of select="$cr"/>
			<xsl:text>\newpage</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<!-- tab -->
			<xsl:if test="w:tab">
				<xsl:text>\hspace{</xsl:text>
				<xsl:value-of select="w:tab/@wx:wTab div 568.18"/>
				<xsl:text>cm}</xsl:text>
			</xsl:if>
			<!-- inline font and font style -->
			<xsl:for-each select="w:rPr">
				<xsl:if test="./node()[name()='w:vanish']"><xsl:text>%</xsl:text></xsl:if>
				<xsl:if test="wx:font and not(../preceding-sibling::w:r/w:rPr/wx:font/@wx:val=./wx:font/@wx:val)">
					<xsl:call-template name="GetFontFamily">
						<xsl:with-param name="font" select="wx:font/@wx:val"/>
					</xsl:call-template>
				</xsl:if>
				<xsl:if test="./node()[name()='w:highlight']"><xsl:text>\colorbox{</xsl:text><xsl:value-of select="w:highlight/@w:val"/><xsl:text>}{</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:color']">
					<xsl:text>\textcolor[rgb]{</xsl:text>
					<xsl:call-template name="GetRGBColors">
						<xsl:with-param name="rrggbb" select="w:color/@w:val"/>
					</xsl:call-template>
					<xsl:text>}{</xsl:text>
				</xsl:if>
				<xsl:if test="./node()[name()='w:i']"><xsl:text>\emph{</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:smallCaps']"><xsl:text>\textsc{</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:b']"><xsl:text>\textbf{</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:sz']">
					<xsl:choose>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt; -4"><xsl:text>{\tiny </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt; -2"><xsl:text>{\scriptsize </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt; -1"><xsl:text>{\footnotesize </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt; 0"><xsl:text>{\small </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &gt; 0 and w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt;= 4"><xsl:text>{\large </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &gt; 4 and w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt;= 8"><xsl:text>{\Large </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &gt; 8 and w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt;= 12"><xsl:text>{\LARGE </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &gt; 12 and w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt;= 16"><xsl:text>{\huge </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &gt; 16 and w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &lt;= 20"><xsl:text>{\Huge </xsl:text></xsl:when>
						<xsl:when test="w:sz/@w:val - /w:wordDocument/w:styles/w:style[@w:default='on']/w:rPr/w:sz/@w:val &gt; 20"><xsl:text>\resizebox{!}{</xsl:text><xsl:value-of select="w:sz/@w:val div 2"/><xsl:text>pt}{</xsl:text></xsl:when>
						<xsl:otherwise>{\normalsize </xsl:otherwise>
					</xsl:choose>
				</xsl:if>
				<xsl:if test="w:vertAlign/@w:val='superscript'">\textsuperscript{</xsl:if>
				<xsl:if test="w:vertAlign/@w:val='subscript'"><xsl:text>$_{</xsl:text></xsl:if>
			</xsl:for-each>
			<xsl:apply-templates select="w:t|w:footnote|w:pict"/>
			<xsl:for-each select="w:rPr">
				<xsl:if test="w:vertAlign/@w:val='subscript'"><xsl:text>}$</xsl:text></xsl:if>
				<xsl:if test="w:vertAlign/@w:val='superscript'"><xsl:text>}</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:sz']"><xsl:text>}</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:b']"><xsl:text>}</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:smallCaps']"><xsl:text>}</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:i']"><xsl:text>}</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:color']"><xsl:text>}</xsl:text></xsl:if>
				<xsl:if test="./node()[name()='w:highlight']"><xsl:text>}</xsl:text></xsl:if>
				<xsl:if test="wx:font and not(../following-sibling::w:r/w:rPr/wx:font/@wx:val=./wx:font/@wx:val)"><xsl:text>}</xsl:text></xsl:if>
			</xsl:for-each>	
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Hyperlink -->
<xsl:template name="Hyperlink" match="w:hlink">
	<xsl:text>\href{</xsl:text>
	<xsl:value-of select="@w:dest"/>
	<xsl:text>}{</xsl:text>
	<xsl:apply-templates select="w:r/w:t"/>
	<xsl:text>}</xsl:text>
</xsl:template>

<!-- Reference -->
<xsl:template name="Reference" match="aml:annotation">
	<xsl:variable name="bookmarkName">
		<xsl:call-template name="GetBookmarkName">
   			<xsl:with-param name="bookmarkID" select="@aml:id"/>
   		</xsl:call-template>
	</xsl:variable>
	<xsl:if test="@w:type='Word.Bookmark.End' and not(starts-with($bookmarkName,'_Toc'))"> 
		<xsl:text>\label{</xsl:text>
		<xsl:value-of select="$bookmarkName"/>
		<xsl:text>}</xsl:text>
	</xsl:if>
</xsl:template>

<!-- Footnote -->
<xsl:template name="Footnote" match="w:footnote">
	<xsl:text>\footnote{</xsl:text>
	<xsl:apply-templates select="w:p/w:r/w:t"/>
	<xsl:text>}</xsl:text>
</xsl:template>

<!-- Image or Equation -->
<xsl:template name="Image" match="w:pict">
	<xsl:choose>
		<!-- MS Equation Editor 3.0 object -->
		<xsl:when test="o:OLEObject/@ProgID='Equation.3'">
			<xsl:choose>
				<xsl:when test="../../following-sibling::w:p[position() = 1 and w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]">
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{equation}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\textsl{\textcolor{red}{Sorry, WordML2LaTeX couldn't translate a MS Equation Editor Object}}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\end{equation}</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$cr"/>
					<xsl:text>\[</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\textsl{\textcolor{red}{Sorry, WordML2LaTeX couldn't translate a MS Equation Editor Object}}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\]</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<!-- Binary object -->
		<xsl:when test="w:binData">
			<xsl:choose>
				<xsl:when test="../../following-sibling::w:p[position() = 1 and w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]">
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{figure}[htbp]</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\centering</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\fbox{</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{minipage}{</xsl:text>
					<xsl:value-of select="substring-before(substring-after(v:shape/@style,'width:'),';')"/>
					<xsl:text>}</xsl:text>
					<xsl:text>\textsl{\textcolor{red}{Sorry, WordML2LaTeX couldn't translate </xsl:text>
					<xsl:choose>
						<xsl:when test="v:shape/v:imagedata/@o:title">
						 	<xsl:text>a binary object named ``</xsl:text>
							<xsl:value-of select="v:shape/v:imagedata/@o:title"/>
							<xsl:text>''</xsl:text>
						</xsl:when>
						<xsl:otherwise>
						 	<xsl:text>a binary object</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text>}}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\end{minipage}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\caption{</xsl:text>
					<xsl:for-each select="../../../w:p[w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]/w:r[preceding-sibling::w:r[w:fldChar/@w:fldCharType='end']]">
						<xsl:value-of select="normalize-space(.)"/>
					</xsl:for-each>
					<xsl:text>}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:if test="../../../aml:annotation">
						<xsl:text>\label{</xsl:text>
						<xsl:value-of select="translate(../../../aml:annotation[@w:type='Word.Bookmark.Start']/@w:name,':','')"/>
						<xsl:text>}</xsl:text>
						<xsl:value-of select="$cr"/>
					</xsl:if>
					<xsl:text>\end{figure}</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>\fbox{</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{minipage}{</xsl:text>
					<xsl:value-of select="substring-before(substring-after(v:shape/@style,'width:'),';')"/>
					<xsl:text>}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\textsl{\textcolor{red}{Sorry, WordML2LaTeX couldn't translate </xsl:text>
					<xsl:choose>
						<xsl:when test="v:shape/v:imagedata/@o:title">
						 	<xsl:text>a binary object named ``</xsl:text>
							<xsl:value-of select="v:shape/v:imagedata/@o:title"/>
							<xsl:text>''</xsl:text>
						</xsl:when>
						<xsl:otherwise>
						 	<xsl:text>a binary object</xsl:text>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:text>}}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\end{minipage}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>}</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:choose>
				<xsl:when test="../../following-sibling::w:p[position() = 1 and w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]">
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{figure}[htbp]</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\centering</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\includegraphics[</xsl:text>
					<xsl:call-template name="GetImageProperties"/>
					<xsl:text>]{</xsl:text>
					<xsl:value-of select="v:shape/v:imagedata/@src"/>
					<xsl:text>}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:text>\caption{</xsl:text>
					<xsl:for-each select="../../../w:p[w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]/w:r[preceding-sibling::w:r[w:fldChar/@w:fldCharType='end']]">
						<xsl:value-of select="normalize-space(.)"/>
					</xsl:for-each>
					<xsl:text>}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:if test="../../../aml:annotation">
						<xsl:text>\label{</xsl:text>
						<xsl:value-of select="translate(../../../aml:annotation[@w:type='Word.Bookmark.Start']/@w:name,':','')"/>
						<xsl:text>}</xsl:text>
						<xsl:value-of select="$cr"/>
					</xsl:if>
					<xsl:text>\end{figure}</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>\includegraphics[</xsl:text>
					<xsl:call-template name="GetImageProperties"/>
					<xsl:text>]{</xsl:text>
					<xsl:value-of select="v:shape/v:imagedata/@src"/>
					<xsl:text>}</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Table -->
<xsl:template name="Table" match="w:tbl">
	<xsl:if test="(preceding::w:p[position()=1 and w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]) or (following::w:p[position()=1 and w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId])">
		<xsl:value-of select="$cr"/>
		<xsl:text>\begin{table}[htbp]</xsl:text>
		<xsl:value-of select="$cr"/>
		<xsl:text>\begin{center}</xsl:text>
	</xsl:if>
	<xsl:value-of select="$cr"/>
	<xsl:text>\begin{tabular}{</xsl:text>
	<xsl:call-template name="GetCellAlignment"/>
	<xsl:text>}</xsl:text>
	<xsl:variable name="tableStyle"><xsl:value-of select="w:tblPr/w:tblStyle/@w:val"/></xsl:variable>
	<xsl:if test="w:tblPr/w:tblBorders/*/@w:val!='none' or /w:wordDocument/w:styles/w:style[@w:styleId=$tableStyle]/w:tblPr/w:tblBorders/*/@w:val!='none'">
		<xsl:value-of select="$cr"/>
		<xsl:text>\hline</xsl:text>
	</xsl:if>
	<xsl:for-each select="w:tr">
		<xsl:for-each select="w:tc[position()!=last()]">
			<xsl:value-of select="$cr"/>
			<xsl:text>\begin{minipage}{</xsl:text>
			<xsl:call-template name="GetColumnWidth">
				<xsl:with-param name="colNumber" select="count(preceding-sibling::w:tc) + 1"/>
			</xsl:call-template>
			<xsl:text>}</xsl:text>
			<xsl:apply-templates select=".//w:p"/>
			<xsl:value-of select="$cr"/>
			<xsl:text>\end{minipage}</xsl:text>
			<xsl:text> &amp; </xsl:text>
		</xsl:for-each>
		<xsl:for-each select="w:tc[position()=last()]">
			<xsl:value-of select="$cr"/>
			<xsl:text>\begin{minipage}{</xsl:text>
			<xsl:call-template name="GetColumnWidth">
				<xsl:with-param name="colNumber" select="count(preceding-sibling::w:tc) + 1"/>
			</xsl:call-template>
			<xsl:text>}</xsl:text>
			<xsl:apply-templates select=".//w:p"/>
			<xsl:value-of select="$cr"/>
			<xsl:text>\end{minipage}</xsl:text>
			<xsl:text> \\</xsl:text>
		</xsl:for-each>
		<xsl:if test="../w:tblPr/w:tblBorders/*/@w:val!='none' or /w:wordDocument/w:styles/w:style[@w:styleId=$tableStyle]/w:tblPr/w:tblBorders/*/@w:val!='none'">
			<xsl:value-of select="$cr"/>
			<xsl:text>\hline</xsl:text>
		</xsl:if>
	</xsl:for-each>
	<xsl:value-of select="$cr"/>
	<xsl:text>\end{tabular}</xsl:text>
	<xsl:if test="(preceding::w:p[position()=1 and w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]) or (following::w:p[position()=1 and w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId])">
		<xsl:value-of select="$cr"/>
		<xsl:text>\end{center}</xsl:text>
		<xsl:value-of select="$cr"/>
		<xsl:text>\caption{</xsl:text>
		<xsl:for-each select="../w:p[w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId]/w:r[preceding-sibling::w:r[w:fldChar/@w:fldCharType='end']]">
			<xsl:value-of select="normalize-space(.)"/>
		</xsl:for-each>
		<xsl:text>}</xsl:text>
		<xsl:value-of select="$cr"/>
		<xsl:if test="../aml:annotation">
			<xsl:text>\label{</xsl:text>
			<xsl:value-of select="translate(../aml:annotation[@w:type='Word.Bookmark.Start']/@w:name,':','')"/>
			<xsl:text>}</xsl:text>
			<xsl:value-of select="$cr"/>
		</xsl:if>
		<xsl:text>\end{table}</xsl:text>
	</xsl:if>
</xsl:template>

<!-- Border Paragraph -->
<xsl:template name="BorderParagraph" match="wx:pBdrGroup">
	<xsl:value-of select="$par"/>
	<xsl:text>\fbox{</xsl:text>
		<xsl:value-of select="$cr"/>
		<xsl:text>\begin{minipage}{</xsl:text>
		<xsl:value-of select="(/w:wordDocument/w:body/wx:sect[1]//w:sectPr[last()]/w:pgSz/@w:w - /w:wordDocument/w:body/wx:sect[1]//w:sectPr[last()]/w:pgMar/@w:left - /w:wordDocument/w:body/wx:sect[1]//w:sectPr[last()]/w:pgMar/@w:right) div 568.18"/>
		<xsl:text>cm}</xsl:text>
		<xsl:apply-templates/>
		<xsl:value-of select="$cr"/>
		<xsl:text>\end{minipage}</xsl:text>
	<xsl:text>}</xsl:text>
</xsl:template>

<!-- Paragraph -->
<xsl:template name="Paragraph" match="w:p">
	<xsl:choose>
		<!-- ignore captions -->
		<xsl:when test="w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:name/@w:val='caption']/@w:styleId"/>
		<!-- toc -->
		<xsl:when test="w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[starts-with(w:name/@w:val,'toc')]/@w:styleId">
			<xsl:if test="not(preceding-sibling::w:p[1]/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[starts-with(w:name/@w:val,'toc')]/@w:styleId)">
				<xsl:value-of select="$cr"/>
				<xsl:text>\tableofcontents</xsl:text>	             
			</xsl:if>
		</xsl:when>
		<!-- list of figures -->
		<xsl:when test="w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[starts-with(w:name/@w:val,'table of figures')]/@w:styleId">
			<xsl:if test="not(preceding-sibling::w:p[1]/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[starts-with(w:name/@w:val,'table of figures')]/@w:styleId)">
				<xsl:value-of select="$cr"/>
				<xsl:text>\listoffigures</xsl:text>	             
			</xsl:if>
		</xsl:when>
		<!-- lists -->
		<xsl:when test="w:pPr/w:listPr">
			<xsl:if test="not(preceding-sibling::w:p[1]/w:pPr/w:listPr) or preceding-sibling::w:p[1]/w:pPr/w:listPr/wx:t/@wx:wTabBefore&lt;./w:pPr/w:listPr/wx:t/@wx:wTabBefore">
				<xsl:value-of select="$cr"/>
				<xsl:text>\begin{</xsl:text>
	            <xsl:call-template name="GetListType">
		            <xsl:with-param name="listIndexerFont" select="w:pPr/w:listPr/wx:font/@wx:val"/>
		        </xsl:call-template>
		        <xsl:text>}</xsl:text>
	        </xsl:if>
			<xsl:value-of select="$cr"/>
			<xsl:text>\item </xsl:text>
			<xsl:apply-templates select="w:r|w:hlink|aml:annotation"/>
			<xsl:if test="not(following-sibling::w:p[1]/w:pPr/w:listPr) or following-sibling::w:p[1]/w:pPr/w:listPr/wx:t/@wx:wTabBefore&lt;./w:pPr/w:listPr/wx:t/@wx:wTabBefore">
				<xsl:choose>
					<xsl:when test="following-sibling::w:p[1]/w:pPr/w:listPr">
						<xsl:call-template name="EndList">
							<xsl:with-param name="returnTab" select="following-sibling::w:p[1]/w:pPr/w:listPr/wx:t/@wx:wTabBefore"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="EndList">
							<xsl:with-param name="returnTab" select="-1"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:if>
		</xsl:when>
		<!-- others -->
		<xsl:otherwise>	
			<xsl:choose>
				<xsl:when test="w:pPr/w:jc/@w:val='both'">
					<xsl:value-of select="$par"/>
					<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
				</xsl:when>
				<xsl:when test="w:pPr/w:jc/@w:val='center'">
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{center}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
					<xsl:value-of select="$cr"/>
					<xsl:text>\end{center}</xsl:text>
				</xsl:when>
				<xsl:when test="w:pPr/w:jc/@w:val='right'">
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{flushright}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
					<xsl:value-of select="$cr"/>
					<xsl:text>\end{flushright}</xsl:text>
				</xsl:when>
				<xsl:when test="w:pPr/w:jc/@w:val='left'">
					<xsl:value-of select="$cr"/>
					<xsl:text>\begin{flushleft}</xsl:text>
					<xsl:value-of select="$cr"/>
					<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
					<xsl:value-of select="$cr"/>
					<xsl:text>\end{flushleft}</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="/w:wordDocument/w:styles/w:style[@w:default='on']/w:pPr/w:jc/@w:val='center'">
							<xsl:value-of select="$cr"/>
							<xsl:text>\begin{center}</xsl:text>
							<xsl:value-of select="$cr"/>
							<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
							<xsl:value-of select="$cr"/>
							<xsl:text>\end{center}</xsl:text>
						</xsl:when>
						<xsl:when test="/w:wordDocument/w:styles/w:style[@w:default='on']/w:pPr/w:jc/@w:val='right'">
							<xsl:value-of select="$cr"/>
							<xsl:text>\begin{flushright}</xsl:text>
							<xsl:value-of select="$cr"/>
							<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
							<xsl:value-of select="$cr"/>
							<xsl:text>\end{flushright}</xsl:text>
						</xsl:when>
						<xsl:when test="/w:wordDocument/w:styles/w:style[@w:default='on']/w:pPr/w:jc/@w:val='left'">
							<xsl:value-of select="$cr"/>
							<xsl:text>\begin{flushleft}</xsl:text>
							<xsl:value-of select="$cr"/>
							<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
							<xsl:value-of select="$cr"/>
							<xsl:text>\end{flushleft}</xsl:text>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="$par"/>
							<xsl:apply-templates select="w:r|w:hlink|aml:annotation|*/w:r"/>
						</xsl:otherwise>
					</xsl:choose>			
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- Section title and label -->
<xsl:template name="Section" match="wx:sub-section">
	<xsl:choose>
		<xsl:when test="/w:wordDocument/o:DocumentProperties/o:Category='book' or /w:wordDocument/o:DocumentProperties/o:Category='report'">
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='0']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\part{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='1']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\chapter{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='2']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\section{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='3']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\subsection{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='4']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\subsubsection{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='5']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\paragraph{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='6']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\subparagraph{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
		</xsl:when>
		<xsl:otherwise>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='0']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\part{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='1']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\section{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='2']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\subsection{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='3']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\subsubsection{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='4']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\paragraph{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
			<xsl:if test="w:p/w:pPr/w:pStyle/@w:val=/w:wordDocument/w:styles/w:style[w:pPr/w:outlineLvl/@w:val='5']/@w:styleId">
				<xsl:value-of select="$par"/>
				<xsl:text>\subparagraph{</xsl:text>
				<xsl:apply-templates select="w:p[1]/w:r/w:t"/>
				<xsl:text>}</xsl:text>
				<xsl:value-of select="$cr"/>
				<xsl:apply-templates select="w:p[1]/aml:annotation"/>
			</xsl:if>
		</xsl:otherwise>		
	</xsl:choose>
	<xsl:apply-templates select="w:p[position() > 1]|w:tbl|wx:sub-section|aml:annotation|wx:pBdrGroup"/>
</xsl:template>

<!-- Main section of document -->
<xsl:template name="Main" match="wx:sect">
	<xsl:apply-templates/>
</xsl:template>

<!-- *** Main environments of the LaTeX document *** -->

<!-- Document properties to be written in the preamble -->
<xsl:template name="Preamble" match="o:DocumentProperties">
	<xsl:value-of select="$par"/>
	<xsl:text>\documentclass[</xsl:text>
	<xsl:call-template name="GetFontSize"/>
	<xsl:text>,</xsl:text>
	<xsl:call-template name="GetDocumentLanguage"/>
	<xsl:text>,</xsl:text>
	<xsl:call-template name="GetPageSize"/>
	<xsl:text>]{</xsl:text>
	<xsl:call-template name="GetDocumentClass"/>
	<xsl:text>}</xsl:text>
	<xsl:value-of select="$cr"/>
	
	<!-- packages -->
	<xsl:text>\usepackage[]{fontenc}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage[latin1]{inputenc}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage[</xsl:text><xsl:call-template name="GetGeometry"/><xsl:text>]{geometry}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage[</xsl:text><xsl:call-template name="GetDocumentLanguage"/><xsl:text>]{babel}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage{graphicx}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage{eurosym}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage{amsmath}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage{color}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage{fancyhdr}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\usepackage{hyperref}</xsl:text>
	<xsl:value-of select="$cr"/>
	
	<!-- pdf settings -->
	<xsl:text>\hypersetup{</xsl:text>
	<xsl:text>pdftitle={</xsl:text>
	<xsl:value-of select="o:Title"/>
	<xsl:text>},</xsl:text>
	<xsl:text>pdfsubject={</xsl:text>
	<xsl:value-of select="o:Subject"/>
	<xsl:text>},</xsl:text>
	<xsl:text>pdfkeywords={</xsl:text>
	<xsl:value-of select="o:Keywords"/>
	<xsl:text>},</xsl:text>
	<xsl:text>pdfauthor={</xsl:text>
	<xsl:value-of select="o:Author"/>
	<xsl:text>},</xsl:text>
	<xsl:text>pdfcreator={wordml2latex (by Ruggero Dambra, http://www25.brinkster.com/ruggdam)}, colorlinks=true, linkcolor=red, anchorcolor=black, citecolor=green, filecolor=magenta, menucolor=red, pagecolor=red, urlcolor=blue, breaklinks=true, pdfstartview=FitH, pdfpagemode=UseOutlines}</xsl:text>
	<xsl:value-of select="$par"/>
	<xsl:text>\title{</xsl:text>
	<xsl:value-of select="o:Title"/>
	<xsl:text>}</xsl:text> 
	<xsl:value-of select="$cr"/>
	<xsl:text>\author{</xsl:text>
	<xsl:value-of select="o:Author"/>
	<xsl:text>}</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>\date{</xsl:text>
	<xsl:value-of select="substring(o:LastSaved,9,2)"/>
	<xsl:text>/</xsl:text>
	<xsl:value-of select="substring(o:LastSaved,6,2)"/>
	<xsl:text>/</xsl:text>
	<xsl:value-of select="substring(o:LastSaved,1,4)"/>
	<xsl:text>}</xsl:text>
</xsl:template>

<!-- Contents of the document to be written between \begin{document} and \end{document} --> 
<xsl:template name="Body" match="w:body">
	<xsl:apply-templates/>
</xsl:template>

<!-- Main document transform -->
<xsl:template name="Document" match="/w:wordDocument">
	<xsl:text>% This file was created by wordml2latex version </xsl:text>
	<xsl:value-of select="$version"/>
	<xsl:text>, Copyright (C) 2005 Ruggero Dambra</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>% wordml2latex comes with ABSOLUTELY NO WARRANTY; for details read wordml2latex.pdf.</xsl:text>
	<xsl:value-of select="$cr"/>
	<xsl:text>% This is free software, and you are welcome to redistribute it under certain conditions; read wordml2latex.pdf for details.</xsl:text>
	<xsl:value-of select="$par"/>
	<xsl:apply-templates select="o:DocumentProperties"/>
	<xsl:value-of select="$par"/>
	<xsl:text>\newcommand{\wl}{{\sffamily WordML}{\Large 2}\LaTeX{}}</xsl:text>
	<xsl:value-of select="$par"/>
	<xsl:text>\begin{document}</xsl:text>
	<xsl:apply-templates select="w:body"/>
	<xsl:value-of select="$cr"/>
	<xsl:text>\end{document}</xsl:text>
</xsl:template>

</xsl:stylesheet>