/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.table;

import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.TextAlign;
import com.github.ajalt.mordant.rendering.Widget;
import com.github.ajalt.mordant.table.Cell;
import com.github.ajalt.mordant.table.CsvQuoting;
import com.github.ajalt.mordant.table.Table;
import com.github.ajalt.mordant.table.TableImpl;
import com.github.ajalt.mordant.table.TableWithCaption;
import com.github.ajalt.mordant.terminal.Terminal;
import com.github.ajalt.mordant.terminal.TerminalRecorder;
import com.github.ajalt.mordant.widgets.Padded;
import com.github.ajalt.mordant.widgets.Text;
import com.github.ajalt.mordant.widgets.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001aM\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a\u0018\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u000e0\u000e*\u00020\u0002H\u0002\u00a8\u0006\u000f"}, d2={"contentToCsv", "", "Lcom/github/ajalt/mordant/table/Table;", "delimiter", "", "quoteChar", "escapeChar", "doubleQuote", "", "lineTerminator", "quoting", "Lcom/github/ajalt/mordant/table/CsvQuoting;", "(Lcom/github/ajalt/mordant/table/Table;CCLjava/lang/Character;ZLjava/lang/String;Lcom/github/ajalt/mordant/table/CsvQuoting;)Ljava/lang/String;", "getContentRows", "", "mordant"})
@SourceDebugExtension(value={"SMAP\nTableCsv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TableCsv.kt\ncom/github/ajalt/mordant/table/TableCsvKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,122:1\n1557#2:123\n1628#2,2:124\n1557#2:126\n1628#2,2:127\n1630#2:130\n1630#2:131\n1#3:129\n1088#4,2:132\n*S KotlinDebug\n*F\n+ 1 TableCsv.kt\ncom/github/ajalt/mordant/table/TableCsvKt\n*L\n108#1:123\n108#1:124,2\n109#1:126\n109#1:127,2\n109#1:130\n108#1:131\n82#1:132,2\n*E\n"})
public final class TableCsvKt {
    @NotNull
    public static final String contentToCsv(@NotNull Table $this$contentToCsv, char delimiter, char quoteChar, @Nullable Character escapeChar, boolean doubleQuote, @NotNull String lineTerminator, @NotNull CsvQuoting quoting) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter($this$contentToCsv, "<this>");
        Intrinsics.checkNotNullParameter(lineTerminator, "lineTerminator");
        Intrinsics.checkNotNullParameter((Object)quoting, "quoting");
        StringBuilder $this$contentToCsv_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        List<List<String>> rows = TableCsvKt.getContentRows($this$contentToCsv);
        Regex escapable = new Regex("" + '[' + delimiter + lineTerminator + ']');
        for (List<String> row : rows) {
            CollectionsKt.joinTo$default(row, $this$contentToCsv_u24lambda_u246, ",", null, null, 0, null, arg_0 -> TableCsvKt.contentToCsv$lambda$6$lambda$5(escapeChar, doubleQuote, quoteChar, quoting, escapable, arg_0), 60, null);
            $this$contentToCsv_u24lambda_u246.append(lineTerminator);
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    public static /* synthetic */ String contentToCsv$default(Table table, char c, char c2, Character c3, boolean bl, String string, CsvQuoting csvQuoting, int n, Object object) {
        if ((n & 1) != 0) {
            c = (char)44;
        }
        if ((n & 2) != 0) {
            c2 = (char)34;
        }
        if ((n & 4) != 0) {
            c3 = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            string = "\n";
        }
        if ((n & 0x20) != 0) {
            csvQuoting = CsvQuoting.MINIMAL;
        }
        return TableCsvKt.contentToCsv(table, c, c2, c3, bl, string, csvQuoting);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<List<String>> getContentRows(Table $this$getContentRows) {
        void $this$mapTo$iv$iv;
        List<List<Cell>> list;
        Table table = $this$getContentRows;
        if (table instanceof TableImpl) {
            list = ((TableImpl)$this$getContentRows).getRows();
        } else if (table instanceof TableWithCaption) {
            list = ((TableWithCaption)$this$getContentRows).getTable().getRows();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List<List<Cell>> rows = list;
        Terminal t = new Terminal(null, null, null, null, null, null, null, 0, null, new TerminalRecorder(AnsiLevel.NONE, Integer.MAX_VALUE, Integer.MAX_VALUE, false, false, false, false, 64, null), 511, null);
        Iterable $this$map$iv = rows;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void row;
            List list2 = (List)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv2 = (Iterable)row;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                String string;
                void cell;
                Cell cell2 = (Cell)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                void var22_22 = cell;
                if (var22_22 instanceof Cell.Empty) {
                    string = "";
                } else if (var22_22 instanceof Cell.SpanRef) {
                    string = "";
                } else if (var22_22 instanceof Cell.Content) {
                    Widget it = ((Cell.Content)cell).getContent();
                    boolean bl3 = false;
                    Widget widget = it instanceof Padded ? ((Padded)it).getContent$mordant() : it;
                    if (!(widget instanceof Text)) {
                        boolean bl4 = false;
                        String string2 = "Only Text widgets can be rendered as csv";
                        throw new IllegalArgumentException(string2.toString());
                    }
                    string = t.render(TextKt.withAlign$default(widget, TextAlign.NONE, null, 2, null));
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                collection2.add(string);
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    private static final CharSequence contentToCsv$lambda$6$lambda$5$lambda$3(Character $escapeChar, MatchResult it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return $escapeChar + it.getValue();
    }

    private static final CharSequence contentToCsv$lambda$6$lambda$5(Character $escapeChar, boolean $doubleQuote, char $quoteChar, CsvQuoting $quoting, Regex $escapable, String cell) {
        boolean bl;
        String string;
        Object escapesEscaped;
        block16: {
            Object object;
            block15: {
                Intrinsics.checkNotNullParameter((Object)$quoting, "$quoting");
                Intrinsics.checkNotNullParameter($escapable, "$escapable");
                Intrinsics.checkNotNullParameter(cell, "cell");
                object = $escapeChar;
                if (object == null) break block15;
                char it = ((Character)object).charValue();
                boolean bl2 = false;
                String string2 = StringsKt.replace$default(cell, String.valueOf(it), "" + it + it, false, 4, null);
                object = string2;
                if (string2 != null) break block16;
            }
            object = escapesEscaped = cell;
        }
        if (!($doubleQuote || $escapeChar != null || !StringsKt.contains$default((CharSequence)cell, $quoteChar, false, 2, null))) {
            boolean $i$a$-require-TableCsvKt$contentToCsv$1$1$22 = false;
            String $i$a$-require-TableCsvKt$contentToCsv$1$1$22 = "Content requires escaping, but no escapeChar set";
            throw new IllegalArgumentException($i$a$-require-TableCsvKt$contentToCsv$1$1$22.toString());
        }
        String quotesEscaped = StringsKt.replace$default((String)escapesEscaped, String.valueOf($quoteChar), $doubleQuote && $quoting != CsvQuoting.NONE ? "" + $quoteChar + $quoteChar : "" + $escapeChar + $quoteChar, false, 4, null);
        if (WhenMappings.$EnumSwitchMapping$0[$quoting.ordinal()] == 1) {
            if (!($escapeChar != null || !$escapable.containsMatchIn(cell))) {
                boolean $i$a$-require-TableCsvKt$contentToCsv$1$1$allEscaped$22 = false;
                String $i$a$-require-TableCsvKt$contentToCsv$1$1$allEscaped$22 = "Content requires escaping, but no escapeChar set";
                throw new IllegalArgumentException($i$a$-require-TableCsvKt$contentToCsv$1$1$allEscaped$22.toString());
            }
            string = $escapable.replace((CharSequence)quotesEscaped, arg_0 -> TableCsvKt.contentToCsv$lambda$6$lambda$5$lambda$3($escapeChar, arg_0));
        } else {
            string = quotesEscaped;
        }
        String allEscaped = string;
        block0 : switch (WhenMappings.$EnumSwitchMapping$0[$quoting.ordinal()]) {
            case 2: {
                bl = true;
                break;
            }
            case 3: {
                if (($escapeChar == null || $doubleQuote) && StringsKt.contains$default((CharSequence)cell, $quoteChar, false, 2, null) || $escapable.containsMatchIn(cell)) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                CharSequence $this$any$iv = cell;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl3 = false;
                    boolean bl4 = '0' <= it ? it < ':' : false;
                    if (!(!bl4)) continue;
                    bl = true;
                    break block0;
                }
                bl = false;
                break;
            }
            case 1: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean needsQuote = bl;
        return needsQuote ? (CharSequence)('\"' + allEscaped + '\"') : (CharSequence)allEscaped;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CsvQuoting.values().length];
            try {
                nArray[CsvQuoting.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CsvQuoting.ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CsvQuoting.MINIMAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CsvQuoting.NONNUMERIC.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

