comment!
[*]------------------------------------------------------------------[*]
    SOURCE: et.asm
    PROJECT: EasyTeX
    PURPOSE: Overlay loader. Loads the main program. The main program
             may execute other programs wich then exit back to et.com
             (et.asm). et.com checks ovlname[0] to see if the main
             program should be executed again.
[*]------------------------------------------------------------------[*]
   (c)Copyright ITLR 1992-1994		     written by M. Schollmeyer
[*]------------------------------------------------------------------[*]
   History: 11/15/1992 - Major Rewrite
[*]------------------------------------------------------------------[*]
!
include version.inc                       ; include file made by 'version'
MAXPATH     EQU 127                       ; max. chars in path variables

stackseg    segment stack                 ; remains empty
stackseg    ends

codeseg     segment
codeseg     ends

;----------------------------------------------------------------------
;-- D A T A - S E G M E N T                                          --
;----------------------------------------------------------------------

dataseg segment para

banner  db      'EasyTeX  Version ',VERSIONSTRING
        db      '  Release ',RELEASESTRING,10,13
	db	'          (c)Copyright ITLR 1990-1994'
cr      db      10,13,'$'

pause   db      10,13,'Press any key to return to EasyTeX$'
errmsg  db      10,13,'Could not execute main program',10,13,'$'

hextab  db      '0123456789abcdef'        ; table for hex char convertion
ovlext  db      'ovl',0                   ; extension for overlay

ovllen  db      0
; this memory region is common to 'et.com' and 'et.ovl'
magic   dd      34f65da2h                 ; This value is checked by et.ovl
                                          ; for savety.
ovlname db      MAXPATH dup (0)           ; program name for overlay
optname db      '/et:'                    ; arguments passed back to 'et.ovl'
memptr  db      'xxxx:xxxx'
        db      ' '
ovlargs db      MAXPATH dup (0)
wflag   db      0                         ; wait for key if this byte is 1
rettype db      0                         ; return code of last spawn
retcode db      0
excode  db     0                         ; 1 if overlay should be executed

parmblkstruct struc
    penvseg  dw ?
    pcmdoff  dw ?
    pcmdseg  dw ?
    pfcb1off dw ?
    pfcb1seg dw ?
    pfcb2off dw ?
    pfcb2seg dw ?
parmblkstruct ends

progend label   byte

dataseg ends

groupseg    group   codeseg,dataseg
            assume cs:groupseg
            assume ds:groupseg
            assume es:groupseg

;----------------------------------------------------------------------
;-- C O D E - S E G M E N T                                          --
;----------------------------------------------------------------------

codeseg segment para

        ;-- Declaration of the PSP --------------------------

            org     2ch
envseg      dw      ?                     ; Segment for Environment
            org     5ch
parmblk     dw      7 dup (?)             ; FCB fields will be used
                                          ; for exec parameter block
            org     80h
parmlen     db      ?                     ; Length of parameter line
parmline    db      127 dup (?)           ; parameter line
                                          ; will be used for stack later
stackpos    label byte
            org     100h                  ; Code set

;-- Main function -----------------------------------------------------
;               Initializes the program variables and then enters the
;               main loop. This loop executes the main program. On
;               return it checks to see if the main program should
;               be executed again.

main        proc near

            mov     sp, offset groupseg:stackpos

            mov     ah, 4ah               ; set program size
            mov     bx, offset groupseg:progend + 15
            mov     cl, 4                 ; get size in paragraphs
            shr     bx, cl
            int     21h

            mov     ah, 09h               ; display banner
            mov     dx, offset groupseg:banner
            int     21h

            mov     ax, word ptr envseg   ; adjust segments in parmblk
            mov     parmblk.penvseg, ax
            mov     ax, cs
            mov     parmblk.pcmdseg, ax
            mov     parmblk.pfcb1seg, ax
            mov     parmblk.pfcb2seg, ax

            call    setovlname            ; initialize strings
	    call    setovlarg

	    .REPEAT
		.IF byte ptr [wflag] != 0
		    mov	   ah, 09h		   ; display pause message
		    mov	   dx, offset groupseg:pause
		    int	   21h
		    xor	   ah, ah		   ; read a key
		    int	   16h
		    mov	   ah, 09h		   ; print carriage return
		    mov    dx, offset groupseg:cr
		    int    21h
		.ENDIF

		mov	bp, offset groupseg:optname
		call	exec		   ; execute main program

	    .UNTIL excode==0

            mov     ax, 4c00h             ; terminate program
            int     21h

main        endp

;-- subroutines -------------------------------------------------------

;-- setovlname --------------------------------------------------------
;               Sets the overlay program name to ovlname.
;               Program path and base name is read from the environment.
;               Program extension is taken from 'ovlext'. This part of code
;               is executed outside the main loop.

setovlname  proc near

            mov     es, word ptr envseg   ; load environment pointer
            xor     di, di                ; set offset
	    xor     al, al		  ; set scan byte

	    .REPEAT
		mov	cx, 0ffffh	   ; maximum size
		cld			   ; scan down
		repne	scasb		   ; scan for '\0'
	    .UNTIL byte ptr es:[di] == 0

            add     di, 3                 ; now we reached the end of the
                                          ; environment. Skip teminating
                                          ; '\0' and a word of info.
                                          ; copy the whole string to 'ovlname'
            mov     si, di                ; set source index
            push    es                    ; swap the registers es <-> ds since
            push    ds                    ; movsb (strcpy) works from
            pop     es                    ; ds:si to es:di
            pop     ds
                                          ; set destination index
            mov     di, offset groupseg:ovlname
            call    strcpy                ; copy string
            push    es                    ; restore ds
            pop     ds
            mov     al, '.'               ; scan reverse for dot
            std
            repne   scasb
            inc     di                    ; this is not save, increment to
                                          ; point to '.'
            inc     di                    ; increment to point to first char
                                          ; concat ovlext
            mov     si, offset groupseg:ovlext
                                          ; copy string
            call    strcpy

            ret

setovlname  endp

;-- setovlarg ---------------------------------------------------------
;               Sets the arguments for overlay program.
;               The first argument is always the memory location.
;               The following arguments are taken from the parameter
;               line. This part of code is executed outside the main loop.

setovlarg   proc near

                                          ; first argument is memory
                                          ; location of shared memory
            mov     di, offset groupseg:memptr
            mov     ax, ds                ; convert segment address
            call    convhex
            inc     di                    ; skip ':'
            mov     ax, offset groupseg:magic
            call    convhex               ; convert offset address
            inc     di                    ; copy 'parmline' to 'ovlargs'
            mov     si, offset groupseg:parmline
            xor     ch, ch                ; get length of 'parmline'
            mov     cl, byte ptr [parmlen]
	    rep     movsb

            ret

setovlarg endp

;-- convhex -----------------------------------------------------------
;               Converts a binary 16-bit value in 'ax' into ASCII chars
;               stored in [di]

convhex     proc near

            mov     cl, 4                 ; get shift value
            rol     ax, cl                ; rotate to get first char value
            call    convhexchar           ; convert to ASCII char
            rol     ax, cl                ; get next char value
            call    convhexchar           ;    ...
            rol     ax, cl
            call    convhexchar
            rol     ax, cl
            call    convhexchar

            ret

convhex     endp

;-- convhexchar -------------------------------------------------------
;               Converts a binary 4-bit value in 'al' into a hex
;               char stored in [di]

convhexchar proc near

            push    ax                    ; save old value
            and     ax, 1111b             ; mask lower 4 bits
            mov     bp, ax                ; use it as an offset to 'hextab'
            mov     al, byte ptr hextab[bp]
            stosb                         ; store in destination
            pop     ax                    ; restore old value

            ret

convhexchar endp

;-- exec --------------------------------------------------------------
;               Executes a program with name in 'ovlname' and
;               arguments in [bp]. Also gets length of argument
;               string and stores it in [bp-1]
;               Also checks for error and displays message.

exec        proc near

            mov     di, bp                ; get length of string
            cld                           ; scan down
	    mov     cx, 0ffffh
            xor     al, al                ; scan for '\0'
            repnz   scasb
            not     cx                    ; convert to size of string

            dec     bp                    ; bp points to size field
            mov     byte ptr [bp], cl     ; store size
                                          ; store name of program
            mov     dx, offset groupseg:ovlname
            mov     parmblk.pcmdoff, bp   ; store arguments
            mov     ax, 4b00h             ; execute program
            mov     bx, offset groupseg:parmblk
            int     21h

	    .IF CARRY?			  ; check for error
		mov	ah, 09h
		mov	dx, offset groupseg:errmsg
		int	21h
		mov	byte ptr [ovlname], 0 ; mark to exit in main loop
	    .ENDIF

	    mov	    ah, 4dh		     ; get return code
            int     21h
            mov     byte ptr [retcode], al
            mov     byte ptr [rettype], ah

            ret

exec        endp

;-- strcpy ------------------------------------------------------------
;               Copies a ASCIIZ-String
;               from ds:si to es:di

strcpy      proc near

	    cld 			  ; scan down

	    .REPEAT
		lodsb			   ; get char
		stosb			   ; store char
	    .UNTIL al == 0

            dec     di                    ; decrement to point to last char
            dec     si

            ret

strcpy      endp

;----------------------------------------------------------------------

codeseg     ends
            end main


; end of file et.asm
