/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import nts.align.Alignment;
import nts.align.AnyUnsetNode;
import nts.align.VAlignBuilder;
import nts.base.Dimen;
import nts.base.Glue;
import nts.builder.Builder;
import nts.builder.ListBuilder;
import nts.builder.VBoxBuilder;
import nts.command.CommandBase;
import nts.command.Token;
import nts.command.TokenList;
import nts.io.Log;
import nts.node.AnyBoxNode;
import nts.node.AnySkipNode;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.NamedVSkipNode;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.SizesSummarizer;
import nts.node.VBoxNode;
import nts.node.VSkipNode;
import nts.node.VertIterator;
import nts.typo.TypoCommand;

public class VertAlignment
extends Alignment {
    protected final ListBuilder builder;
    protected VBoxBuilder rowBuilder;
    protected VBoxBuilder spanBuilder;

    protected void startNonAligned() {
        super.startNonAligned();
        TypoCommand.getTypoConfig().resetParagraph();
    }

    protected void startSpan(int index) {
        super.startSpan(index);
        TypoCommand.getTypoConfig().resetParagraph();
    }

    protected void pushNewRowBuilder() {
        this.rowBuilder = new VAlignBuilder(CommandBase.currLineNumber());
        Builder.push(this.rowBuilder);
    }

    protected void pushNewSpanBuilder() {
        this.spanBuilder = new VBoxBuilder(CommandBase.currLineNumber());
        Builder.push(this.spanBuilder);
    }

    protected void addNamedSkipToRow(Glue skip, String name) {
        this.rowBuilder.addNamedSkip(skip, name);
    }

    protected Dimen packedSpanSize(int spanCount) {
        NodeList list = this.spanBuilder.getList();
        Builder.pop();
        this.spanBuilder = null;
        SizesSummarizer pack = new SizesSummarizer();
        VertIterator.summarize(list.nodes(), pack);
        Dimen size = pack.getBody().plus(pack.getHeight()).plus(pack.getDepth());
        BoxSizes sizes = new BoxSizes(size, pack.getWidth(), Dimen.ZERO, pack.getLeftX());
        byte strOrder = pack.maxTotalStr();
        byte shrOrder = pack.maxTotalShr();
        this.rowBuilder.addNode(new AnyUnsetNode(sizes, list, spanCount, pack.getTotalStr(strOrder), strOrder, pack.getTotalShr(shrOrder), shrOrder));
        return size;
    }

    protected void packRow() {
        NodeList list = this.rowBuilder.getList();
        Builder.pop();
        this.rowBuilder = null;
        TypoCommand.appendBox(this.builder, new AnyUnsetNode(VertIterator.naturalSizes(list.nodes(), null), list));
    }

    protected NodeEnum getUnsetNodes() {
        return this.builder.getList().nodes();
    }

    protected Dimen getRelevantSize(BoxSizes sizes) {
        return sizes.getHeight();
    }

    protected BoxSizes transformSizes(BoxSizes sizes, Dimen dim) {
        return sizes.withHeight(dim);
    }

    protected AnyBoxNode makeBox(BoxSizes sizes, GlueSetting setting, NodeList list) {
        return new VBoxNode(sizes, setting, list);
    }

    protected AnySkipNode makeSkip(Glue skip) {
        return new VSkipNode(skip);
    }

    protected AnySkipNode makeSkip(Glue skip, String name) {
        return new NamedVSkipNode(skip, name);
    }

    protected TypoCommand.AnyBoxPacker makeBoxPacker() {
        VertAlignment vertAlignment = this;
        if (vertAlignment == null) {
            throw null;
        }
        return new TypoCommand.VBoxPacker(vertAlignment){
            private final /* synthetic */ VertAlignment this$0;

            protected void reportLocation(Log log) {
                log.add("in alignment at lines ").add(this.this$0.builder.getStartLine()).add("--").add(CommandBase.currLineNumber());
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(VertAlignment vertAlignment) {
            }
        };
    }

    public void copyPrevParameters(Builder bld) {
        bld.setSpaceFactor(this.builder.getSpaceFactor());
    }

    public VertAlignment(Dimen size, boolean exactly, TokenList.Inserter everyCr, Token frzCr, Token frzEndt, ListBuilder builder) {
        super(size, exactly, everyCr, frzCr, frzEndt);
        this.builder = builder;
    }
}

