/*
 * Decompiled with CFR 0.152.
 */
package nts.math;

import nts.base.Dimen;
import nts.builder.Builder;
import nts.command.CommandBase;
import nts.command.TokenList;
import nts.io.Log;
import nts.math.DisplayGroup;
import nts.math.FormulaGroup;
import nts.math.MathPrim;
import nts.math.OpenMath;
import nts.node.LinesShape;
import nts.node.NodeList;
import nts.typo.Action;
import nts.typo.BuilderCommand;
import nts.typo.Paragraph;
import nts.typo.TypoCommand;

public class OpenMath
extends BuilderCommand {
    public static final int INTP_DISPLAY_WIDOW_PENALTY = CommandBase.newIntParam();
    private static final Dimen NO_WIDTH = Dimen.MAX_VALUE.negative();
    private TokenList.Inserter everyMath;
    private TokenList.Inserter everyDisplay;
    public final Action OPEN_MATH;
    public final Action OPEN_FORMULA;

    protected void startDisplay() {
        Dimen preSize;
        Dimen.Par lastVisibleWidth = new Dimen.Par(NO_WIDTH);
        Builder parBld = TypoCommand.getBld();
        NodeList list = parBld.getParagraph();
        if (list != null) {
            Paragraph.lineBreak(list, parBld.getStartLine(), CommandBase.getConfig().getIntParam(INTP_DISPLAY_WIDOW_PENALTY), parBld.getInitLang(), lastVisibleWidth);
        }
        if ((preSize = lastVisibleWidth.get()) == null) {
            preSize = Dimen.MAX_VALUE;
        } else if (preSize != NO_WIDTH) {
            preSize = preSize.plus(TypoCommand.getCurrFontMetric().getDimenParam(5).times(2));
        }
        LinesShape shape = TypoCommand.getTypoConfig().linesShape();
        Builder old = TypoCommand.getBld();
        int lineNo = old.getPrevGraf() + 1;
        CommandBase.pushLevel(new DisplayGroup());
        MathPrim.getMathConfig().initDisplay(preSize, shape.getWidth(lineNo), shape.getIndent(lineNo));
        this.everyDisplay.insertToks();
        old.buildPage();
    }

    protected void startFormula() {
        CommandBase.pushLevel(new FormulaGroup());
        MathPrim.getMathConfig().initFormula();
        this.everyMath.insertToks();
    }

    public void addOn(Log log) {
        log.add("internal open math");
    }

    public OpenMath(TokenList.Inserter everyMath, TokenList.Inserter everyDisplay) {
        OpenMath openMath = this;
        if (openMath == null) {
            throw null;
        }
        this.OPEN_MATH = new 3(openMath);
        OpenMath openMath2 = this;
        if (openMath2 == null) {
            throw null;
        }
        this.OPEN_FORMULA = new 4(openMath2);
        this.everyMath = everyMath;
        this.everyDisplay = everyDisplay;
    }
}

