/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:       o2_lcl_opt.lex
Dates:      7 Apr. 2003
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |o2_lcl_opt| Thread.\fbreak
The grammar |o2_lcl_opts| calls it per option detected.
Options can be inputted in any order and all are optional.
Their appearance in the command line means 'y'.
Originally options were prefixed by a slash but
i converted to the UNIX use of a minus sign.
Here they are:\fbreak 
\ptindent{-t ---  generate Terminals definitions }
\ptindent{-rc ---   generate Raw Chars definitions: deprecated }
\ptindent{-err ---  generate Error terminals definitions }
\ptindent{-lrk --- generate yacco2's LRK terminal constants definitions: deprecated}
\ptindent{-p --- generate pdf + post script(ps) documents}
Returned is the appropriate T indicating the option.
\fbreak
Note: \fbreak      
In the "parallel-la-boundary" construct this grammar demonstrates  
how one can fine tune
the look-ahead boundary to cope with a false option prefix 
eg, -tt. error reported at -t and not the next option re: 2nd t. 
|eolr| is too general for this refinement.
            
Also shown is the use of meta-terminals to 
indicate or contain the parsed results.
This is the cleanest way to communicate between threads. 
he agreement between the calling / called
threads is the meta-terminal. Use of Global variables 
is efficient but ugly and unco-ordinated due to
the random write access to the Global variable.\fbreak
\fbreak
Modifications:\fbreak
Date: 19 Oct. 2003\fbreak
Reason:\fbreak
Modify rule names to be shorter and more concise. 
Originally the encoding rule
for the grammar rule name was R {$+$} 
``thread name prefix'' {$+$} ``name given to rule''
where the plus sign indicates concatenation.
This made it volumous in the traces.\fbreak
\fbreak
Reason:\fbreak
Add new switches to support:\fbreak
/dbg turn on debuging of grammar to be compiled. this is a convenience to the
author instead of using the editor to change the grammar's source code
of fsm-debug "true" to "true"; once finished debugging, re-use the editor to
restore the source code back to fsm-debug "true". \fbreak
\fbreak
Date: 2 June 2005\fbreak
Reason:\fbreak
Remove /s:xxx switch. Compilers should be robust enough to deal with
reasonably large files. Nod to Microsoft current compiler
@/

fsm	
(fsm-id "o2_lcl_opt.lex",fsm-filename o2_lcl_opt,fsm-namespace NS_o2_lcl_opt
,fsm-class Co2_lcl_opt{
/@
Trap the failed option and return a bad command.
This covers errors like the premature prefix -e where it should
be -err. i could have been less specific to trap
non first set options (-z) by defaulting  to this
facility but i'm teaching myself...
As this thread is executed according to its first set ``-'',
any failed attempt is a bad option.
Please note the use of the |RSVP_FSM| macro.
Its context is different than the normal Rule's
use of |RSVP| macro.
@/
  failed
       CAbs_lr1_sym* sym = new Err_bad_cmd_lne_opt;
       sym->set_rc(*parser__->start_token__,__FILE__,__LINE__);
       RSVP_FSM(sym);
       return true;
  ***
} 
,fsm-version "1.1",fsm-date "18 Oct. 2003",fsm-debug "false"
,fsm-comments "\\O2's individual command line option recognizer.")
parallel-parser	
(	
  parallel-thread-function
    TH_o2_lcl_opt
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Ro2_lcl_opt (
){
  -> Rminus Rspec_parm Rmust_lint{
    op
        sf->p2__->rtn_parm_->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
        RSVP(sf->p2__->rtn_parm_);
    ***
    }
}
 
Rminus (){
  -> "-" 
}

Rspec_parm (
lhs {
  user-declaration
    public:
    CAbs_lr1_sym* rtn_parm_;
  ***
  }
){
  ->
  /@
Generate Terminals vocabulary.  
  @/
"t" 
  {
    op
      rtn_parm_ = new T_option_t;
    ***
    }
  ->
  /@
Generate Terminals vocabulary.  
  @/
"p" 
  {
    op
      rtn_parm_ = new T_option_p;
    ***
    }
  -> 
/@
Generate Raw characters vocabulary.
Watch out as this is only used at bootstrap time of \O2.
Users of \O2 should not use it unless they are experimenting.  
@/
"r" "c" 
{
    op
      rtn_parm_ = new Err_bad_cmd_lne_opt;
       rtn_parm_->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    ***
    }
  -> 
/@
Generate Error vocabulary.
@/
"e" "r" "r"
{
    op
      rtn_parm_ = new T_option_err;
    ***
    }
  ->
/@
Generate LR K vocabulary.
Watch out as this is only used at bootstrap time of \O2.
Users of \O2 should not use it unless they are experimenting.
Currently not supported.  
@/
"l" "r" "k" {
    op
      rtn_parm_ = new Err_bad_cmd_lne_opt;
       rtn_parm_->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    ***
    }
  -> |?|  //catch bad attempts at options
  {
    op
       rtn_parm_ = new Err_bad_cmd_lne_opt;
       rtn_parm_->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
    ***
  }
}
Rmust_lint (){
  -> "x09" // tab
  -> " " 
  -> |+|  //catch suffixed extras on option
  {
    op
       parser()->set_abort_parse(true);
    ***
  }
}

}// end of rules
