/*
 * baseop.h
 *
 * AUTHORS: Robert Fahy <rfahy@ymail.com>
 * CREDITS: n/a
 * VERSION: 1.00
 *
 */

/*
 * TASK:
 * - declare basic operations which are not intrinsic to XOR-FD
 *
 */

/*
 * TODO:
 * - n/a
 *
 */

#ifndef _BASEOP_H_INCLUDED_
#define _BASEOP_H_INCLUDED_

// standard include files
#include <stdio.h>

// environment-specific include files
#include <sys/types.h>

// custom include files
#include "error.h"

// these are used to handle cleanup after signals
#define XORFD_ABORT			0
#define XORFD_CONTINUE		1

// ABOUT: conceived to mask the duplicate code
#define FCLOSE_VERBOSE(file)	\
{\
	if (fclose(file) == EOF)\
		PRINT_ERROR("fclose()");\
	else ;\
}

// declarations without definitions (aka prototypes)
void signals_setup(void);
void signal_handler(int signal);
void print_usage(const char *program_filename, const char *message);
unsigned char get_percentage(const off64_t full, const off64_t current);
off64_t get_file_size_tame(FILE *file);
off64_t get_file_size(FILE *file);

#endif /* _BASEOP_H_INCLUDED_ */
