/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.apache.activemq.jaas.LDAPLoginModule;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.jasypt.properties.EncryptableProperties;

public class EncryptableLDAPLoginModule
extends LDAPLoginModule {
    private static final String ENCRYPTION_PASSWORD = "encryptionPassword";
    private static final String PASSWORD_ENV_NAME = "passwordEnvName";
    private static final String PASSWORD_ALGORITHM = "encryptionAlgorithm";
    private static final String DEFAULT_PASSWORD_ENV_NAME = "ACTIVEMQ_ENCRYPTION_PASSWORD";
    private static final String DEFAULT_PASSWORD_ALGORITHM = "PBEWithMD5AndDES";
    private final StandardPBEStringEncryptor configurationEncryptor = new StandardPBEStringEncryptor();

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        String encryptionPassword = (String)options.get(ENCRYPTION_PASSWORD);
        String passwordEnvName = options.get(PASSWORD_ENV_NAME) != null ? (String)options.get(PASSWORD_ENV_NAME) : DEFAULT_PASSWORD_ENV_NAME;
        String passwordAlgorithm = options.get(PASSWORD_ALGORITHM) != null ? (String)options.get(PASSWORD_ALGORITHM) : DEFAULT_PASSWORD_ALGORITHM;
        EnvironmentStringPBEConfig envConfig = new EnvironmentStringPBEConfig();
        envConfig.setAlgorithm(passwordAlgorithm);
        if (passwordAlgorithm.startsWith("PBE") && passwordAlgorithm.contains("AES")) {
            envConfig.setIvGenerator((IvGenerator)new RandomIvGenerator());
        }
        if (encryptionPassword == null) {
            envConfig.setPasswordEnvName(passwordEnvName);
        } else {
            envConfig.setPassword(encryptionPassword);
        }
        this.configurationEncryptor.setConfig((PBEConfig)envConfig);
        EncryptableProperties encryptableOptions = new EncryptableProperties((StringEncryptor)this.configurationEncryptor);
        encryptableOptions.putAll(options);
        super.initialize(subject, callbackHandler, sharedState, (Map)encryptableOptions);
    }
}

