/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import java.util.Optional;
import java.util.function.Function;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.web.servlet.function.RequestPredicate;
import org.springframework.web.servlet.function.ServerRequest;

class PredicateResourceLookupFunction
implements Function<ServerRequest, Optional<Resource>> {
    private final RequestPredicate predicate;
    private final Resource resource;

    public PredicateResourceLookupFunction(RequestPredicate predicate, Resource resource) {
        Assert.notNull((Object)predicate, (String)"'predicate' must not be null");
        Assert.notNull((Object)resource, (String)"'resource' must not be null");
        this.predicate = predicate;
        this.resource = resource;
    }

    @Override
    public Optional<Resource> apply(ServerRequest serverRequest) {
        return this.predicate.test(serverRequest) ? Optional.of(this.resource) : Optional.empty();
    }
}

