/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.IndexAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.CompilableIndexAccessor;
import org.springframework.expression.spel.CompilablePropertyAccessor;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.AccessorUtils;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.StringLiteral;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.expression.spel.support.ReflectivePropertyAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class Indexer
extends SpelNodeImpl {
    private final boolean nullSafe;
    @Nullable
    private IndexedType indexedType;
    @Nullable
    private volatile String originalPrimitiveExitTypeDescriptor;
    @Nullable
    private volatile String arrayTypeDescriptor;
    @Nullable
    private volatile CachedPropertyState cachedPropertyReadState;
    @Nullable
    private volatile CachedPropertyState cachedPropertyWriteState;
    @Nullable
    private volatile CachedIndexState cachedIndexReadState;
    @Nullable
    private volatile CachedIndexState cachedIndexWriteState;

    @Deprecated(since="6.2", forRemoval=true)
    public Indexer(int startPos, int endPos, SpelNodeImpl indexExpression) {
        this(false, startPos, endPos, indexExpression);
    }

    public Indexer(boolean nullSafe, int startPos, int endPos, SpelNodeImpl indexExpression) {
        super(startPos, endPos, indexExpression);
        this.nullSafe = nullSafe;
    }

    @Override
    public final boolean isNullSafe() {
        return this.nullSafe;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state, AccessMode.READ).getValue();
    }

    @Override
    public TypedValue setValueInternal(ExpressionState state, Supplier<TypedValue> valueSupplier) throws EvaluationException {
        TypedValue typedValue = valueSupplier.get();
        this.getValueRef(state, AccessMode.WRITE).setValue(typedValue.getValue());
        return typedValue;
    }

    @Override
    public boolean isWritable(ExpressionState expressionState) throws SpelEvaluationException {
        return this.getValueRef(expressionState, AccessMode.WRITE).isWritable();
    }

    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state, AccessMode.READ_WRITE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueRef getValueRef(ExpressionState state, AccessMode accessMode) throws EvaluationException {
        TypedValue indexValue;
        Object index;
        SpelNodeImpl spelNodeImpl;
        TypedValue context = state.getActiveContextObject();
        Object target = context.getValue();
        if (target == null) {
            if (this.nullSafe) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.CANNOT_INDEX_INTO_NULL_VALUE, new Object[0]);
        }
        TypeDescriptor targetDescriptor = context.getTypeDescriptor();
        if (target instanceof Map && (spelNodeImpl = this.children[0]) instanceof PropertyOrFieldReference) {
            PropertyOrFieldReference reference = (PropertyOrFieldReference)spelNodeImpl;
            index = reference.getName();
            indexValue = new TypedValue(index);
        } else {
            try {
                state.pushActiveContextObject(state.getRootContextObject());
                indexValue = this.children[0].getValueInternal(state);
                index = indexValue.getValue();
                Assert.state(index != null, "No index");
            }
            finally {
                state.popActiveContextObject();
            }
        }
        Assert.state(targetDescriptor != null, "No type descriptor");
        if (target.getClass().isArray()) {
            int intIndex = Indexer.convertIndexToInt(state, index);
            this.indexedType = IndexedType.ARRAY;
            return new ArrayIndexingValueRef(state.getTypeConverter(), target, intIndex, targetDescriptor);
        }
        if (target instanceof List) {
            List list = (List)target;
            int intIndex = Indexer.convertIndexToInt(state, index);
            this.indexedType = IndexedType.LIST;
            return new CollectionIndexingValueRef(list, intIndex, targetDescriptor, state.getTypeConverter(), state.getConfiguration().isAutoGrowCollections(), state.getConfiguration().getMaximumAutoGrowSize());
        }
        if (target instanceof Map) {
            Map map = (Map)target;
            Object key = index;
            TypeDescriptor mapKeyTypeDescriptor = targetDescriptor.getMapKeyTypeDescriptor();
            if (mapKeyTypeDescriptor != null) {
                key = state.convertValue(key, mapKeyTypeDescriptor);
            }
            this.indexedType = IndexedType.MAP;
            return new MapIndexingValueRef(state.getTypeConverter(), map, key, targetDescriptor);
        }
        if (target instanceof String) {
            String string = (String)target;
            int intIndex = Indexer.convertIndexToInt(state, index);
            this.indexedType = IndexedType.STRING;
            return new StringIndexingValueRef(string, intIndex, targetDescriptor);
        }
        EvaluationContext evalContext = state.getEvaluationContext();
        List<IndexAccessor> accessorsToTry = AccessorUtils.getAccessorsToTry(target, evalContext.getIndexAccessors());
        if (accessMode.supportsReads) {
            try {
                for (IndexAccessor indexAccessor : accessorsToTry) {
                    if (!indexAccessor.canRead(evalContext, target, index)) continue;
                    this.indexedType = IndexedType.CUSTOM;
                    return new IndexAccessorValueRef(target, index, evalContext, targetDescriptor);
                }
            }
            catch (Exception ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_INDEX_READ, index, target.getClass().getTypeName());
            }
        }
        if (accessMode.supportsWrites) {
            try {
                for (IndexAccessor indexAccessor : accessorsToTry) {
                    if (!indexAccessor.canWrite(evalContext, target, index)) continue;
                    this.indexedType = IndexedType.CUSTOM;
                    return new IndexAccessorValueRef(target, index, evalContext, targetDescriptor);
                }
            }
            catch (Exception ex) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_INDEX_WRITE, index, target.getClass().getTypeName());
            }
        }
        if (target instanceof Collection) {
            Collection collection = (Collection)target;
            int intIndex = Indexer.convertIndexToInt(state, index);
            return new CollectionIndexingValueRef(collection, intIndex, targetDescriptor, state.getTypeConverter(), state.getConfiguration().isAutoGrowCollections(), state.getConfiguration().getMaximumAutoGrowSize());
        }
        TypeDescriptor valueType = indexValue.getTypeDescriptor();
        if (valueType != null && String.class == valueType.getType()) {
            this.indexedType = IndexedType.OBJECT;
            return new PropertyAccessorValueRef(target, (String)index, state.getEvaluationContext(), targetDescriptor);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, targetDescriptor);
    }

    @Override
    public boolean isCompilable() {
        if (this.exitTypeDescriptor == null) {
            return false;
        }
        if (this.indexedType == IndexedType.ARRAY) {
            return this.arrayTypeDescriptor != null;
        }
        SpelNodeImpl index = this.children[0];
        if (this.indexedType == IndexedType.LIST) {
            return index.isCompilable();
        }
        if (this.indexedType == IndexedType.MAP) {
            return index instanceof PropertyOrFieldReference || index.isCompilable();
        }
        if (this.indexedType == IndexedType.OBJECT) {
            CompilablePropertyAccessor cpa;
            PropertyAccessor propertyAccessor;
            CachedPropertyState cachedPropertyReadState = this.cachedPropertyReadState;
            return index instanceof StringLiteral && cachedPropertyReadState != null && (propertyAccessor = cachedPropertyReadState.accessor) instanceof CompilablePropertyAccessor && (cpa = (CompilablePropertyAccessor)propertyAccessor).isCompilable();
        }
        if (this.indexedType == IndexedType.CUSTOM) {
            CompilableIndexAccessor cia;
            IndexAccessor indexAccessor;
            CachedIndexState cachedIndexReadState = this.cachedIndexReadState;
            return cachedIndexReadState != null && (indexAccessor = cachedIndexReadState.accessor) instanceof CompilableIndexAccessor && (cia = (CompilableIndexAccessor)indexAccessor).isCompilable() && index.isCompilable();
        }
        return false;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        String exitTypeDescriptor = this.exitTypeDescriptor;
        String descriptor = cf.lastDescriptor();
        if (descriptor == null) {
            cf.loadTarget(mv);
        }
        Label skipIfNull = null;
        if (this.nullSafe) {
            mv.visitInsn(89);
            skipIfNull = new Label();
            Label continueLabel = new Label();
            mv.visitJumpInsn(199, continueLabel);
            CodeFlow.insertCheckCast(mv, exitTypeDescriptor);
            mv.visitJumpInsn(167, skipIfNull);
            mv.visitLabel(continueLabel);
        }
        SpelNodeImpl index = this.children[0];
        if (this.indexedType == IndexedType.ARRAY) {
            String arrayTypeDescriptor = this.arrayTypeDescriptor;
            Assert.state(exitTypeDescriptor != null && arrayTypeDescriptor != null, "Array not compilable without descriptors");
            CodeFlow.insertCheckCast(mv, arrayTypeDescriptor);
            int insn = switch (arrayTypeDescriptor) {
                case "[D" -> 49;
                case "[F" -> 48;
                case "[J" -> 47;
                case "[I" -> 46;
                case "[S" -> 53;
                case "[B", "[Z" -> 51;
                case "[C" -> 52;
                default -> 50;
            };
            this.generateIndexCode(mv, cf, index, Integer.TYPE);
            mv.visitInsn(insn);
        } else if (this.indexedType == IndexedType.LIST) {
            mv.visitTypeInsn(192, "java/util/List");
            this.generateIndexCode(mv, cf, index, Integer.TYPE);
            mv.visitMethodInsn(185, "java/util/List", "get", "(I)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.MAP) {
            mv.visitTypeInsn(192, "java/util/Map");
            if (index instanceof PropertyOrFieldReference) {
                PropertyOrFieldReference reference = (PropertyOrFieldReference)index;
                String mapKeyName = reference.getName();
                mv.visitLdcInsn(mapKeyName);
            } else {
                this.generateIndexCode(mv, cf, index, Object.class);
            }
            mv.visitMethodInsn(185, "java/util/Map", "get", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
        } else if (this.indexedType == IndexedType.OBJECT) {
            if (!(index instanceof StringLiteral)) {
                throw new IllegalStateException("Index expression must be a StringLiteral, but was: " + index.getClass().getName());
            }
            StringLiteral stringLiteral = (StringLiteral)index;
            CachedPropertyState cachedPropertyReadState = this.cachedPropertyReadState;
            Assert.state(cachedPropertyReadState != null, "No cached PropertyAccessor for reading");
            PropertyAccessor propertyAccessor = cachedPropertyReadState.accessor;
            if (!(propertyAccessor instanceof CompilablePropertyAccessor)) {
                throw new IllegalStateException("Cached PropertyAccessor must be a CompilablePropertyAccessor, but was: " + cachedPropertyReadState.accessor.getClass().getName());
            }
            CompilablePropertyAccessor compilablePropertyAccessor = (CompilablePropertyAccessor)propertyAccessor;
            String propertyName = (String)stringLiteral.getLiteralValue().getValue();
            Assert.state(propertyName != null, "No property name");
            compilablePropertyAccessor.generateCode(propertyName, mv, cf);
        } else if (this.indexedType == IndexedType.CUSTOM) {
            CachedIndexState cachedIndexReadState = this.cachedIndexReadState;
            Assert.state(cachedIndexReadState != null, "No cached IndexAccessor for reading");
            IndexAccessor indexAccessor = cachedIndexReadState.accessor;
            if (!(indexAccessor instanceof CompilableIndexAccessor)) {
                throw new IllegalStateException("Cached IndexAccessor must be a CompilableIndexAccessor, but was: " + cachedIndexReadState.accessor.getClass().getName());
            }
            CompilableIndexAccessor compilableIndexAccessor = (CompilableIndexAccessor)indexAccessor;
            compilableIndexAccessor.generateCode(index, mv, cf);
        }
        cf.pushDescriptor(exitTypeDescriptor);
        if (skipIfNull != null) {
            if (this.originalPrimitiveExitTypeDescriptor != null) {
                CodeFlow.insertBoxIfNecessary(mv, this.originalPrimitiveExitTypeDescriptor);
            }
            mv.visitLabel(skipIfNull);
        }
    }

    private void generateIndexCode(MethodVisitor mv, CodeFlow cf, SpelNodeImpl indexNode, Class<?> indexType) {
        cf.generateCodeForArgument(mv, (SpelNode)indexNode, indexType);
    }

    @Override
    public String toStringAST() {
        return "[" + this.getChild(0).toStringAST() + "]";
    }

    private void setExitTypeDescriptor(String descriptor) {
        if (this.nullSafe && CodeFlow.isPrimitive(descriptor)) {
            this.originalPrimitiveExitTypeDescriptor = descriptor;
            this.exitTypeDescriptor = CodeFlow.toBoxedDescriptor(descriptor);
        } else {
            this.exitTypeDescriptor = descriptor;
        }
    }

    private static int convertIndexToInt(ExpressionState state, Object index) {
        return (Integer)state.convertValue(index, TypeDescriptor.valueOf(Integer.class));
    }

    private static Class<?> getObjectType(Object obj) {
        Class clazz;
        return obj instanceof Class ? (clazz = (Class)obj) : obj.getClass();
    }

    private static enum AccessMode {
        READ(true, false),
        WRITE(false, true),
        READ_WRITE(true, true);

        private final boolean supportsReads;
        private final boolean supportsWrites;

        private AccessMode(boolean supportsReads, boolean supportsWrites) {
            this.supportsReads = supportsReads;
            this.supportsWrites = supportsWrites;
        }
    }

    private static enum IndexedType {
        ARRAY,
        LIST,
        MAP,
        STRING,
        OBJECT,
        CUSTOM;

    }

    private class ArrayIndexingValueRef
    implements ValueRef {
        private final TypeConverter typeConverter;
        private final Object array;
        private final int index;
        private final TypeDescriptor typeDescriptor;

        ArrayIndexingValueRef(TypeConverter typeConverter, Object array, int index, TypeDescriptor typeDescriptor) {
            this.typeConverter = typeConverter;
            this.array = array;
            this.index = index;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Object arrayElement = this.getArrayElement(this.array, this.index);
            return new TypedValue(arrayElement, this.typeDescriptor.elementTypeDescriptor(arrayElement));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            TypeDescriptor elementType = this.typeDescriptor.getElementTypeDescriptor();
            Assert.state(elementType != null, "No element type");
            this.setArrayElement(this.typeConverter, this.array, this.index, newValue, elementType.getType());
        }

        @Override
        public boolean isWritable() {
            return true;
        }

        private Object getArrayElement(Object ctx, int idx) throws SpelEvaluationException {
            TypeDescriptor.OfField arrayComponentType = ctx.getClass().componentType();
            if (arrayComponentType == Boolean.TYPE) {
                boolean[] array = (boolean[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("Z");
                Indexer.this.arrayTypeDescriptor = "[Z";
                return array[idx];
            }
            if (arrayComponentType == Byte.TYPE) {
                byte[] array = (byte[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("B");
                Indexer.this.arrayTypeDescriptor = "[B";
                return array[idx];
            }
            if (arrayComponentType == Character.TYPE) {
                char[] array = (char[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("C");
                Indexer.this.arrayTypeDescriptor = "[C";
                return Character.valueOf(array[idx]);
            }
            if (arrayComponentType == Double.TYPE) {
                double[] array = (double[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("D");
                Indexer.this.arrayTypeDescriptor = "[D";
                return array[idx];
            }
            if (arrayComponentType == Float.TYPE) {
                float[] array = (float[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("F");
                Indexer.this.arrayTypeDescriptor = "[F";
                return Float.valueOf(array[idx]);
            }
            if (arrayComponentType == Integer.TYPE) {
                int[] array = (int[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("I");
                Indexer.this.arrayTypeDescriptor = "[I";
                return array[idx];
            }
            if (arrayComponentType == Long.TYPE) {
                long[] array = (long[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("J");
                Indexer.this.arrayTypeDescriptor = "[J";
                return array[idx];
            }
            if (arrayComponentType == Short.TYPE) {
                short[] array = (short[])ctx;
                this.checkAccess(array.length, idx);
                Indexer.this.setExitTypeDescriptor("S");
                Indexer.this.arrayTypeDescriptor = "[S";
                return array[idx];
            }
            Object[] array = (Object[])ctx;
            this.checkAccess(array.length, idx);
            Object retValue = array[idx];
            Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(arrayComponentType);
            Indexer.this.arrayTypeDescriptor = CodeFlow.toDescriptor(array.getClass());
            return retValue;
        }

        private void setArrayElement(TypeConverter converter, Object ctx, int idx, @Nullable Object newValue, Class<?> arrayComponentType) throws EvaluationException {
            if (arrayComponentType == Boolean.TYPE) {
                boolean[] array = (boolean[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Boolean.TYPE);
            } else if (arrayComponentType == Byte.TYPE) {
                byte[] array = (byte[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Byte.TYPE);
            } else if (arrayComponentType == Character.TYPE) {
                char[] array = (char[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Character.TYPE).charValue();
            } else if (arrayComponentType == Double.TYPE) {
                double[] array = (double[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Double.TYPE);
            } else if (arrayComponentType == Float.TYPE) {
                float[] array = (float[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Float.TYPE).floatValue();
            } else if (arrayComponentType == Integer.TYPE) {
                int[] array = (int[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Integer.TYPE);
            } else if (arrayComponentType == Long.TYPE) {
                long[] array = (long[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Long.TYPE);
            } else if (arrayComponentType == Short.TYPE) {
                short[] array = (short[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, Short.TYPE);
            } else {
                Object[] array = (Object[])ctx;
                this.checkAccess(array.length, idx);
                array[idx] = ArrayIndexingValueRef.convertValue(converter, newValue, arrayComponentType);
            }
        }

        private void checkAccess(int arrayLength, int index) throws SpelEvaluationException {
            if (index >= arrayLength) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.ARRAY_INDEX_OUT_OF_BOUNDS, arrayLength, index);
            }
        }

        private static <T> T convertValue(TypeConverter converter, @Nullable Object value, Class<T> targetType) {
            Object result = converter.convertValue(value, TypeDescriptor.forObject(value), TypeDescriptor.valueOf(targetType));
            if (result == null) {
                throw new IllegalStateException("Null conversion result for index [" + String.valueOf(value) + "]");
            }
            return (T)result;
        }
    }

    private class CollectionIndexingValueRef
    implements ValueRef {
        private final Collection collection;
        private final int index;
        private final TypeDescriptor collectionEntryDescriptor;
        private final TypeConverter typeConverter;
        private final boolean growCollection;
        private final int maximumSize;

        public CollectionIndexingValueRef(Collection collection, int index, TypeDescriptor collectionEntryDescriptor, TypeConverter typeConverter, boolean growCollection, int maximumSize) {
            this.collection = collection;
            this.index = index;
            this.collectionEntryDescriptor = collectionEntryDescriptor;
            this.typeConverter = typeConverter;
            this.growCollection = growCollection;
            this.maximumSize = maximumSize;
        }

        @Override
        public TypedValue getValue() {
            this.growCollectionIfNecessary();
            Collection collection = this.collection;
            if (collection instanceof List) {
                List list = (List)collection;
                Object o = list.get(this.index);
                Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(Object.class);
                return new TypedValue(o, this.collectionEntryDescriptor.elementTypeDescriptor(o));
            }
            int pos = 0;
            for (Object o : this.collection) {
                if (pos == this.index) {
                    return new TypedValue(o, this.collectionEntryDescriptor.elementTypeDescriptor(o));
                }
                ++pos;
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, this.collection.size(), this.index);
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            Collection collection = this.collection;
            if (!(collection instanceof List)) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.collectionEntryDescriptor.toString());
            }
            List list = (List)collection;
            this.growCollectionIfNecessary();
            if (this.collectionEntryDescriptor.getElementTypeDescriptor() != null) {
                newValue = this.typeConverter.convertValue(newValue, TypeDescriptor.forObject(newValue), this.collectionEntryDescriptor.getElementTypeDescriptor());
            }
            list.set(this.index, newValue);
        }

        private void growCollectionIfNecessary() {
            if (this.index >= this.collection.size()) {
                if (!this.growCollection) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.COLLECTION_INDEX_OUT_OF_BOUNDS, this.collection.size(), this.index);
                }
                if (this.index >= this.maximumSize) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                }
                if (this.collectionEntryDescriptor.getElementTypeDescriptor() == null) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.UNABLE_TO_GROW_COLLECTION_UNKNOWN_ELEMENT_TYPE, new Object[0]);
                }
                TypeDescriptor elementType = this.collectionEntryDescriptor.getElementTypeDescriptor();
                try {
                    Constructor<?> ctor = CollectionIndexingValueRef.getDefaultConstructor(elementType.getType());
                    for (int newElements = this.index - this.collection.size(); newElements >= 0; --newElements) {
                        this.collection.add(ctor != null ? (Object)ctor.newInstance(new Object[0]) : null);
                    }
                }
                catch (Throwable ex) {
                    throw new SpelEvaluationException(Indexer.this.getStartPosition(), ex, SpelMessage.UNABLE_TO_GROW_COLLECTION, new Object[0]);
                }
            }
        }

        @Override
        public boolean isWritable() {
            return this.collection instanceof List;
        }

        @Nullable
        private static Constructor<?> getDefaultConstructor(Class<?> type) {
            try {
                return ReflectionUtils.accessibleConstructor(type, new Class[0]);
            }
            catch (Throwable ex) {
                return null;
            }
        }
    }

    private class MapIndexingValueRef
    implements ValueRef {
        private final TypeConverter typeConverter;
        private final Map map;
        @Nullable
        private final Object key;
        private final TypeDescriptor mapEntryDescriptor;

        public MapIndexingValueRef(TypeConverter typeConverter, @Nullable Map map, Object key, TypeDescriptor mapEntryDescriptor) {
            this.typeConverter = typeConverter;
            this.map = map;
            this.key = key;
            this.mapEntryDescriptor = mapEntryDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Object value = this.map.get(this.key);
            Indexer.this.exitTypeDescriptor = CodeFlow.toDescriptor(Object.class);
            return new TypedValue(value, this.mapEntryDescriptor.getMapValueTypeDescriptor(value));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            if (this.mapEntryDescriptor.getMapValueTypeDescriptor() != null) {
                newValue = this.typeConverter.convertValue(newValue, TypeDescriptor.forObject(newValue), this.mapEntryDescriptor.getMapValueTypeDescriptor());
            }
            this.map.put(this.key, newValue);
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private class StringIndexingValueRef
    implements ValueRef {
        private final String target;
        private final int index;
        private final TypeDescriptor typeDescriptor;

        public StringIndexingValueRef(String target, int index, TypeDescriptor typeDescriptor) {
            this.target = target;
            this.index = index;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            if (this.index >= this.target.length()) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.STRING_INDEX_OUT_OF_BOUNDS, this.target.length(), this.index);
            }
            return new TypedValue(String.valueOf(this.target.charAt(this.index)));
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.typeDescriptor.toString());
        }

        @Override
        public boolean isWritable() {
            return false;
        }
    }

    private class IndexAccessorValueRef
    implements ValueRef {
        private final Object target;
        private final Object index;
        private final EvaluationContext evaluationContext;
        private final TypeDescriptor typeDescriptor;

        IndexAccessorValueRef(Object target, Object index, EvaluationContext evaluationContext, TypeDescriptor typeDescriptor) {
            this.target = target;
            this.index = index;
            this.evaluationContext = evaluationContext;
            this.typeDescriptor = typeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Class<?> targetType = Indexer.getObjectType(this.target);
            Exception exception = null;
            try {
                CachedIndexState cachedIndexReadState = Indexer.this.cachedIndexReadState;
                if (cachedIndexReadState != null) {
                    Object cachedIndex = cachedIndexReadState.index;
                    Class<?> cachedTargetType = cachedIndexReadState.targetType;
                    if (cachedIndex.equals(this.index) && cachedTargetType.equals(targetType)) {
                        IndexAccessor accessor = cachedIndexReadState.accessor;
                        if (this.evaluationContext.getIndexAccessors().contains(accessor)) {
                            try {
                                return accessor.read(this.evaluationContext, this.target, this.index);
                            }
                            catch (Exception ex) {
                                exception = ex;
                            }
                        }
                    }
                    Indexer.this.cachedIndexReadState = null;
                }
                List<IndexAccessor> accessorsToTry = AccessorUtils.getAccessorsToTry(this.target, this.evaluationContext.getIndexAccessors());
                for (IndexAccessor indexAccessor : accessorsToTry) {
                    if (!indexAccessor.canRead(this.evaluationContext, this.target, this.index)) continue;
                    TypedValue result = indexAccessor.read(this.evaluationContext, this.target, this.index);
                    Indexer.this.cachedIndexReadState = new CachedIndexState(indexAccessor, targetType, this.index);
                    if (indexAccessor instanceof CompilableIndexAccessor) {
                        CompilableIndexAccessor compilableIndexAccessor = (CompilableIndexAccessor)indexAccessor;
                        Indexer.this.setExitTypeDescriptor(CodeFlow.toDescriptor(compilableIndexAccessor.getIndexedValueType()));
                    }
                    return result;
                }
            }
            catch (Exception ex) {
                exception = ex;
            }
            if (exception != null) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)exception, SpelMessage.EXCEPTION_DURING_INDEX_READ, this.index, this.typeDescriptor.toString());
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.typeDescriptor.toString());
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            Class<?> targetType = Indexer.getObjectType(this.target);
            Exception exception = null;
            try {
                CachedIndexState cachedIndexWriteState = Indexer.this.cachedIndexWriteState;
                if (cachedIndexWriteState != null) {
                    Object cachedIndex = cachedIndexWriteState.index;
                    Class<?> cachedTargetType = cachedIndexWriteState.targetType;
                    if (cachedIndex.equals(this.index) && cachedTargetType.equals(targetType)) {
                        IndexAccessor accessor = cachedIndexWriteState.accessor;
                        if (this.evaluationContext.getIndexAccessors().contains(accessor)) {
                            try {
                                accessor.write(this.evaluationContext, this.target, this.index, newValue);
                                return;
                            }
                            catch (Exception ex) {
                                exception = ex;
                            }
                        }
                    }
                    Indexer.this.cachedIndexWriteState = null;
                }
                List<IndexAccessor> accessorsToTry = AccessorUtils.getAccessorsToTry(this.target, this.evaluationContext.getIndexAccessors());
                for (IndexAccessor indexAccessor : accessorsToTry) {
                    if (!indexAccessor.canWrite(this.evaluationContext, this.target, this.index)) continue;
                    indexAccessor.write(this.evaluationContext, this.target, this.index, newValue);
                    Indexer.this.cachedIndexWriteState = new CachedIndexState(indexAccessor, targetType, this.index);
                    return;
                }
            }
            catch (Exception ex) {
                exception = ex;
            }
            if (exception != null) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)exception, SpelMessage.EXCEPTION_DURING_INDEX_WRITE, this.index, this.typeDescriptor.toString());
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.typeDescriptor.toString());
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private class PropertyAccessorValueRef
    implements ValueRef {
        private final Object targetObject;
        private final String name;
        private final EvaluationContext evaluationContext;
        private final TypeDescriptor targetObjectTypeDescriptor;

        public PropertyAccessorValueRef(Object targetObject, String name, EvaluationContext evaluationContext, TypeDescriptor targetObjectTypeDescriptor) {
            this.targetObject = targetObject;
            this.name = name;
            this.evaluationContext = evaluationContext;
            this.targetObjectTypeDescriptor = targetObjectTypeDescriptor;
        }

        @Override
        public TypedValue getValue() {
            Class<?> targetType = Indexer.getObjectType(this.targetObject);
            try {
                CachedPropertyState cachedPropertyReadState = Indexer.this.cachedPropertyReadState;
                if (cachedPropertyReadState != null) {
                    String cachedPropertyName = cachedPropertyReadState.name;
                    Class<?> cachedTargetType = cachedPropertyReadState.targetType;
                    if (cachedPropertyName.equals(this.name) && cachedTargetType.equals(targetType)) {
                        PropertyAccessor accessor = cachedPropertyReadState.accessor;
                        return accessor.read(this.evaluationContext, this.targetObject, this.name);
                    }
                    Indexer.this.cachedPropertyReadState = null;
                }
                List<PropertyAccessor> accessorsToTry = AccessorUtils.getAccessorsToTry(targetType, this.evaluationContext.getPropertyAccessors());
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canRead(this.evaluationContext, this.targetObject, this.name)) continue;
                    if (accessor instanceof ReflectivePropertyAccessor) {
                        ReflectivePropertyAccessor reflectivePropertyAccessor = (ReflectivePropertyAccessor)accessor;
                        accessor = reflectivePropertyAccessor.createOptimalAccessor(this.evaluationContext, this.targetObject, this.name);
                    }
                    TypedValue result = accessor.read(this.evaluationContext, this.targetObject, this.name);
                    Indexer.this.cachedPropertyReadState = new CachedPropertyState(accessor, targetType, this.name);
                    if (accessor instanceof CompilablePropertyAccessor) {
                        CompilablePropertyAccessor compilablePropertyAccessor = (CompilablePropertyAccessor)accessor;
                        Indexer.this.setExitTypeDescriptor(CodeFlow.toDescriptor(compilablePropertyAccessor.getPropertyType()));
                    }
                    return result;
                }
            }
            catch (AccessException ex) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)ex, SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            Class<?> targetType = Indexer.getObjectType(this.targetObject);
            try {
                CachedPropertyState cachedPropertyWriteState = Indexer.this.cachedPropertyWriteState;
                if (cachedPropertyWriteState != null) {
                    String cachedPropertyName = cachedPropertyWriteState.name;
                    Class<?> cachedTargetType = cachedPropertyWriteState.targetType;
                    if (cachedPropertyName.equals(this.name) && cachedTargetType.equals(targetType)) {
                        PropertyAccessor accessor = cachedPropertyWriteState.accessor;
                        accessor.write(this.evaluationContext, this.targetObject, this.name, newValue);
                        return;
                    }
                    Indexer.this.cachedPropertyWriteState = null;
                }
                List<PropertyAccessor> accessorsToTry = AccessorUtils.getAccessorsToTry(targetType, this.evaluationContext.getPropertyAccessors());
                for (PropertyAccessor accessor : accessorsToTry) {
                    if (!accessor.canWrite(this.evaluationContext, this.targetObject, this.name)) continue;
                    accessor.write(this.evaluationContext, this.targetObject, this.name, newValue);
                    Indexer.this.cachedPropertyWriteState = new CachedPropertyState(accessor, targetType, this.name);
                    return;
                }
            }
            catch (AccessException ex) {
                throw new SpelEvaluationException(Indexer.this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_PROPERTY_WRITE, this.name, ex.getMessage());
            }
            throw new SpelEvaluationException(Indexer.this.getStartPosition(), SpelMessage.INDEXING_NOT_SUPPORTED_FOR_TYPE, this.targetObjectTypeDescriptor.toString());
        }

        @Override
        public boolean isWritable() {
            return true;
        }
    }

    private record CachedPropertyState(PropertyAccessor accessor, Class<?> targetType, String name) {
    }

    private record CachedIndexState(IndexAccessor accessor, Class<?> targetType, Object index) {
    }
}

