/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ant.antunit;

import org.apache.ant.antunit.LogCapturer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.taskdefs.Echo;
import org.apache.tools.ant.taskdefs.condition.Condition;

public class LogContains
extends ProjectComponent
implements Condition {
    private String text;
    private int logLevel = 2;
    private boolean mergeLines = true;

    public void setText(String t) {
        this.text = t;
    }

    public void setLevel(Echo.EchoLevel echoLevel) {
        this.logLevel = echoLevel.getLevel();
    }

    public void setMergeLines(boolean b) {
        this.mergeLines = b;
    }

    public boolean eval() {
        if (this.text == null) {
            throw new BuildException("the text attribute is required");
        }
        Object o = this.getProject().getReference("ant.antunit.log");
        if (o instanceof LogCapturer) {
            String log;
            LogCapturer c = (LogCapturer)o;
            switch (this.logLevel) {
                case 0: {
                    log = c.getErrLog(this.mergeLines);
                    break;
                }
                case 1: {
                    log = c.getWarnLog(this.mergeLines);
                    break;
                }
                case 2: {
                    log = c.getInfoLog(this.mergeLines);
                    break;
                }
                case 3: {
                    log = c.getVerboseLog(this.mergeLines);
                    break;
                }
                case 4: {
                    log = c.getDebugLog(this.mergeLines);
                    break;
                }
                default: {
                    throw new BuildException("Unknown logLevel: " + this.logLevel);
                }
            }
            return log.indexOf(this.text) > -1;
        }
        return false;
    }
}

