/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.aries.jndi.ContextHelper;
import org.apache.aries.jndi.Utils;
import org.osgi.framework.BundleContext;
import org.osgi.service.jndi.JNDIContextManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextManagerService
implements JNDIContextManager {
    private Set<Context> contexts = Collections.synchronizedSet(new HashSet());
    private BundleContext callerContext;

    public ContextManagerService(BundleContext callerContext) {
        this.callerContext = callerContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Set<Context> set = this.contexts;
        synchronized (set) {
            for (Context context : this.contexts) {
                try {
                    context.close();
                }
                catch (NamingException e) {}
            }
            this.contexts.clear();
        }
    }

    public Context newInitialContext() throws NamingException {
        return this.newInitialContext(new Hashtable());
    }

    public Context newInitialContext(Map<?, ?> environment) throws NamingException {
        return this.getInitialContext(environment);
    }

    public DirContext newInitialDirContext() throws NamingException {
        return this.newInitialDirContext(new Hashtable());
    }

    public DirContext newInitialDirContext(Map<?, ?> environment) throws NamingException {
        return (DirContext)DirContext.class.cast(this.getInitialContext(environment));
    }

    private Context getInitialContext(Map<?, ?> environment) throws NamingException {
        Hashtable<?, ?> env = Utils.toHashtable(environment);
        Utils.augmentEnvironment(env);
        Context context = ContextHelper.getInitialContext(this.callerContext, env);
        this.contexts.add(context);
        return context;
    }
}

