/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.apache.aries.subsystem.core.internal.BundleResourceInstaller;
import org.apache.aries.subsystem.core.internal.ResourceUninstaller;
import org.apache.aries.subsystem.core.internal.Subsystems;
import org.apache.aries.subsystem.core.internal.ThreadLocalSubsystem;
import org.apache.aries.subsystem.core.internal.Utils;
import org.eclipse.equinox.region.Region;
import org.eclipse.equinox.region.RegionDigraph;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.hooks.bundle.EventHook;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Resource;

public class BundleEventHook
implements EventHook {
    private final Activator activator = Activator.getInstance();
    private final ConcurrentHashMap<Bundle, BundleRevision> bundleToRevision = new ConcurrentHashMap();
    private boolean active;
    private List<BundleEvent> events;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(BundleEvent event, Collection<BundleContext> contexts) {
        if ((event.getType() & 0x11) == 0) {
            return;
        }
        BundleEventHook bundleEventHook = this;
        synchronized (bundleEventHook) {
            if (!this.active) {
                if (this.events == null) {
                    this.events = new ArrayList<BundleEvent>();
                }
                this.events.add(event);
                return;
            }
        }
        this.handleEvent(event);
    }

    synchronized void activate() {
        this.active = true;
        this.processPendingEvents();
    }

    synchronized void deactivate() {
        this.active = false;
    }

    synchronized void processPendingEvents() {
        if (this.events == null) {
            return;
        }
        for (BundleEvent event : this.events) {
            this.handleEvent(event);
        }
        this.events = null;
    }

    private Subsystems getSubsystems() {
        return this.activator.getSubsystems();
    }

    private void handleEvent(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                this.handleInstalledEvent(event);
                break;
            }
            case 16: {
                this.handleUninstalledEvent(event);
            }
        }
    }

    private void handleExplicitlyInstalledBundleBundleContext(BundleRevision originRevision, BundleRevision bundleRevision) {
        Collection<BasicSubsystem> subsystems = this.getSubsystems().getSubsystemsReferencing((Resource)originRevision);
        if (subsystems.isEmpty()) {
            subsystems = Collections.singleton(this.getSubsystems().getRootSubsystem());
        }
        for (BasicSubsystem s : subsystems) {
            Utils.installResource((Resource)bundleRevision, s);
        }
    }

    private void handleExplicitlyInstalledBundleRegionDigraph(Bundle origin, BundleRevision bundleRevision) {
        RegionDigraph digraph = this.activator.getRegionDigraph();
        Region region = digraph.getRegion(origin);
        for (BasicSubsystem s : this.getSubsystems().getSubsystems()) {
            if (!s.isApplication() && !s.isComposite() || !region.equals(s.getRegion())) continue;
            Utils.installResource((Resource)bundleRevision, s);
            return;
        }
        throw new IllegalStateException("No subsystem found for bundle " + bundleRevision + " in region " + region);
    }

    private void handleInstalledEvent(BundleEvent event) {
        Bundle origin = event.getOrigin();
        BundleRevision originRevision = (BundleRevision)origin.adapt(BundleRevision.class);
        Bundle bundle = event.getBundle();
        BundleRevision bundleRevision = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (bundleRevision == null) {
            return;
        }
        this.bundleToRevision.put(bundle, bundleRevision);
        if (ThreadLocalSubsystem.get() != null) {
            return;
        }
        if ("org.eclipse.equinox.region".equals(origin.getSymbolicName())) {
            this.handleExplicitlyInstalledBundleRegionDigraph(origin, bundleRevision);
        } else {
            this.handleExplicitlyInstalledBundleBundleContext(originRevision, bundleRevision);
        }
    }

    private void handleUninstalledEvent(BundleEvent event) {
        Collection subsystems;
        Bundle bundle = event.getBundle();
        BundleRevision revision = this.bundleToRevision.remove(bundle);
        if (ThreadLocalSubsystem.get() != null) {
            return;
        }
        if (revision == null) {
            Object[] o = Activator.getInstance().getSubsystems().getSubsystemsByBundle(bundle);
            if (o == null) {
                return;
            }
            revision = (BundleRevision)o[0];
            subsystems = (Collection)o[1];
        } else {
            subsystems = Activator.getInstance().getSubsystems().getSubsystemsByConstituent((Resource)new BundleResourceInstaller.BundleConstituent(null, revision));
        }
        for (BasicSubsystem subsystem : subsystems) {
            ResourceUninstaller.newInstance((Resource)revision, subsystem).uninstall();
        }
    }
}

