/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.Collection;
import java.util.HashSet;
import org.apache.aries.subsystem.core.internal.BasicSubsystem;
import org.osgi.framework.Version;
import org.osgi.service.subsystem.Subsystem;

public class TargetRegion {
    Collection<Subsystem> region = new HashSet<Subsystem>();

    public TargetRegion(BasicSubsystem subsystem) {
        BasicSubsystem controllingScopedSubsystem = subsystem;
        while (controllingScopedSubsystem.isFeature()) {
            controllingScopedSubsystem = (BasicSubsystem)subsystem.getParents().iterator().next();
        }
        this.region.add(controllingScopedSubsystem);
        this.addChildrenToRegion(controllingScopedSubsystem);
    }

    public boolean contains(Subsystem subsystem) {
        for (Subsystem s : this.region) {
            if (!s.getSymbolicName().equals(subsystem.getSymbolicName()) || !s.getVersion().equals((Object)subsystem.getVersion())) continue;
            return true;
        }
        return false;
    }

    public Subsystem find(String symbolicName, Version version) {
        for (Subsystem s : this.region) {
            if (!s.getSymbolicName().equals(symbolicName) || !s.getVersion().equals((Object)version)) continue;
            return s;
        }
        return null;
    }

    private void addChildrenToRegion(BasicSubsystem controllingScopedSubsystem) {
        for (Subsystem child : controllingScopedSubsystem.getChildren()) {
            this.region.add(child);
            if (!((BasicSubsystem)child).isFeature()) continue;
            this.addFeatureDescendentsToRegion((BasicSubsystem)child);
        }
    }

    private void addFeatureDescendentsToRegion(BasicSubsystem parent) {
        for (Subsystem child : parent.getChildren()) {
            if (!((BasicSubsystem)child).isFeature()) continue;
            this.region.add(child);
            this.addFeatureDescendentsToRegion((BasicSubsystem)child);
        }
    }
}

