/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.subsystem.core.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.aries.application.modelling.ExportedService;
import org.apache.aries.application.modelling.ImportedService;
import org.apache.aries.application.modelling.ModelledResource;
import org.apache.aries.application.modelling.ModelledResourceManager;
import org.apache.aries.application.modelling.ModellerException;
import org.apache.aries.subsystem.core.internal.Activator;
import org.apache.aries.subsystem.core.internal.BasicCapability;
import org.apache.aries.subsystem.core.internal.BasicRequirement;
import org.apache.aries.subsystem.core.internal.BundleDirectory;
import org.apache.aries.util.filesystem.IDirectory;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.service.subsystem.SubsystemException;

public class BundleRevisionResource
implements Resource {
    private final BundleRevision revision;
    private volatile ModelledResource resource;

    public BundleRevisionResource(BundleRevision revision) {
        if (revision == null) {
            throw new NullPointerException();
        }
        this.revision = revision;
    }

    public List<Capability> getCapabilities(String namespace) {
        if (namespace == null) {
            List rCaps = this.revision.getCapabilities(namespace);
            List<Capability> sCaps = this.computeServiceCapabilities();
            ArrayList<Capability> result = new ArrayList<Capability>(rCaps.size() + sCaps.size());
            result.addAll(rCaps);
            result.addAll(sCaps);
            return Collections.unmodifiableList(result);
        }
        if ("osgi.service".equals(namespace)) {
            return Collections.unmodifiableList(this.computeServiceCapabilities());
        }
        return this.revision.getCapabilities(namespace);
    }

    public List<Requirement> getRequirements(String namespace) {
        if (namespace == null) {
            List rReqs = this.revision.getRequirements(namespace);
            List<Requirement> sReqs = this.computeServiceRequirements();
            ArrayList<Requirement> result = new ArrayList<Requirement>(rReqs.size() + sReqs.size());
            result.addAll(rReqs);
            result.addAll(sReqs);
            return Collections.unmodifiableList(result);
        }
        if ("osgi.service".equals(namespace)) {
            return Collections.unmodifiableList(this.computeServiceRequirements());
        }
        return this.revision.getRequirements(namespace);
    }

    private ModelledResource computeModelledResource() {
        Activator activator = Activator.getInstance();
        ModelledResourceManager manager = activator.getModelledResourceManager();
        BundleDirectory directory = new BundleDirectory(this.revision.getBundle());
        try {
            return manager.getModelledResource((IDirectory)directory);
        }
        catch (ModellerException e) {
            throw new SubsystemException((Throwable)e);
        }
    }

    private List<Capability> computeServiceCapabilities() {
        ModelledResource resource = this.getModelledResource();
        Collection services = resource.getExportedServices();
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Capability> result = new ArrayList<Capability>(services.size());
        for (ExportedService service : services) {
            result.add(new BasicCapability.Builder().namespace("osgi.service").attribute("objectClass", new ArrayList(service.getInterfaces())).attributes(service.getServiceProperties()).resource(this).build());
        }
        return result;
    }

    private List<Requirement> computeServiceRequirements() {
        ModelledResource resource = this.getModelledResource();
        Collection services = resource.getImportedServices();
        if (services.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Requirement> result = new ArrayList<Requirement>(services.size());
        for (ImportedService service : services) {
            StringBuilder builder = new StringBuilder("(&(").append("objectClass").append('=').append(service.getInterface()).append(')');
            String filter = service.getFilter();
            if (filter != null) {
                builder.append('(').append(filter).append(')');
            }
            builder.append(')');
            result.add(new BasicRequirement.Builder().namespace("osgi.service").directive("filter", builder.toString()).directive("resolution", service.isOptional() ? "optional" : "mandatory").resource(this).build());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelledResource getModelledResource() {
        ModelledResource result = this.resource;
        if (result == null) {
            BundleRevisionResource bundleRevisionResource = this;
            synchronized (bundleRevisionResource) {
                result = this.resource;
                if (result == null) {
                    this.resource = result = this.computeModelledResource();
                }
            }
        }
        return result;
    }
}

