/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors;

import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestNonMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DelegateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistinctOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DistributeResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.EmptyTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ExchangeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ForwardOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IndexInsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InnerJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.InsertDeleteUpsertOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IntersectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LeftOuterUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.LimitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.MaterializeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.NestedTupleSourceOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ProjectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ReplicateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.RunningAggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.ScriptOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SinkOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SplitOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SubplanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.TokenizeOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnionAllOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestMapOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WindowOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.WriteResultOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.typing.ITypingContext;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;

public class SubstituteVariableVisitor
implements ILogicalOperatorVisitor<Void, Pair<LogicalVariable, LogicalVariable>> {
    private final boolean goThroughNts;
    private final ITypingContext ctx;

    public SubstituteVariableVisitor(boolean goThroughNts, ITypingContext ctx) {
        this.goThroughNts = goThroughNts;
        this.ctx = ctx;
    }

    @Override
    public Void visitAggregateOperator(AggregateOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substAssignVariables(op.getVariables(), op.getExpressions(), pair);
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitAssignOperator(AssignOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substAssignVariables(op.getVariables(), op.getExpressions(), pair);
        if (op.getExplicitOrderingProperty() != null) {
            List<OrderColumn> orderColumns = op.getExplicitOrderingProperty().getOrderColumns();
            for (int i = 0; i < orderColumns.size(); ++i) {
                OrderColumn oc = orderColumns.get(i);
                if (!oc.getColumn().equals(pair.first)) continue;
                orderColumns.set(i, new OrderColumn((LogicalVariable)pair.second, oc.getOrder()));
            }
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitDataScanOperator(DataSourceScanOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        List<LogicalVariable> variables = op.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            if (variables.get(i) != pair.first) continue;
            variables.set(i, (LogicalVariable)pair.second);
            return null;
        }
        if (op.getSelectCondition() != null) {
            ((ILogicalExpression)op.getSelectCondition().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitDistinctOperator(DistinctOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        for (Mutable<ILogicalExpression> eRef : op.getExpressions()) {
            ((ILogicalExpression)eRef.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitEmptyTupleSourceOperator(EmptyTupleSourceOperator op, Pair<LogicalVariable, LogicalVariable> pair) {
        return null;
    }

    @Override
    public Void visitExchangeOperator(ExchangeOperator op, Pair<LogicalVariable, LogicalVariable> pair) {
        return null;
    }

    @Override
    public Void visitGroupByOperator(GroupByOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.subst((LogicalVariable)pair.first, (LogicalVariable)pair.second, op.getGroupByList());
        this.subst((LogicalVariable)pair.first, (LogicalVariable)pair.second, op.getDecorList());
        this.substInNestedPlans((LogicalVariable)pair.first, (LogicalVariable)pair.second, op);
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitInnerJoinOperator(InnerJoinOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        ((ILogicalExpression)op.getCondition().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitLeftOuterJoinOperator(LeftOuterJoinOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        ((ILogicalExpression)op.getCondition().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitLimitOperator(LimitOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        ((ILogicalExpression)op.getMaxObjects().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        ILogicalExpression offset = (ILogicalExpression)op.getOffset().getValue();
        if (offset != null) {
            offset.substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitNestedTupleSourceOperator(NestedTupleSourceOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitOrderOperator(OrderOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> oe : op.getOrderExpressions()) {
            ((ILogicalExpression)((Mutable)oe.second).getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitProjectOperator(ProjectOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        List<LogicalVariable> usedVariables = op.getVariables();
        int n = usedVariables.size();
        for (int i = 0; i < n; ++i) {
            LogicalVariable v = usedVariables.get(i);
            if (!v.equals(pair.first)) continue;
            usedVariables.set(i, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitRunningAggregateOperator(RunningAggregateOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substAssignVariables(op.getVariables(), op.getExpressions(), pair);
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitScriptOperator(ScriptOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substInArray(op.getInputVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substInArray(op.getOutputVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitSelectOperator(SelectOperator op, Pair<LogicalVariable, LogicalVariable> pair) {
        ((ILogicalExpression)op.getCondition().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        return null;
    }

    @Override
    public Void visitSubplanOperator(SubplanOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substInNestedPlans((LogicalVariable)pair.first, (LogicalVariable)pair.second, op);
        return null;
    }

    @Override
    public Void visitUnionOperator(UnionAllOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        List<Triple<LogicalVariable, LogicalVariable, LogicalVariable>> varMap = op.getVariableMappings();
        for (Triple<LogicalVariable, LogicalVariable, LogicalVariable> t : varMap) {
            if (((LogicalVariable)t.first).equals(pair.first)) {
                t.first = pair.second;
            }
            if (((LogicalVariable)t.second).equals(pair.first)) {
                t.second = pair.second;
            }
            if (!((LogicalVariable)t.third).equals(pair.first)) continue;
            t.third = pair.second;
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitIntersectOperator(IntersectOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        boolean hasExtraVars = op.hasExtraVariables();
        this.substInArray(op.getOutputCompareVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        if (hasExtraVars) {
            this.substInArray(op.getOutputExtraVariables(), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        int n = op.getNumInput();
        for (int i = 0; i < n; ++i) {
            this.substInArray(op.getInputCompareVariables(i), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
            if (!hasExtraVars) continue;
            this.substInArray(op.getInputExtraVariables(i), (LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitUnnestMapOperator(UnnestMapOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substituteVarsForAbstractUnnestMapOp(op, pair);
        if (op.getSelectCondition() != null) {
            ((ILogicalExpression)op.getSelectCondition().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestMapOperator(LeftOuterUnnestMapOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        this.substituteVarsForAbstractUnnestMapOp(op, pair);
        return null;
    }

    private void substituteVarsForAbstractUnnestMapOp(AbstractUnnestMapOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        List<LogicalVariable> variables = op.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            if (variables.get(i) != pair.first) continue;
            variables.set(i, (LogicalVariable)pair.second);
            return;
        }
        ((ILogicalExpression)op.getExpressionRef().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substVarTypes(op, pair);
    }

    @Override
    public Void visitUnnestOperator(UnnestOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return this.visitUnnestNonMapOperator(op, pair);
    }

    @Override
    public Void visitWriteOperator(WriteOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        for (Mutable<ILogicalExpression> e : op.getExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitDistributeResultOperator(DistributeResultOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        for (Mutable<ILogicalExpression> e : op.getExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitWriteResultOperator(WriteResultOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        ((ILogicalExpression)op.getPayloadExpression().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        for (Mutable<ILogicalExpression> e : op.getKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    private void subst(LogicalVariable v1, LogicalVariable v2, List<Pair<LogicalVariable, Mutable<ILogicalExpression>>> varExprPairList) {
        for (Pair<LogicalVariable, Mutable<ILogicalExpression>> ve : varExprPairList) {
            if (ve.first != null && ((LogicalVariable)ve.first).equals(v1)) {
                ve.first = v2;
                return;
            }
            ((ILogicalExpression)((Mutable)ve.second).getValue()).substituteVar(v1, v2);
        }
    }

    private void substInArray(List<LogicalVariable> varArray, LogicalVariable v1, LogicalVariable v2) {
        for (int i = 0; i < varArray.size(); ++i) {
            LogicalVariable v = varArray.get(i);
            if (v != v1) continue;
            varArray.set(i, v2);
        }
    }

    private void substInNestedPlans(LogicalVariable v1, LogicalVariable v2, AbstractOperatorWithNestedPlans op) throws AlgebricksException {
        for (ILogicalPlan p : op.getNestedPlans()) {
            for (Mutable<ILogicalOperator> r : p.getRoots()) {
                VariableUtilities.substituteVariablesInDescendantsAndSelf((ILogicalOperator)r.getValue(), v1, v2, this.ctx);
            }
        }
    }

    private void substAssignVariables(List<LogicalVariable> variables, List<Mutable<ILogicalExpression>> expressions, Pair<LogicalVariable, LogicalVariable> pair) {
        int n = variables.size();
        for (int i = 0; i < n; ++i) {
            if (variables.get(i).equals(pair.first)) {
                variables.set(i, (LogicalVariable)pair.second);
                continue;
            }
            ((ILogicalExpression)expressions.get(i).getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
    }

    @Override
    public Void visitReplicateOperator(ReplicateOperator op, Pair<LogicalVariable, LogicalVariable> arg) throws AlgebricksException {
        op.substituteVar((LogicalVariable)arg.first, (LogicalVariable)arg.second);
        return null;
    }

    @Override
    public Void visitSplitOperator(SplitOperator op, Pair<LogicalVariable, LogicalVariable> arg) throws AlgebricksException {
        op.substituteVar((LogicalVariable)arg.first, (LogicalVariable)arg.second);
        return null;
    }

    @Override
    public Void visitMaterializeOperator(MaterializeOperator op, Pair<LogicalVariable, LogicalVariable> arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitInsertDeleteUpsertOperator(InsertDeleteUpsertOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        ((ILogicalExpression)op.getPayloadExpression().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitIndexInsertDeleteUpsertOperator(IndexInsertDeleteUpsertOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Mutable<ILogicalExpression> e : op.getSecondaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitTokenizeOperator(TokenizeOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        for (Mutable<ILogicalExpression> e : op.getPrimaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Mutable<ILogicalExpression> e : op.getSecondaryKeyExpressions()) {
            ((ILogicalExpression)e.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitForwardOperator(ForwardOperator op, Pair<LogicalVariable, LogicalVariable> arg) throws AlgebricksException {
        ((ILogicalExpression)op.getSideDataExpression().getValue()).substituteVar((LogicalVariable)arg.first, (LogicalVariable)arg.second);
        this.substVarTypes(op, arg);
        return null;
    }

    @Override
    public Void visitSinkOperator(SinkOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return null;
    }

    private void substVarTypes(ILogicalOperator op, Pair<LogicalVariable, LogicalVariable> arg) throws AlgebricksException {
        if (this.ctx == null) {
            return;
        }
        IVariableTypeEnvironment env = this.ctx.getOutputTypeEnvironment(op);
        if (env != null) {
            env.substituteProducedVariable((LogicalVariable)arg.first, (LogicalVariable)arg.second);
        }
    }

    @Override
    public Void visitDelegateOperator(DelegateOperator op, Pair<LogicalVariable, LogicalVariable> arg) throws AlgebricksException {
        return null;
    }

    @Override
    public Void visitLeftOuterUnnestOperator(LeftOuterUnnestOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        return this.visitUnnestNonMapOperator(op, pair);
    }

    private Void visitUnnestNonMapOperator(AbstractUnnestNonMapOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        List<LogicalVariable> variables = op.getVariables();
        for (int i = 0; i < variables.size(); ++i) {
            if (variables.get(i) != pair.first) continue;
            variables.set(i, (LogicalVariable)pair.second);
            return null;
        }
        ((ILogicalExpression)op.getExpressionRef().getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        this.substVarTypes(op, pair);
        return null;
    }

    @Override
    public Void visitWindowOperator(WindowOperator op, Pair<LogicalVariable, LogicalVariable> pair) throws AlgebricksException {
        ILogicalExpression iLogicalExpression;
        for (Mutable<ILogicalExpression> mutable : op.getPartitionExpressions()) {
            ((ILogicalExpression)mutable.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Pair pair2 : op.getOrderExpressions()) {
            ((ILogicalExpression)((Mutable)pair2.second).getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Pair pair3 : op.getFrameValueExpressions()) {
            ((ILogicalExpression)((Mutable)pair3.second).getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameStartExpressions()) {
            ((ILogicalExpression)mutable.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameStartValidationExpressions()) {
            ((ILogicalExpression)mutable.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameEndExpressions()) {
            ((ILogicalExpression)mutable.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameEndValidationExpressions()) {
            ((ILogicalExpression)mutable.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        for (Mutable<ILogicalExpression> mutable : op.getFrameExcludeExpressions()) {
            ((ILogicalExpression)mutable.getValue()).substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        ILogicalExpression frameExcludeUnaryExpr = (ILogicalExpression)op.getFrameExcludeUnaryExpression().getValue();
        if (frameExcludeUnaryExpr != null) {
            frameExcludeUnaryExpr.substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        if ((iLogicalExpression = (ILogicalExpression)op.getFrameOffsetExpression().getValue()) != null) {
            iLogicalExpression.substituteVar((LogicalVariable)pair.first, (LogicalVariable)pair.second);
        }
        this.substAssignVariables(op.getVariables(), op.getExpressions(), pair);
        this.substInNestedPlans((LogicalVariable)pair.first, (LogicalVariable)pair.second, op);
        this.substVarTypes(op, pair);
        return null;
    }
}

