/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksCountPartitionConstraint;
import org.apache.hyracks.algebricks.common.constraints.AlgebricksPartitionConstraint;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalPlan;
import org.apache.hyracks.algebricks.core.algebra.base.IPhysicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractOperatorWithNestedPlans;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalMemoryRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.PlanCompiler;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.operators.meta.AlgebricksMetaOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.job.JobSpecification;

public abstract class AbstractPhysicalOperator
implements IPhysicalOperator {
    protected IPhysicalPropertiesVector deliveredProperties;
    protected LocalMemoryRequirements localMemoryRequirements;
    private boolean disableJobGenBelow = false;
    private Object hostQueryContext;

    @Override
    public final IPhysicalPropertiesVector getDeliveredProperties() {
        return this.deliveredProperties;
    }

    public String toString() {
        return this.getOperatorTag().toString();
    }

    @Override
    public void setHostQueryContext(Object context) {
        this.hostQueryContext = context;
    }

    @Override
    public Object getHostQueryContext() {
        return this.hostQueryContext;
    }

    protected PhysicalRequirements emptyUnaryRequirements() {
        IPhysicalPropertiesVector[] req = new StructuralPropertiesVector[]{StructuralPropertiesVector.EMPTY_PROPERTIES_VECTOR};
        return new PhysicalRequirements(req, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    protected PhysicalRequirements emptyUnaryRequirements(int numberOfChildren) {
        IPhysicalPropertiesVector[] req = new StructuralPropertiesVector[numberOfChildren];
        for (int i = 0; i < numberOfChildren; ++i) {
            req[i] = StructuralPropertiesVector.EMPTY_PROPERTIES_VECTOR;
        }
        return new PhysicalRequirements(req, IPartitioningRequirementsCoordinator.NO_COORDINATION);
    }

    @Override
    public LocalMemoryRequirements getLocalMemoryRequirements() {
        return this.localMemoryRequirements;
    }

    @Override
    public void createLocalMemoryRequirements(ILogicalOperator op) {
        this.localMemoryRequirements = LocalMemoryRequirements.fixedMemoryBudget(1);
    }

    @Override
    public void disableJobGenBelowMe() {
        this.disableJobGenBelow = true;
    }

    @Override
    public boolean isJobGenDisabledBelowMe() {
        return this.disableJobGenBelow;
    }

    @Override
    public Pair<int[], int[]> getInputOutputDependencyLabels(ILogicalOperator op) {
        int[] inputDependencyLabels = new int[op.getInputs().size()];
        int[] outputDependencyLabels = new int[]{0};
        return new Pair((Object)inputDependencyLabels, (Object)outputDependencyLabels);
    }

    protected void contributeOpDesc(IHyracksJobBuilder builder, AbstractLogicalOperator op, IOperatorDescriptor opDesc) {
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.UNPARTITIONED) {
            AlgebricksCountPartitionConstraint apc = new AlgebricksCountPartitionConstraint(1);
            builder.contributeAlgebricksPartitionConstraint(opDesc, (AlgebricksPartitionConstraint)apc);
        }
        builder.contributeHyracksOperator(op, opDesc);
    }

    protected AlgebricksPipeline[] compileSubplans(IOperatorSchema outerPlanSchema, AbstractOperatorWithNestedPlans npOp, IOperatorSchema opSchema, JobGenContext context) throws AlgebricksException {
        List<List<AlgebricksPipeline>> subplans = this.compileSubplansImpl(outerPlanSchema, npOp, opSchema, context);
        int n = subplans.size();
        AlgebricksPipeline[] result = new AlgebricksPipeline[n];
        for (int i = 0; i < n; ++i) {
            List<AlgebricksPipeline> subplanOps = subplans.get(i);
            if (subplanOps.size() != 1) {
                throw new AlgebricksException("Attempting to construct a nested plan with " + subplanOps.size() + " operator descriptors. Currently, nested plans can only consist in linear pipelines of micro operators.");
            }
            result[i] = subplanOps.get(0);
        }
        return result;
    }

    protected List<List<AlgebricksPipeline>> compileSubplansImpl(IOperatorSchema outerPlanSchema, AbstractOperatorWithNestedPlans npOp, IOperatorSchema opSchema, JobGenContext context) throws AlgebricksException {
        ArrayList<List<AlgebricksPipeline>> subplans = new ArrayList<List<AlgebricksPipeline>>(npOp.getNestedPlans().size());
        PlanCompiler pc = new PlanCompiler(context);
        for (ILogicalPlan p : npOp.getNestedPlans()) {
            subplans.add(this.buildPipelineWithProjection(p, outerPlanSchema, opSchema, pc));
        }
        return subplans;
    }

    private List<AlgebricksPipeline> buildPipelineWithProjection(ILogicalPlan p, IOperatorSchema outerPlanSchema, IOperatorSchema opSchema, PlanCompiler pc) throws AlgebricksException {
        if (p.getRoots().size() > 1) {
            throw new NotImplementedException("Nested plans with several roots are not supported.");
        }
        JobSpecification nestedJob = pc.compileNestedPlan(p, outerPlanSchema);
        ILogicalOperator topOpInSubplan = (ILogicalOperator)p.getRoots().get(0).getValue();
        JobGenContext context = pc.getContext();
        IOperatorSchema topOpInSubplanScm = context.getSchema(topOpInSubplan);
        opSchema.addAllVariables(topOpInSubplanScm);
        Map opMap = nestedJob.getOperatorMap();
        List metaOps = nestedJob.getMetaOps();
        if (opMap.size() != metaOps.size()) {
            for (IOperatorDescriptor opd : opMap.values()) {
                if (opd instanceof AlgebricksMetaOperatorDescriptor) continue;
                throw new AlgebricksException("Can only generate jobs for pipelinable nested plans, not for " + opd.getClass().getName());
            }
            throw new IllegalStateException("Unexpected nested plan");
        }
        ArrayList<AlgebricksPipeline> result = new ArrayList<AlgebricksPipeline>(metaOps.size());
        for (IOperatorDescriptor opd : metaOps) {
            AlgebricksMetaOperatorDescriptor amod = (AlgebricksMetaOperatorDescriptor)opd;
            result.add(amod.getPipeline());
        }
        return result;
    }
}

