/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.ipc.security;

import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import org.apache.hyracks.api.network.INetworkSecurityConfig;
import org.apache.hyracks.api.network.INetworkSecurityManager;
import org.apache.hyracks.api.network.ISocketChannelFactory;
import org.apache.hyracks.ipc.sockets.PlainSocketChannelFactory;
import org.apache.hyracks.ipc.sockets.SslSocketChannelFactory;

public class NetworkSecurityManager
implements INetworkSecurityManager {
    private volatile INetworkSecurityConfig config;
    private final ISocketChannelFactory sslSocketFactory;
    private static final String TSL_VERSION = "TLSv1.2";

    public NetworkSecurityManager(INetworkSecurityConfig config) {
        this.config = config;
        if (config.isSslEnabled()) {
            System.setProperty("javax.net.ssl.trustStore", config.getTrustStoreFile().getAbsolutePath());
            System.setProperty("javax.net.ssl.trustStorePassword", config.getKeyStorePassword());
        }
        this.sslSocketFactory = new SslSocketChannelFactory(this);
    }

    public SSLContext newSSLContext() {
        try {
            char[] password = this.getKeyStorePassword();
            KeyStore engineKeyStore = this.config.getKeyStore();
            if (engineKeyStore == null) {
                engineKeyStore = this.loadKeyStoreFromFile(password);
            }
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(defaultAlgorithm);
            keyManagerFactory.init(engineKeyStore, password);
            KeyStore trustStore = this.loadTrustStoreFromFile(password);
            trustManagerFactory.init(trustStore);
            SSLContext ctx = SSLContext.getInstance(TSL_VERSION);
            ctx.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), new SecureRandom());
            return ctx;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create SSLEngine", ex);
        }
    }

    public SSLEngine newSSLEngine() {
        try {
            SSLContext ctx = this.newSSLContext();
            return ctx.createSSLEngine();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to create SSLEngine", ex);
        }
    }

    public ISocketChannelFactory getSocketChannelFactory() {
        if (this.config.isSslEnabled()) {
            return this.sslSocketFactory;
        }
        return PlainSocketChannelFactory.INSTANCE;
    }

    public INetworkSecurityConfig getConfiguration() {
        return this.config;
    }

    public void setConfiguration(INetworkSecurityConfig config) {
        this.config = config;
    }

    private KeyStore loadKeyStoreFromFile(char[] password) {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(new FileInputStream(this.config.getKeyStoreFile()), password);
            return ks;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load key store", e);
        }
    }

    private KeyStore loadTrustStoreFromFile(char[] password) {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(new FileInputStream(this.config.getTrustStoreFile()), password);
            return ks;
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to load trust store", e);
        }
    }

    private char[] getKeyStorePassword() {
        String pass = this.config.getKeyStorePassword();
        return pass == null || pass.isEmpty() ? null : pass.toCharArray();
    }
}

