/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.group.preclustered;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppenderWrapper;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PermutingFrameTupleReference;
import org.apache.hyracks.dataflow.common.data.accessors.PointableTupleReference;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptor;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptorFactory;

public class PreclusteredGroupWriter
implements IFrameWriter {
    private final int[] groupFields;
    private final IBinaryComparator[] comparators;
    private final IAggregatorDescriptor aggregator;
    private final AggregateState aggregateState;
    private final FrameTupleAccessor inFrameAccessor;
    private final FrameTupleReference groupFieldsRef;
    private final PointableTupleReference groupFieldsPrevCopy;
    private final FrameTupleAppenderWrapper appenderWrapper;
    private final ArrayTupleBuilder tupleBuilder;
    private final boolean groupAll;
    private final boolean outputPartial;
    private boolean first;
    private boolean isFailed = false;
    private final long memoryLimit;

    public PreclusteredGroupWriter(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparator[] comparators, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, IFrameWriter writer, boolean outputPartial) throws HyracksDataException {
        this(ctx, groupFields, comparators, aggregatorFactory, inRecordDesc, outRecordDesc, writer, outputPartial, false, -1);
    }

    public PreclusteredGroupWriter(IHyracksTaskContext ctx, int[] groupFields, IBinaryComparator[] comparators, IAggregatorDescriptorFactory aggregatorFactory, RecordDescriptor inRecordDesc, RecordDescriptor outRecordDesc, IFrameWriter writer, boolean outputPartial, boolean groupAll, int framesLimit) throws HyracksDataException {
        this.groupFields = groupFields;
        this.comparators = comparators;
        if (framesLimit >= 0 && framesLimit <= 2) {
            throw HyracksDataException.create((int)90, (Serializable[])new Serializable[]{"GROUP BY", Long.toString((long)framesLimit * (long)ctx.getInitialFrameSize()), Long.toString(2L * (long)ctx.getInitialFrameSize())});
        }
        this.memoryLimit = framesLimit <= 0 ? -1L : (long)(framesLimit - 2) * (long)ctx.getInitialFrameSize();
        this.aggregator = aggregatorFactory.createAggregator(ctx, inRecordDesc, outRecordDesc, groupFields, groupFields, writer, this.memoryLimit);
        this.aggregateState = this.aggregator.createAggregateStates();
        this.inFrameAccessor = new FrameTupleAccessor(inRecordDesc);
        this.groupFieldsRef = new PermutingFrameTupleReference(groupFields);
        this.groupFieldsPrevCopy = PointableTupleReference.create((int)groupFields.length, ArrayBackedValueStorage::new);
        VSizeFrame outFrame = new VSizeFrame((IHyracksFrameMgrContext)ctx);
        FrameTupleAppender appender = new FrameTupleAppender();
        appender.reset((IFrame)outFrame, true);
        this.appenderWrapper = new FrameTupleAppenderWrapper((IFrameTupleAppender)appender, writer);
        this.tupleBuilder = new ArrayTupleBuilder(outRecordDesc.getFields().length);
        this.outputPartial = outputPartial;
        this.groupAll = groupAll;
    }

    public void open() throws HyracksDataException {
        this.appenderWrapper.open();
        this.first = true;
    }

    public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.inFrameAccessor.reset(buffer);
        int nTuples = this.inFrameAccessor.getTupleCount();
        if (nTuples != 0) {
            for (int i = 0; i < nTuples; ++i) {
                if (this.first) {
                    this.tupleBuilder.reset();
                    for (int groupFieldIdx : this.groupFields) {
                        this.tupleBuilder.addField((IFrameTupleAccessor)this.inFrameAccessor, i, groupFieldIdx);
                    }
                    this.aggregator.init(this.tupleBuilder, (IFrameTupleAccessor)this.inFrameAccessor, i, this.aggregateState);
                    this.first = false;
                    continue;
                }
                if (i == 0) {
                    this.switchGroupIfRequired((ITupleReference)this.groupFieldsPrevCopy, (IFrameTupleAccessor)this.inFrameAccessor, 0);
                    continue;
                }
                this.groupFieldsRef.reset((IFrameTupleAccessor)this.inFrameAccessor, i - 1);
                this.switchGroupIfRequired((ITupleReference)this.groupFieldsRef, (IFrameTupleAccessor)this.inFrameAccessor, i);
            }
            this.groupFieldsRef.reset((IFrameTupleAccessor)this.inFrameAccessor, nTuples - 1);
            this.groupFieldsPrevCopy.set((ITupleReference)this.groupFieldsRef);
        }
    }

    private void switchGroupIfRequired(ITupleReference prevTupleGroupFields, IFrameTupleAccessor currTupleAccessor, int currTupleIndex) throws HyracksDataException {
        if (!PreclusteredGroupWriter.sameGroup(prevTupleGroupFields, currTupleAccessor, currTupleIndex, this.groupFields, this.comparators)) {
            this.writeOutput(prevTupleGroupFields);
            this.tupleBuilder.reset();
            for (int groupFieldIdx : this.groupFields) {
                this.tupleBuilder.addField(currTupleAccessor, currTupleIndex, groupFieldIdx);
            }
            this.aggregator.init(this.tupleBuilder, currTupleAccessor, currTupleIndex, this.aggregateState);
        } else {
            this.aggregator.aggregate(currTupleAccessor, currTupleIndex, null, 0, this.aggregateState);
        }
    }

    private void writeOutput(ITupleReference lastTupleGroupFields) throws HyracksDataException {
        boolean hasOutput;
        this.tupleBuilder.reset();
        for (int i = 0; i < this.groupFields.length; ++i) {
            this.tupleBuilder.addField(lastTupleGroupFields, i);
        }
        boolean bl = hasOutput = this.outputPartial ? this.aggregator.outputPartialResult(this.tupleBuilder, null, 0, this.aggregateState) : this.aggregator.outputFinalResult(this.tupleBuilder, null, 0, this.aggregateState);
        if (hasOutput) {
            this.appenderWrapper.appendSkipEmptyField(this.tupleBuilder.getFieldEndOffsets(), this.tupleBuilder.getByteArray(), 0, this.tupleBuilder.getSize());
        }
    }

    public static boolean sameGroup(ITupleReference prevTupleGroupFields, IFrameTupleAccessor curTupleAccessor, int curTupleIdx, int[] curTupleGroupFields, IBinaryComparator[] comparators) throws HyracksDataException {
        for (int i = 0; i < comparators.length; ++i) {
            int curTupleFieldLength;
            int curTupleFieldIdx;
            int curTupleFieldStart;
            byte[] curTupleFieldData;
            int prevTupleFieldLength;
            int prevTupleFieldStart;
            byte[] prevTupleFieldData = prevTupleGroupFields.getFieldData(i);
            if (comparators[i].compare(prevTupleFieldData, prevTupleFieldStart = prevTupleGroupFields.getFieldStart(i), prevTupleFieldLength = prevTupleGroupFields.getFieldLength(i), curTupleFieldData = curTupleAccessor.getBuffer().array(), curTupleFieldStart = curTupleAccessor.getAbsoluteFieldStartOffset(curTupleIdx, curTupleFieldIdx = curTupleGroupFields[i]), curTupleFieldLength = curTupleAccessor.getFieldLength(curTupleIdx, curTupleFieldIdx)) == 0) continue;
            return false;
        }
        return true;
    }

    public void fail() throws HyracksDataException {
        this.isFailed = true;
        this.appenderWrapper.fail();
    }

    public void close() throws HyracksDataException {
        try {
            if (!(this.isFailed || this.first && !this.groupAll)) {
                this.writeOutput((ITupleReference)this.groupFieldsPrevCopy);
                this.appenderWrapper.write();
            }
            this.aggregator.close();
            this.aggregateState.close();
        }
        catch (Exception e) {
            this.appenderWrapper.fail();
            throw e;
        }
        finally {
            this.appenderWrapper.close();
        }
    }
}

