/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.endpoint.dcp;

import com.couchbase.client.core.ResponseEvent;
import com.couchbase.client.core.endpoint.AbstractEndpoint;
import com.couchbase.client.core.endpoint.AbstractGenericHandler;
import com.couchbase.client.core.endpoint.ResponseStatusConverter;
import com.couchbase.client.core.endpoint.dcp.DCPConnection;
import com.couchbase.client.core.endpoint.kv.KeyValueStatus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.message.CouchbaseResponse;
import com.couchbase.client.core.message.dcp.AbstractDCPMessage;
import com.couchbase.client.core.message.dcp.AbstractDCPRequest;
import com.couchbase.client.core.message.dcp.AbstractDCPResponse;
import com.couchbase.client.core.message.dcp.DCPRequest;
import com.couchbase.client.core.message.dcp.ExpirationMessage;
import com.couchbase.client.core.message.dcp.FailoverLogEntry;
import com.couchbase.client.core.message.dcp.GetFailoverLogRequest;
import com.couchbase.client.core.message.dcp.GetFailoverLogResponse;
import com.couchbase.client.core.message.dcp.GetLastCheckpointRequest;
import com.couchbase.client.core.message.dcp.GetLastCheckpointResponse;
import com.couchbase.client.core.message.dcp.MutationMessage;
import com.couchbase.client.core.message.dcp.RemoveMessage;
import com.couchbase.client.core.message.dcp.SnapshotMarkerMessage;
import com.couchbase.client.core.message.dcp.StreamCloseRequest;
import com.couchbase.client.core.message.dcp.StreamCloseResponse;
import com.couchbase.client.core.message.dcp.StreamEndMessage;
import com.couchbase.client.core.message.dcp.StreamRequestRequest;
import com.couchbase.client.core.message.dcp.StreamRequestResponse;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.deps.com.lmax.disruptor.EventSink;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.BinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.DefaultBinaryMemcacheRequest;
import com.couchbase.client.deps.io.netty.handler.codec.memcache.binary.FullBinaryMemcacheResponse;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import rx.functions.Action1;

public class DCPHandler
extends AbstractGenericHandler<FullBinaryMemcacheResponse, BinaryMemcacheRequest, DCPRequest> {
    public static final byte OP_OPEN_CONNECTION = 80;
    public static final byte OP_STREAM_CLOSE = 82;
    public static final byte OP_STREAM_REQUEST = 83;
    public static final byte OP_STREAM_END = 85;
    public static final byte OP_SNAPSHOT_MARKER = 86;
    public static final byte OP_MUTATION = 87;
    public static final byte OP_REMOVE = 88;
    public static final byte OP_EXPIRATION = 89;
    public static final byte OP_CONTROL = 94;
    public static final byte OP_BUFFER_ACK = 93;
    public static final byte OP_GET_FAILOVER_LOG = 84;
    public static final byte OP_GET_LAST_CHECKPOINT = -105;
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DCPHandler.class);
    private DCPConnection connection;

    public DCPHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, boolean isTransient) {
        this(endpoint, responseBuffer, (Queue<DCPRequest>)new ArrayDeque<DCPRequest>(), isTransient);
    }

    public DCPHandler(AbstractEndpoint endpoint, EventSink<ResponseEvent> responseBuffer, Queue<DCPRequest> queue, boolean isTransient) {
        super(endpoint, responseBuffer, queue, isTransient);
    }

    @Override
    protected BinaryMemcacheRequest encodeRequest(ChannelHandlerContext ctx, DCPRequest msg) throws Exception {
        BinaryMemcacheRequest request;
        if (msg instanceof StreamRequestRequest) {
            StreamRequestRequest streamRequest = (StreamRequestRequest)msg;
            request = this.handleStreamRequestRequest(ctx, streamRequest);
            this.connection = streamRequest.connection();
        } else if (msg instanceof StreamCloseRequest) {
            request = this.handleStreamCloseRequest(ctx, (StreamCloseRequest)msg);
        } else if (msg instanceof GetFailoverLogRequest) {
            request = this.handleFailoverLogsRequest(ctx, (GetFailoverLogRequest)msg);
        } else if (msg instanceof GetLastCheckpointRequest) {
            request = this.handleGetLastCheckpointRequest(ctx, (GetLastCheckpointRequest)msg);
        } else {
            throw new IllegalArgumentException("Unknown incoming DCPRequest type " + msg.getClass());
        }
        if (msg.partition() >= 0) {
            request.setReserved(msg.partition());
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CouchbaseResponse decodeResponse(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) throws Exception {
        DCPRequest request = (DCPRequest)this.currentRequest();
        AbstractDCPResponse response = null;
        if (msg.getOpcode() == 83 && request instanceof StreamRequestRequest) {
            StreamRequestRequest streamRequest = (StreamRequestRequest)request;
            ByteBuf content = msg.content();
            List<FailoverLogEntry> failoverLog = null;
            long rollbackToSequenceNumber = 0L;
            KeyValueStatus status = KeyValueStatus.valueOf(msg.getStatus());
            switch (status) {
                case SUCCESS: {
                    failoverLog = this.readFailoverLogs(content);
                    break;
                }
                case ERR_ROLLBACK: {
                    rollbackToSequenceNumber = content.readLong();
                    break;
                }
                default: {
                    LOGGER.warn("Unexpected status of StreamRequestResponse: {} (0x{}, {})", new Object[]{status, Integer.toHexString(status.code()), status.description()});
                }
            }
            response = new StreamRequestResponse(ResponseStatusConverter.fromBinary(msg.getStatus()), failoverLog, rollbackToSequenceNumber, request);
            this.connection.registerContext(request.partition(), ctx);
            this.connection.consumed(request.partition(), msg.getTotalBodyLength());
        } else if (msg.getOpcode() == 82 && request instanceof StreamCloseRequest) {
            response = new StreamCloseResponse(ResponseStatusConverter.fromBinary(msg.getStatus()), request);
        } else if (msg.getOpcode() == 84 && request instanceof GetFailoverLogRequest) {
            response = new GetFailoverLogResponse(ResponseStatusConverter.fromBinary(msg.getStatus()), this.readFailoverLogs(msg.content()), request);
        } else if (msg.getOpcode() == -105 && request instanceof GetLastCheckpointRequest) {
            long sequenceNumber = msg.content().readLong();
            response = new GetLastCheckpointResponse(ResponseStatusConverter.fromBinary(msg.getStatus()), sequenceNumber, request);
        } else if (msg.getOpcode() == 93) {
            KeyValueStatus status = KeyValueStatus.valueOf(msg.getStatus());
            if (status != KeyValueStatus.SUCCESS) {
                LOGGER.warn("Unexpected status of service response (opcode={}): {} (0x{}, {})", new Object[]{Integer.toHexString(msg.getOpcode()), status, Integer.toHexString(status.code()), status.description()});
            }
        } else {
            DCPRequest oldRequest = (DCPRequest)this.currentRequest();
            AbstractDCPRequest dummy = new AbstractDCPRequest(this.connection.bucket(), null){};
            dummy.observable().subscribe((Action1)new Action1<CouchbaseResponse>(){

                public void call(CouchbaseResponse couchbaseResponse) {
                }
            }, (Action1)new Action1<Throwable>(){

                public void call(Throwable throwable) {
                    DCPHandler.this.connection.subject().onError(throwable);
                }
            });
            try {
                this.currentRequest(dummy);
                this.handleDCPRequest(ctx, msg);
            }
            finally {
                this.currentRequest(oldRequest);
            }
        }
        if (request != null && request.partition() >= 0 && response != null) {
            response.partition(request.partition());
        }
        if (response != null || request == null) {
            this.finishedDecoding();
        }
        return response;
    }

    private void handleDCPRequest(ChannelHandlerContext ctx, FullBinaryMemcacheResponse msg) {
        AbstractDCPMessage request = null;
        int flags = 0;
        long bySeqno = 0L;
        long revSeqno = 0L;
        switch (msg.getOpcode()) {
            case 86: {
                long startSequenceNumber = 0L;
                long endSequenceNumber = 0L;
                if (msg.getExtrasLength() > 0) {
                    ByteBuf extras = msg.getExtras();
                    startSequenceNumber = extras.readLong();
                    endSequenceNumber = extras.readLong();
                    flags = extras.readInt();
                }
                request = new SnapshotMarkerMessage(msg.getTotalBodyLength(), msg.getStatus(), startSequenceNumber, endSequenceNumber, flags, this.connection.bucket());
                break;
            }
            case 87: {
                int expiration = 0;
                int lockTime = 0;
                if (msg.getExtrasLength() > 0) {
                    ByteBuf extras = msg.getExtras();
                    bySeqno = extras.readLong();
                    revSeqno = extras.readLong();
                    flags = extras.readInt();
                    expiration = extras.readInt();
                    lockTime = extras.readInt();
                }
                request = new MutationMessage(msg.getTotalBodyLength(), msg.getStatus(), new String(msg.getKey(), CHARSET), msg.content().retain(), expiration, bySeqno, revSeqno, flags, lockTime, msg.getCAS(), this.connection.bucket());
                break;
            }
            case 88: {
                if (msg.getExtrasLength() > 0) {
                    ByteBuf extras = msg.getExtras();
                    bySeqno = extras.readLong();
                    revSeqno = extras.readLong();
                }
                request = new RemoveMessage(msg.getTotalBodyLength(), msg.getStatus(), new String(msg.getKey(), CHARSET), msg.getCAS(), bySeqno, revSeqno, this.connection.bucket());
                break;
            }
            case 89: {
                if (msg.getExtrasLength() > 0) {
                    ByteBuf extras = msg.getExtras();
                    bySeqno = extras.readLong();
                    revSeqno = extras.readLong();
                }
                request = new ExpirationMessage(msg.getTotalBodyLength(), msg.getStatus(), new String(msg.getKey(), CHARSET), msg.getCAS(), bySeqno, revSeqno, this.connection.bucket());
                break;
            }
            case 85: {
                ByteBuf extras = msg.getExtras();
                StreamEndMessage.Reason reason = StreamEndMessage.Reason.valueOf(extras.readInt());
                request = new StreamEndMessage(msg.getTotalBodyLength(), msg.getStatus(), reason, this.connection.bucket());
                this.connection.streamClosed(request.partition(), reason);
                break;
            }
            default: {
                LOGGER.info("Unhandled DCP message: {}, {}", (Object)msg.getOpcode(), (Object)msg);
            }
        }
        if (request != null) {
            this.connection.subject().onNext(request);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
    }

    private BinaryMemcacheRequest handleStreamRequestRequest(ChannelHandlerContext ctx, StreamRequestRequest msg) {
        ByteBuf extras = ctx.alloc().buffer(48);
        extras.writeInt(0).writeInt(0).writeLong(msg.startSequenceNumber()).writeLong(msg.endSequenceNumber()).writeLong(msg.vbucketUUID()).writeLong(msg.snapshotStartSequenceNumber()).writeLong(msg.snapshotEndSequenceNumber());
        byte extrasLength = (byte)extras.readableBytes();
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest(extras);
        request.setOpcode((byte)83);
        request.setExtrasLength(extrasLength);
        request.setTotalBodyLength(extrasLength);
        return request;
    }

    private BinaryMemcacheRequest handleStreamCloseRequest(ChannelHandlerContext ctx, StreamCloseRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)82);
        return request;
    }

    private BinaryMemcacheRequest handleFailoverLogsRequest(ChannelHandlerContext ctx, GetFailoverLogRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)84);
        request.setReserved(msg.partition());
        return request;
    }

    private List<FailoverLogEntry> readFailoverLogs(ByteBuf content) {
        ArrayList<FailoverLogEntry> failoverLog = new ArrayList<FailoverLogEntry>(content.readableBytes() / 16);
        while (content.readableBytes() >= 16) {
            FailoverLogEntry entry = new FailoverLogEntry(content.readLong(), content.readLong());
            failoverLog.add(entry);
        }
        return failoverLog;
    }

    private BinaryMemcacheRequest handleGetLastCheckpointRequest(ChannelHandlerContext ctx, GetLastCheckpointRequest msg) {
        DefaultBinaryMemcacheRequest request = new DefaultBinaryMemcacheRequest();
        request.setOpcode((byte)-105);
        request.setReserved(msg.partition());
        return request;
    }

    @Override
    protected ServiceType serviceType() {
        return ServiceType.DCP;
    }
}

