/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.geo.evaluators.functions;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.SpatialReference;
import com.esri.core.geometry.ogc.OGCGeometry;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.asterix.geo.evaluators.functions.AbstractGetValDescriptor;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public class STMakeEnvelopeDescriptorSRID
extends AbstractGetValDescriptor {
    public static final IFunctionDescriptorFactory FACTORY = new IFunctionDescriptorFactory(){

        public IFunctionDescriptor createFunctionDescriptor() {
            return new STMakeEnvelopeDescriptorSRID();
        }
    };
    private static final long serialVersionUID = 1L;

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ST_MAKE_ENVELOPE;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new STMakeEnvelopeEvaluator(args, ctx);
            }
        };
    }

    private class STMakeEnvelopeEvaluator
    implements IScalarEvaluator {
        private ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
        private DataOutput out = this.resultStorage.getDataOutput();
        private IPointable inputArg0 = new VoidPointable();
        private IScalarEvaluator eval0;
        private IPointable inputArg1;
        private IScalarEvaluator eval1;
        private IPointable inputArg2;
        private IScalarEvaluator eval2;
        private IPointable inputArg3;
        private IScalarEvaluator eval3;
        private IPointable inputArg4;
        private IScalarEvaluator eval4;

        public STMakeEnvelopeEvaluator(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx) throws HyracksDataException {
            this.eval0 = args[0].createScalarEvaluator(ctx);
            this.inputArg1 = new VoidPointable();
            this.eval1 = args[1].createScalarEvaluator(ctx);
            this.inputArg2 = new VoidPointable();
            this.eval2 = args[2].createScalarEvaluator(ctx);
            this.inputArg3 = new VoidPointable();
            this.eval3 = args[3].createScalarEvaluator(ctx);
            this.inputArg4 = new VoidPointable();
            this.eval4 = args[4].createScalarEvaluator(ctx);
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.eval0.evaluate(tuple, this.inputArg0);
            byte[] data0 = this.inputArg0.getByteArray();
            int offset0 = this.inputArg0.getStartOffset();
            this.eval1.evaluate(tuple, this.inputArg1);
            byte[] data1 = this.inputArg1.getByteArray();
            int offset1 = this.inputArg1.getStartOffset();
            this.eval2.evaluate(tuple, this.inputArg2);
            byte[] data2 = this.inputArg2.getByteArray();
            int offset2 = this.inputArg2.getStartOffset();
            this.eval3.evaluate(tuple, this.inputArg3);
            byte[] data3 = this.inputArg3.getByteArray();
            int offset3 = this.inputArg3.getStartOffset();
            this.eval4.evaluate(tuple, this.inputArg4);
            byte[] data4 = this.inputArg4.getByteArray();
            int offset4 = this.inputArg4.getStartOffset();
            try {
                OGCGeometry ogcGeometry = OGCGeometry.createFromEsriGeometry((Geometry)new Envelope(STMakeEnvelopeDescriptorSRID.this.getVal(data0, offset0), STMakeEnvelopeDescriptorSRID.this.getVal(data1, offset1), STMakeEnvelopeDescriptorSRID.this.getVal(data2, offset2), STMakeEnvelopeDescriptorSRID.this.getVal(data3, offset3)), (SpatialReference)SpatialReference.create((int)((int)STMakeEnvelopeDescriptorSRID.this.getVal(data4, offset4))));
                ByteBuffer buffer = ogcGeometry.asBinary();
                byte[] bytes = buffer.array();
                this.out.writeByte(ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
                this.out.writeInt(bytes.length);
                this.out.write(bytes);
                result.set((IValueReference)this.resultStorage);
            }
            catch (IOException e) {
                throw new InvalidDataFormatException(STMakeEnvelopeDescriptorSRID.this.sourceLoc, STMakeEnvelopeDescriptorSRID.this.getIdentifier(), (Throwable)e, ATypeTag.SERIALIZED_GEOMETRY_TYPE_TAG);
            }
        }
    }
}

