/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.FunctionDataSource;
import org.apache.asterix.metadata.utils.MetadataConstants;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.base.AsterixOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.visitors.ILogicalOperatorVisitor;
import org.apache.hyracks.algebricks.rewriter.rules.SetMemoryRequirementsRule;

public final class SetAsterixMemoryRequirementsRule
extends SetMemoryRequirementsRule {
    protected ILogicalOperatorVisitor<Void, Void> createMemoryRequirementsConfigurator(IOptimizationContext context) {
        return this.forceMinMemoryBudget((AsterixOptimizationContext)context) ? null : super.createMemoryRequirementsConfigurator(context);
    }

    private boolean forceMinMemoryBudget(AsterixOptimizationContext context) {
        Int2ObjectMap<Set<DataSource>> dataSourceMap = context.getDataSourceMap();
        if (dataSourceMap.isEmpty()) {
            return false;
        }
        for (Int2ObjectMap.Entry me : dataSourceMap.int2ObjectEntrySet()) {
            Predicate<DataSource> dataSourceTest;
            int dataSourceType = me.getIntKey();
            switch (dataSourceType) {
                case 0: {
                    dataSourceTest = SetAsterixMemoryRequirementsRule::isMinMemoryBudgetDataset;
                    break;
                }
                case 4: {
                    dataSourceTest = SetAsterixMemoryRequirementsRule::isMinMemoryBudgetFunction;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (((Set)me.getValue()).stream().allMatch(dataSourceTest)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMinMemoryBudgetDataset(DataSource ds) {
        return MetadataConstants.METADATA_DATAVERSE_NAME.equals((Object)ds.getId().getDataverseName());
    }

    private static boolean isMinMemoryBudgetFunction(DataSource ds) {
        FunctionDataSource fds = (FunctionDataSource)ds;
        return BuiltinFunctions.builtinFunctionHasProperty((FunctionIdentifier)fds.getFunctionId(), (BuiltinFunctions.BuiltinFunctionProperty)BuiltinFunctions.DataSourceFunctionProperty.MIN_MEMORY_BUDGET);
    }
}

