/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.library.msgpack.MessagePackerFromADM;
import org.apache.hyracks.api.util.JavaSerializationUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PythonMessageBuilder {
    private static final int MAX_BUF_SIZE = 0x1500000;
    private static final Logger LOGGER = LogManager.getLogger();
    MessageType type = null;
    long dataLength = -1L;
    ByteBuffer buf;
    String[] initAry = new String[3];

    public PythonMessageBuilder() {
        this.buf = ByteBuffer.allocate(4096);
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public void packHeader() {
        MessagePackerFromADM.packFixPos(this.buf, (byte)this.type.ordinal());
    }

    private int getStringLength(String s) {
        return s.length();
    }

    public void readHead(ByteBuffer buf) {
        byte typ = buf.get();
        this.type = MessageType.fromByte(typ);
    }

    public void hello() throws IOException {
        this.type = MessageType.HELO;
        byte[] serAddr = this.serialize(new InetSocketAddress(InetAddress.getLoopbackAddress(), 1));
        this.dataLength = serAddr.length + 5;
        this.packHeader();
        this.buf.put((byte)-58);
        this.buf.putInt(serAddr.length);
        this.buf.put(serAddr);
    }

    public void quit() {
        this.type = MessageType.QUIT;
        this.dataLength = this.getStringLength("QUIT");
        this.packHeader();
        MessagePackerFromADM.packFixStr(this.buf, "QUIT");
    }

    public void init(String module, String clazz, String fn) {
        this.type = MessageType.INIT;
        this.initAry[0] = module;
        this.initAry[1] = clazz;
        this.initAry[2] = fn;
        this.dataLength = Arrays.stream(this.initAry).mapToInt(s -> this.getStringLength((String)s)).sum() + 2;
        this.packHeader();
        MessagePackerFromADM.packFixArrayHeader(this.buf, (byte)this.initAry.length);
        for (String s2 : this.initAry) {
            MessagePackerFromADM.packStr(this.buf, s2);
        }
    }

    public void call(byte[] args, int lim, int numArgs) {
        if (args.length > this.buf.capacity()) {
            int growTo = ExternalFunctionResultRouter.closestPow2((int)args.length);
            if (growTo > 0x1500000) {
                throw new IllegalArgumentException("Reached maximum buffer size");
            }
            this.buf = ByteBuffer.allocate(growTo);
        }
        this.buf.clear();
        this.buf.position(0);
        this.type = MessageType.CALL;
        this.dataLength = 6 + lim;
        this.packHeader();
        if (numArgs == 0) {
            this.buf.put((byte)-64);
        } else {
            this.buf.put((byte)-35);
            this.buf.putInt(numArgs);
            this.buf.put(args, 0, lim);
        }
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = JavaSerializationUtils.getSerializationProvider().newObjectOutputStream((OutputStream)baos);){
            oos.writeObject(object);
            oos.flush();
            baos.close();
        }
        return baos.toByteArray();
    }
}

