/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.function;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.DataSource;
import org.apache.asterix.metadata.declared.DataSourceId;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.metadata.entities.Dataset;
import org.apache.asterix.om.functions.IFunctionToDataSourceRewriter;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.optimizer.rules.UnnestToDataScanRule;
import org.apache.asterix.optimizer.rules.util.EquivalenceClassUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IDataSource;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.DataSourceScanOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.UnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.FunctionalDependency;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class DatasetRewriter
implements IFunctionToDataSourceRewriter,
IResultTypeComputer {
    public static final DatasetRewriter INSTANCE = new DatasetRewriter();

    private DatasetRewriter() {
    }

    public boolean rewrite(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractFunctionCallExpression f = UnnestToDataScanRule.getFunctionCall(opRef);
        UnnestOperator unnest = (UnnestOperator)opRef.getValue();
        if (unnest.getPositionalVariable() != null) {
            throw new CompilationException(1079, unnest.getSourceLocation(), new Serializable[]{"No positional variables are allowed over datasets."});
        }
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        Pair datasetReference = FunctionUtil.parseDatasetFunctionArguments((List)f.getArguments(), (DataverseName)metadataProvider.getDefaultDataverseName(), (SourceLocation)unnest.getSourceLocation());
        DataverseName dataverseName = (DataverseName)datasetReference.first;
        String datasetName = (String)datasetReference.second;
        Dataset dataset = metadataProvider.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new CompilationException(1050, unnest.getSourceLocation(), new Serializable[]{datasetName, dataverseName});
        }
        DataSourceId dsid = new DataSourceId(dataset.getDataverseName(), dataset.getDatasetName());
        ArrayList<LogicalVariable> variables = new ArrayList<LogicalVariable>();
        if (dataset.getDatasetType() == DatasetConfig.DatasetType.INTERNAL) {
            int numPrimaryKeys = dataset.getPrimaryKeys().size();
            for (int i = 0; i < numPrimaryKeys; ++i) {
                variables.add(context.newVar());
            }
        }
        variables.add(unnest.getVariable());
        DataSource dataSource = metadataProvider.findDataSource(dsid);
        boolean hasMeta = dataSource.hasMeta();
        if (hasMeta) {
            variables.add(context.newVar());
        }
        DataSourceScanOperator scan = new DataSourceScanOperator(variables, (IDataSource)dataSource);
        scan.setSourceLocation(unnest.getSourceLocation());
        List scanInpList = scan.getInputs();
        scanInpList.addAll(unnest.getInputs());
        opRef.setValue((Object)scan);
        this.addPrimaryKey(variables, dataSource, context);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)scan);
        IAType[] schemaTypes = dataSource.getSchemaTypes();
        ARecordType recordType = (ARecordType)(hasMeta ? schemaTypes[schemaTypes.length - 2] : schemaTypes[schemaTypes.length - 1]);
        ARecordType metaRecordType = (ARecordType)(hasMeta ? schemaTypes[schemaTypes.length - 1] : null);
        EquivalenceClassUtils.addEquivalenceClassesForPrimaryIndexAccess((ILogicalOperator)scan, variables, (ARecordType)recordType, (ARecordType)metaRecordType, (Dataset)dataset, (IOptimizationContext)context);
        return true;
    }

    private void addPrimaryKey(List<LogicalVariable> scanVariables, DataSource dataSource, IOptimizationContext context) {
        List primaryKey = dataSource.getPrimaryKeyVariables(scanVariables);
        ArrayList<LogicalVariable> tail = new ArrayList<LogicalVariable>();
        tail.addAll(scanVariables);
        FunctionalDependency pk = new FunctionalDependency(primaryKey, tail);
        context.addPrimaryKey(pk);
    }

    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> mp) throws AlgebricksException {
        AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expression;
        MetadataProvider metadata = (MetadataProvider)mp;
        Pair datasetInfo = FunctionUtil.parseDatasetFunctionArguments((List)f.getArguments(), (DataverseName)metadata.getDefaultDataverseName(), (SourceLocation)f.getSourceLocation());
        DataverseName dataverseName = (DataverseName)datasetInfo.first;
        String datasetName = (String)datasetInfo.second;
        Dataset dataset = metadata.findDataset(dataverseName, datasetName);
        if (dataset == null) {
            throw new CompilationException(1050, f.getSourceLocation(), new Serializable[]{datasetName, dataverseName});
        }
        String tn = dataset.getItemTypeName();
        IAType t2 = metadata.findType(dataset.getItemTypeDataverseName(), tn);
        if (t2 == null) {
            throw new AlgebricksException("No type for dataset " + datasetName);
        }
        return t2;
    }
}

