/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.common.data.accessors;

import java.util.function.Supplier;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;

public class PointableTupleReference
implements ITupleReference {
    private final IPointable[] fields;

    public PointableTupleReference(IPointable[] fields) {
        this.fields = fields;
    }

    @Override
    public int getFieldCount() {
        return this.fields.length;
    }

    @Override
    public byte[] getFieldData(int fIdx) {
        return this.getField(fIdx).getByteArray();
    }

    @Override
    public int getFieldStart(int fIdx) {
        return this.getField(fIdx).getStartOffset();
    }

    @Override
    public int getFieldLength(int fIdx) {
        return this.getField(fIdx).getLength();
    }

    public IPointable getField(int fIdx) {
        return this.fields[fIdx];
    }

    public void set(ITupleReference tupleRef) {
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].set(tupleRef.getFieldData(i), tupleRef.getFieldStart(i), tupleRef.getFieldLength(i));
        }
    }

    public static PointableTupleReference create(int fieldCount, Supplier<IPointable> fieldFactory) {
        IPointable[] fields = new IPointable[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = fieldFactory.get();
        }
        return new PointableTupleReference(fields);
    }

    public static PointableTupleReference create(int fieldCount, IPointableFactory fieldFactory) {
        return PointableTupleReference.create(fieldCount, () -> ((IPointableFactory)fieldFactory).createPointable());
    }
}

