/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.util;

import java.util.ArrayList;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IObjectFactory;

public class ObjectCache<T> {
    protected final int expandSize;
    protected final IObjectFactory<T> objFactory;
    protected final ArrayList<T> cache;
    protected int lastReturned = 0;

    public ObjectCache(IObjectFactory<T> objFactory, int initialSize, int expandSize) throws HyracksDataException {
        this.objFactory = objFactory;
        this.cache = new ArrayList(initialSize);
        this.expandSize = expandSize;
        this.expand(initialSize);
    }

    private void expand(int expandSize) throws HyracksDataException {
        for (int i = 0; i < expandSize; ++i) {
            this.cache.add(this.objFactory.create());
        }
    }

    public void reset() {
        this.lastReturned = 0;
    }

    public T getNext() throws HyracksDataException {
        if (this.lastReturned >= this.cache.size()) {
            this.expand(this.expandSize);
        }
        return this.cache.get(this.lastReturned++);
    }
}

