/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.pointables.cast;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.om.pointables.AFlatValuePointable;
import org.apache.asterix.om.pointables.AListVisitablePointable;
import org.apache.asterix.om.pointables.ARecordVisitablePointable;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.pointables.base.IVisitablePointable;
import org.apache.asterix.om.pointables.cast.AListCaster;
import org.apache.asterix.om.pointables.cast.ARecordCaster;
import org.apache.asterix.om.pointables.visitor.IVisitablePointableVisitor;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.algebricks.common.utils.Triple;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;

public class ACastVisitor
implements IVisitablePointableVisitor<Void, Triple<IVisitablePointable, IAType, Boolean>> {
    private final Map<IVisitablePointable, ARecordCaster> raccessorToCaster = new HashMap<IVisitablePointable, ARecordCaster>();
    private final Map<IVisitablePointable, AListCaster> laccessorToCaster = new HashMap<IVisitablePointable, AListCaster>();
    private final ArrayBackedValueStorage castBuffer = new ArrayBackedValueStorage();
    private final boolean strictDemote;
    private final SourceLocation sourceLoc;

    public ACastVisitor() {
        this(true, null);
    }

    public ACastVisitor(SourceLocation sourceLoc) {
        this(true, sourceLoc);
    }

    public ACastVisitor(boolean strictDemote, SourceLocation sourceLoc) {
        this.strictDemote = strictDemote;
        this.sourceLoc = sourceLoc;
    }

    @Override
    public Void visit(AListVisitablePointable accessor, Triple<IVisitablePointable, IAType, Boolean> arg) throws HyracksDataException {
        AbstractCollectionType resultType;
        AListCaster caster = this.laccessorToCaster.get(accessor);
        if (caster == null) {
            caster = new AListCaster();
            this.laccessorToCaster.put(accessor, caster);
        }
        switch (((IAType)arg.second).getTypeTag()) {
            case ANY: {
                resultType = accessor.ordered() ? DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE : DefaultOpenFieldType.NESTED_OPEN_AUNORDERED_LIST_TYPE;
                break;
            }
            case ARRAY: 
            case MULTISET: {
                resultType = (AbstractCollectionType)arg.second;
                break;
            }
            default: {
                throw new RuntimeDataException(18, this.sourceLoc, new Serializable[]{accessor.ordered() ? ATypeTag.ARRAY : ATypeTag.MULTISET, ((IAType)arg.second).getTypeTag()});
            }
        }
        caster.castList(accessor, (IVisitablePointable)arg.first, resultType, this);
        return null;
    }

    @Override
    public Void visit(ARecordVisitablePointable accessor, Triple<IVisitablePointable, IAType, Boolean> arg) throws HyracksDataException {
        ARecordType resultType;
        ARecordCaster caster = this.raccessorToCaster.get(accessor);
        if (caster == null) {
            caster = new ARecordCaster();
            this.raccessorToCaster.put(accessor, caster);
        }
        switch (((IAType)arg.second).getTypeTag()) {
            case ANY: {
                resultType = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
                break;
            }
            case OBJECT: {
                resultType = (ARecordType)arg.second;
                break;
            }
            default: {
                throw new RuntimeDataException(18, this.sourceLoc, new Serializable[]{ATypeTag.OBJECT, ((IAType)arg.second).getTypeTag()});
            }
        }
        caster.castRecord(accessor, (IVisitablePointable)arg.first, resultType, this);
        return null;
    }

    @Override
    public Void visit(AFlatValuePointable accessor, Triple<IVisitablePointable, IAType, Boolean> arg) throws HyracksDataException {
        if (arg.second == null) {
            ((IVisitablePointable)arg.first).set((IValueReference)accessor);
            return null;
        }
        ATypeTag reqTypeTag = ((IAType)arg.second).getTypeTag();
        if (reqTypeTag == ATypeTag.ANY) {
            ((IVisitablePointable)arg.first).set((IValueReference)accessor);
            return null;
        }
        ATypeTag inputTypeTag = EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(accessor.getByteArray()[accessor.getStartOffset()]);
        if (!this.needPromote(inputTypeTag, reqTypeTag)) {
            ((IVisitablePointable)arg.first).set((IValueReference)accessor);
        } else {
            try {
                this.castBuffer.reset();
                ATypeHierarchy.convertNumericTypeByteArray(accessor.getByteArray(), accessor.getStartOffset(), accessor.getLength(), reqTypeTag, this.castBuffer.getDataOutput(), this.strictDemote);
                ((IVisitablePointable)arg.first).set((IValueReference)this.castBuffer);
            }
            catch (HyracksDataException e) {
                throw e;
            }
            catch (IOException e) {
                throw new RuntimeDataException(18, this.sourceLoc, new Serializable[]{inputTypeTag, reqTypeTag});
            }
        }
        return null;
    }

    private boolean needPromote(ATypeTag tag0, ATypeTag tag1) {
        return tag0 != tag1 && tag0 != ATypeTag.NULL && tag0 != ATypeTag.MISSING;
    }
}

