/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import java.io.Serializable;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.dataflow.data.common.TypeResolverUtil;
import org.apache.asterix.om.typecomputer.base.IResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.metadata.IMetadataProvider;
import org.apache.hyracks.api.exceptions.SourceLocation;

abstract class AbstractIfMissingOrNullTypeComputer
implements IResultTypeComputer {
    AbstractIfMissingOrNullTypeComputer() {
    }

    @Override
    public IAType computeType(ILogicalExpression expression, IVariableTypeEnvironment env, IMetadataProvider<?, ?> metadataProvider) throws AlgebricksException {
        AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expression;
        SourceLocation sourceLoc = fce.getSourceLocation();
        IAType outPrimeType = null;
        ATypeTag outQuantifier = null;
        for (Mutable argRef : fce.getArguments()) {
            ILogicalExpression arg = (ILogicalExpression)argRef.getValue();
            IAType argType = (IAType)env.getType(arg);
            ATypeTag argTypeTag = argType.getTypeTag();
            if (this.equalsIfType(argTypeTag)) continue;
            if (argTypeTag == ATypeTag.UNION) {
                IAType primeType;
                AUnionType unionType = (AUnionType)argType;
                if (this.intersectsIfType(unionType)) {
                    primeType = this.getOutputPrimeType(unionType);
                    IAType iAType = outPrimeType = outPrimeType == null ? primeType : TypeResolverUtil.resolve(outPrimeType, primeType);
                    if (outQuantifier != null) continue;
                    outQuantifier = this.getOutputQuantifier(unionType);
                    continue;
                }
                if (outPrimeType == null) {
                    return argType;
                }
                primeType = this.getOutputPrimeType(unionType);
                ATypeTag quantifier = outQuantifier != null ? outQuantifier : this.getOutputQuantifier(unionType);
                return this.createOutputType(TypeResolverUtil.resolve(outPrimeType, primeType), quantifier, sourceLoc);
            }
            return outPrimeType == null ? argType : this.createOutputType(TypeResolverUtil.resolve(outPrimeType, argType), outQuantifier, sourceLoc);
        }
        if (outPrimeType == null) {
            return BuiltinType.ANULL;
        }
        IAType outType = this.createOutputType(outPrimeType, ATypeTag.NULL, sourceLoc);
        if (outQuantifier == ATypeTag.MISSING) {
            outType = this.createOutputType(outType, ATypeTag.MISSING, sourceLoc);
        }
        return outType;
    }

    protected abstract boolean equalsIfType(ATypeTag var1);

    protected abstract boolean intersectsIfType(AUnionType var1);

    protected abstract ATypeTag getOutputQuantifier(AUnionType var1);

    private IAType getOutputPrimeType(AUnionType type) {
        return type.getActualType();
    }

    private IAType createOutputType(IAType primeType, ATypeTag quantifier, SourceLocation sourceLoc) throws CompilationException {
        if (quantifier == null || primeType.getTypeTag() == ATypeTag.ANY) {
            return primeType;
        }
        switch (quantifier) {
            case MISSING: {
                return AUnionType.createMissableType(primeType);
            }
            case NULL: {
                return AUnionType.createNullableType(primeType, null);
            }
        }
        throw new CompilationException(1038, sourceLoc, new Serializable[]{"Unexpected quantifier: " + quantifier});
    }
}

