/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.om.typecomputer.impl;

import org.apache.asterix.om.exceptions.UnsupportedTypeException;
import org.apache.asterix.om.typecomputer.base.AbstractResultTypeComputer;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.IAType;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class NumericSumAggTypeComputer
extends AbstractResultTypeComputer {
    public static final NumericSumAggTypeComputer INSTANCE = new NumericSumAggTypeComputer();

    private NumericSumAggTypeComputer() {
    }

    @Override
    protected void checkArgType(FunctionIdentifier funcId, int argIndex, IAType type, SourceLocation sourceLoc) throws AlgebricksException {
        ATypeTag tag = type.getTypeTag();
        switch (tag) {
            case DOUBLE: 
            case FLOAT: 
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: 
            case ANY: {
                break;
            }
            default: {
                throw new UnsupportedTypeException(sourceLoc, funcId, tag);
            }
        }
    }

    @Override
    protected IAType getResultType(ILogicalExpression expr, IAType ... strippedInputTypes) throws AlgebricksException {
        ATypeTag tag = strippedInputTypes[0].getTypeTag();
        switch (tag) {
            case BIGINT: 
            case INTEGER: 
            case SMALLINT: 
            case TINYINT: {
                BuiltinType int64Type = BuiltinType.AINT64;
                return AUnionType.createNullableType(int64Type, "AggResult");
            }
            case DOUBLE: 
            case FLOAT: {
                BuiltinType doubleType = BuiltinType.ADOUBLE;
                return AUnionType.createNullableType(doubleType, "AggResult");
            }
            case ANY: {
                IAType anyType = strippedInputTypes[0];
                return AUnionType.createNullableType(anyType, "AggResult");
            }
        }
        return BuiltinType.ANULL;
    }
}

