/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.rewriter.rules;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.utils.Pair;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractLogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.OrderOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class EnforceOrderByAfterSubplan
implements IAlgebraicRewriteRule {
    private final Set<LogicalOperatorTag> orderBreakingOps = new HashSet<LogicalOperatorTag>();
    private final Set<LogicalOperatorTag> orderSensitiveOps = new HashSet<LogicalOperatorTag>();

    public EnforceOrderByAfterSubplan() {
        this.orderBreakingOps.add(LogicalOperatorTag.INNERJOIN);
        this.orderBreakingOps.add(LogicalOperatorTag.LEFTOUTERJOIN);
        this.orderBreakingOps.add(LogicalOperatorTag.UNIONALL);
        this.orderBreakingOps.add(LogicalOperatorTag.AGGREGATE);
        this.orderSensitiveOps.add(LogicalOperatorTag.LIMIT);
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op1 = (AbstractLogicalOperator)opRef.getValue();
        if (context.checkIfInDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1)) {
            return false;
        }
        List inputs = op1.getInputs();
        context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op1);
        if (op1.getOperatorTag() == LogicalOperatorTag.ORDER || inputs == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < inputs.size(); ++i) {
            Mutable inputOpRef = (Mutable)inputs.get(i);
            AbstractLogicalOperator op = (AbstractLogicalOperator)inputOpRef.getValue();
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)op);
            if (op.getOperatorTag() != LogicalOperatorTag.SUBPLAN) continue;
            boolean foundTarget = true;
            boolean orderSensitive = false;
            Mutable childRef = (Mutable)op.getInputs().get(0);
            AbstractLogicalOperator child = (AbstractLogicalOperator)childRef.getValue();
            while (child.getOperatorTag() != LogicalOperatorTag.ORDER) {
                List childInputs;
                context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)child);
                if (this.orderBreakingOps.contains(child.getOperatorTag())) {
                    foundTarget = false;
                    break;
                }
                if (child.getOperatorTag() == LogicalOperatorTag.GROUP) {
                    foundTarget = false;
                    break;
                }
                if (this.orderSensitiveOps.contains(child.getOperatorTag())) {
                    orderSensitive = true;
                }
                if ((childInputs = child.getInputs()) == null || childInputs.size() > 2 || childInputs.size() < 1) {
                    foundTarget = false;
                    break;
                }
                childRef = (Mutable)childInputs.get(0);
                child = (AbstractLogicalOperator)childRef.getValue();
            }
            if (!foundTarget) {
                return false;
            }
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)child);
            OrderOperator sourceOrderOp = (OrderOperator)child;
            for (Pair expr : sourceOrderOp.getOrderExpressions()) {
                if (((ILogicalExpression)((Mutable)expr.second).getValue()).isFunctional()) continue;
                return false;
            }
            List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> orderExprs = this.deepCopyOrderAndExpression(sourceOrderOp.getOrderExpressions());
            OrderOperator newOrderOp = new OrderOperator(orderExprs);
            newOrderOp.setSourceLocation(sourceOrderOp.getSourceLocation());
            context.addToDontApplySet((IAlgebraicRewriteRule)this, (ILogicalOperator)newOrderOp);
            inputs.set(i, new MutableObject((Object)newOrderOp));
            newOrderOp.getInputs().add(inputOpRef);
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)newOrderOp);
            if (!orderSensitive) {
                childRef.setValue(((Mutable)sourceOrderOp.getInputs().get(0)).getValue());
            }
            changed = true;
        }
        return changed;
    }

    private Mutable<ILogicalExpression> deepCopyExpressionRef(Mutable<ILogicalExpression> oldExpr) {
        return new MutableObject((Object)((AbstractLogicalExpression)oldExpr.getValue()).cloneExpression());
    }

    private List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> deepCopyOrderAndExpression(List<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> ordersAndExprs) {
        ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>> newOrdersAndExprs = new ArrayList<Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>>();
        for (Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>> pair : ordersAndExprs) {
            newOrdersAndExprs.add((Pair<OrderOperator.IOrder, Mutable<ILogicalExpression>>)new Pair(pair.first, this.deepCopyExpressionRef((Mutable<ILogicalExpression>)((Mutable)pair.second))));
        }
        return newOrdersAndExprs;
    }
}

