/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.builders.IAsterixListBuilder;
import org.apache.asterix.builders.OrderedListBuilder;
import org.apache.asterix.builders.UnorderedListBuilder;
import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.formats.nontagged.BinaryComparatorFactoryProvider;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AbstractCollectionType;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ListAccessor;
import org.apache.asterix.runtime.evaluators.functions.AbstractScalarEval;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.functions.FunctionTypeInferers;
import org.apache.asterix.runtime.utils.DescriptorFactoryUtil;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class ArrayExceptDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    private IAType[] argTypes;
    public static final IFunctionDescriptorFactory FACTORY = DescriptorFactoryUtil.createFactory(ArrayExceptDescriptor::new, FunctionTypeInferers.SET_ARGUMENTS_TYPE);

    public void setImmutableStates(Object ... states) {
        this.argTypes = (IAType[])states;
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.ARRAY_EXCEPT;
    }

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) throws AlgebricksException {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(IEvaluatorContext ctx) throws HyracksDataException {
                return new ArrayExceptEval(args, ctx, ArrayExceptDescriptor.this.sourceLoc, ArrayExceptDescriptor.this.getIdentifier(), ArrayExceptDescriptor.this.argTypes);
            }
        };
    }

    private class ArrayExceptEval
    extends AbstractScalarEval {
        private final IEvaluatorContext ctx;
        private final ArrayBackedValueStorage storage;
        private final DataOutput storageOutput;
        private final IAsterixListBuilder orderedListBuilder;
        private final IAsterixListBuilder unorderedListBuilder;
        private final IScalarEvaluator arg1Eval;
        private final IScalarEvaluator arg2Eval;
        private final IPointable arg1Pointable;
        private final IPointable arg2Pointable;
        private final ListAccessor arg1ListAccessor;
        private final ListAccessor arg2ListAccessor;
        private IPointable arg1ListItem;
        private IPointable arg2ListItem;
        private ArrayBackedValueStorage arg1Storage;
        private ArrayBackedValueStorage arg2Storage;
        private IBinaryComparator comparator;

        ArrayExceptEval(IScalarEvaluatorFactory[] args, IEvaluatorContext ctx, SourceLocation sourceLocation, FunctionIdentifier functionIdentifier, IAType[] argTypes) throws HyracksDataException {
            super(sourceLocation, functionIdentifier);
            this.storage = new ArrayBackedValueStorage();
            this.storageOutput = this.storage.getDataOutput();
            this.orderedListBuilder = new OrderedListBuilder();
            this.unorderedListBuilder = new UnorderedListBuilder();
            this.arg1Pointable = new VoidPointable();
            this.arg2Pointable = new VoidPointable();
            this.arg1ListAccessor = new ListAccessor();
            this.arg2ListAccessor = new ListAccessor();
            this.arg1ListItem = new VoidPointable();
            this.arg2ListItem = new VoidPointable();
            this.arg1Storage = new ArrayBackedValueStorage();
            this.arg2Storage = new ArrayBackedValueStorage();
            this.ctx = ctx;
            this.arg1Eval = args[0].createScalarEvaluator(ctx);
            this.arg2Eval = args[1].createScalarEvaluator(ctx);
            IAType leftType = argTypes[0].getTypeTag() == ATypeTag.ARRAY || argTypes[0].getTypeTag() == ATypeTag.MULTISET ? ((AbstractCollectionType)argTypes[0]).getItemType() : BuiltinType.ANY;
            IAType rightType = argTypes[1].getTypeTag() == ATypeTag.ARRAY || argTypes[1].getTypeTag() == ATypeTag.MULTISET ? ((AbstractCollectionType)argTypes[1]).getItemType() : BuiltinType.ANY;
            this.comparator = BinaryComparatorFactoryProvider.INSTANCE.getBinaryComparatorFactory((Object)leftType, (Object)rightType, true).createBinaryComparator();
        }

        public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
            this.arg1Eval.evaluate(tuple, this.arg1Pointable);
            this.arg2Eval.evaluate(tuple, this.arg2Pointable);
            if (PointableHelper.checkAndSetMissingOrNull(result, this.arg1Pointable, this.arg2Pointable)) {
                return;
            }
            byte[] arg1Bytes = this.arg1Pointable.getByteArray();
            int arg1StartOffset = this.arg1Pointable.getStartOffset();
            ATypeTag arg1TypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(arg1Bytes[arg1StartOffset]);
            byte[] arg2Bytes = this.arg2Pointable.getByteArray();
            int arg2StartOffset = this.arg2Pointable.getStartOffset();
            ATypeTag arg2TypeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(arg2Bytes[arg2StartOffset]);
            if (!arg1TypeTag.isListType()) {
                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)arg1Bytes[arg1StartOffset], (int)0, (ATypeTag)ATypeTag.ARRAY);
                PointableHelper.setNull(result);
                return;
            }
            if (!arg2TypeTag.isListType()) {
                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.srcLoc, (FunctionIdentifier)this.funID, (byte)arg2Bytes[arg2StartOffset], (int)1, (ATypeTag)ATypeTag.ARRAY);
                PointableHelper.setNull(result);
                return;
            }
            this.arg1ListAccessor.reset(arg1Bytes, arg1StartOffset);
            this.arg2ListAccessor.reset(arg2Bytes, arg2StartOffset);
            if (this.arg1ListAccessor.size() == 0 || this.arg2ListAccessor.size() == 0) {
                result.set((IValueReference)this.arg1Pointable);
                return;
            }
            IAsterixListBuilder resultListBuilder = this.arg1ListAccessor.getListType() == ATypeTag.ARRAY ? this.orderedListBuilder : this.unorderedListBuilder;
            AbstractCollectionType collectionType = !ArrayExceptDescriptor.this.argTypes[0].getTypeTag().isListType() ? (AbstractCollectionType)DefaultOpenFieldType.getDefaultOpenFieldType((ATypeTag)this.arg1ListAccessor.getListType()) : (AbstractCollectionType)ArrayExceptDescriptor.this.argTypes[0];
            resultListBuilder.reset(collectionType);
            try {
                for (int i = 0; i < this.arg1ListAccessor.size(); ++i) {
                    boolean isItemFound = false;
                    this.arg1Storage.reset();
                    this.arg1ListAccessor.getOrWriteItem(i, this.arg1ListItem, this.arg1Storage);
                    for (int j = 0; j < this.arg2ListAccessor.size(); ++j) {
                        this.arg2Storage.reset();
                        this.arg2ListAccessor.getOrWriteItem(j, this.arg2ListItem, this.arg2Storage);
                        if (this.comparator.compare(this.arg1ListItem.getByteArray(), this.arg1ListItem.getStartOffset(), this.arg1ListItem.getLength(), this.arg2ListItem.getByteArray(), this.arg2ListItem.getStartOffset(), this.arg2ListItem.getLength()) != 0) continue;
                        isItemFound = true;
                        break;
                    }
                    if (isItemFound) continue;
                    resultListBuilder.addItem((IValueReference)this.arg1ListItem);
                }
            }
            catch (IOException ex) {
                throw HyracksDataException.create((Throwable)ex);
            }
            this.storage.reset();
            resultListBuilder.write(this.storageOutput, true);
            result.set((IValueReference)this.storage);
        }
    }
}

