/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.utils;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.cluster.INodeManager;

public class RuntimeUtils {
    private RuntimeUtils() {
    }

    public static Set<String> getNodeControllersOnIP(ICcApplicationContext appCtx, InetAddress ipAddress) throws HyracksDataException {
        Map<InetAddress, Set<String>> nodeControllerInfo = RuntimeUtils.getNodeControllerMap(appCtx);
        return nodeControllerInfo.get(ipAddress);
    }

    public static List<String> getAllNodeControllers(ICcApplicationContext appCtx) throws HyracksDataException {
        Collection<Set<String>> nodeControllersCollection = RuntimeUtils.getNodeControllerMap(appCtx).values();
        ArrayList<String> nodeControllers = new ArrayList<String>();
        for (Set<String> ncCollection : nodeControllersCollection) {
            nodeControllers.addAll(ncCollection);
        }
        return nodeControllers;
    }

    public static Map<InetAddress, Set<String>> getNodeControllerMap(ICcApplicationContext appCtx) throws HyracksDataException {
        HashMap<InetAddress, Set<String>> map = new HashMap<InetAddress, Set<String>>();
        appCtx.getServiceContext().getCCContext().getIPAddressNodeMap(map);
        return map;
    }

    public static Map<InetAddress, Set<String>> getForcedNodeControllerMap(ICcApplicationContext appCtx) {
        ClusterControllerService ccs = (ClusterControllerService)appCtx.getServiceContext().getControllerService();
        INodeManager nodeManager = ccs.getNodeManager();
        return nodeManager.getIpAddressNodeNameMap();
    }

    public static JobSpecification createJobSpecification(ICcApplicationContext appCtx) {
        CompilerProperties compilerProperties = appCtx.getCompilerProperties();
        int frameSize = compilerProperties.getFrameSize();
        return new JobSpecification(frameSize);
    }
}

