/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.comparators;

import org.apache.asterix.dataflow.data.common.ILogicalBinaryComparator;
import org.apache.asterix.dataflow.data.common.TaggedValueReference;
import org.apache.asterix.dataflow.data.nontagged.comparators.ACirclePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ADurationPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AGeometryPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AIntervalAscPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ALinePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APoint3DPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APointPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.APolygonPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ARectanglePartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.AUUIDPartialBinaryComparatorFactory;
import org.apache.asterix.dataflow.data.nontagged.comparators.ComparatorUtil;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADateTimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ADayTimeDurationSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.ATimeSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AYearMonthDurationSerializerDeserializer;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.BooleanPointable;
import org.apache.hyracks.data.std.primitive.ByteArrayPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;

public final class LogicalScalarBinaryComparator
implements ILogicalBinaryComparator {
    private final boolean isEquality;
    private static final LogicalScalarBinaryComparator INSTANCE_EQ = new LogicalScalarBinaryComparator(true);
    private static final LogicalScalarBinaryComparator INSTANCE_INEQ = new LogicalScalarBinaryComparator(false);

    private LogicalScalarBinaryComparator(boolean isEquality) {
        this.isEquality = isEquality;
    }

    static LogicalScalarBinaryComparator of(boolean isEquality) {
        return isEquality ? INSTANCE_EQ : INSTANCE_INEQ;
    }

    @Override
    public ILogicalBinaryComparator.Result compare(TaggedValueReference left, TaggedValueReference right) throws HyracksDataException {
        int result;
        ATypeTag rightTag;
        ATypeTag leftTag = left.getTag();
        ILogicalBinaryComparator.Result comparisonResult = ComparatorUtil.returnMissingOrNullOrMismatch(leftTag, rightTag = right.getTag());
        if (comparisonResult != null) {
            return comparisonResult;
        }
        if (LogicalScalarBinaryComparator.comparisonUndefined(leftTag, rightTag, this.isEquality)) {
            return ILogicalBinaryComparator.Result.INCOMPARABLE;
        }
        byte[] leftBytes = left.getByteArray();
        byte[] rightBytes = right.getByteArray();
        int leftStart = left.getStartOffset();
        int rightStart = right.getStartOffset();
        if (ATypeHierarchy.getTypeDomain(leftTag) == ATypeHierarchy.Domain.NUMERIC) {
            return ILogicalBinaryComparator.asResult(ComparatorUtil.compareNumbers(leftTag, leftBytes, leftStart, rightTag, rightBytes, rightStart));
        }
        if (leftTag != rightTag) {
            throw new IllegalStateException("Two different non-numeric tags but they are compatible");
        }
        int leftLen = left.getLength();
        int rightLen = right.getLength();
        switch (leftTag) {
            case BOOLEAN: {
                result = BooleanPointable.compare((byte[])leftBytes, (int)leftStart, (int)leftLen, (byte[])rightBytes, (int)rightStart, (int)rightLen);
                break;
            }
            case STRING: {
                result = UTF8StringPointable.compare((byte[])leftBytes, (int)leftStart, (int)leftLen, (byte[])rightBytes, (int)rightStart, (int)rightLen);
                break;
            }
            case YEARMONTHDURATION: {
                result = Integer.compare(AYearMonthDurationSerializerDeserializer.getYearMonth(leftBytes, leftStart), AYearMonthDurationSerializerDeserializer.getYearMonth(rightBytes, rightStart));
                break;
            }
            case TIME: {
                result = Integer.compare(ATimeSerializerDeserializer.getChronon(leftBytes, leftStart), ATimeSerializerDeserializer.getChronon(rightBytes, rightStart));
                break;
            }
            case DATE: {
                result = Integer.compare(ADateSerializerDeserializer.getChronon(leftBytes, leftStart), ADateSerializerDeserializer.getChronon(rightBytes, rightStart));
                break;
            }
            case DAYTIMEDURATION: {
                result = Long.compare(ADayTimeDurationSerializerDeserializer.getDayTime(leftBytes, leftStart), ADayTimeDurationSerializerDeserializer.getDayTime(rightBytes, rightStart));
                break;
            }
            case DATETIME: {
                result = Long.compare(ADateTimeSerializerDeserializer.getChronon(leftBytes, leftStart), ADateTimeSerializerDeserializer.getChronon(rightBytes, rightStart));
                break;
            }
            case CIRCLE: {
                result = ACirclePartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case LINE: {
                result = ALinePartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case POINT: {
                result = APointPartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case POINT3D: {
                result = APoint3DPartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case POLYGON: {
                result = APolygonPartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case GEOMETRY: {
                result = AGeometryPartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case DURATION: {
                result = ADurationPartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case INTERVAL: {
                result = AIntervalAscPartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case RECTANGLE: {
                result = ARectanglePartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            case BINARY: {
                result = ByteArrayPointable.compare((byte[])leftBytes, (int)leftStart, (int)leftLen, (byte[])rightBytes, (int)rightStart, (int)rightLen);
                break;
            }
            case UUID: {
                result = AUUIDPartialBinaryComparatorFactory.compare(leftBytes, leftStart, leftLen, rightBytes, rightStart, rightLen);
                break;
            }
            default: {
                return ILogicalBinaryComparator.Result.NULL;
            }
        }
        return ILogicalBinaryComparator.asResult(result);
    }

    @Override
    public ILogicalBinaryComparator.Result compare(TaggedValueReference left, IAObject rightConstant) {
        ATypeTag rightTag;
        ATypeTag leftTag = left.getTag();
        ILogicalBinaryComparator.Result comparisonResult = ComparatorUtil.returnMissingOrNullOrMismatch(leftTag, rightTag = rightConstant.getType().getTypeTag());
        if (comparisonResult != null) {
            return comparisonResult;
        }
        if (LogicalScalarBinaryComparator.comparisonUndefined(leftTag, rightTag, this.isEquality)) {
            return ILogicalBinaryComparator.Result.NULL;
        }
        if (ATypeHierarchy.getTypeDomain(leftTag) == ATypeHierarchy.Domain.NUMERIC) {
            return ComparatorUtil.compareNumWithConstant(left, rightConstant);
        }
        return ILogicalBinaryComparator.Result.NULL;
    }

    @Override
    public ILogicalBinaryComparator.Result compare(IAObject leftConstant, TaggedValueReference right) {
        ILogicalBinaryComparator.Result result = this.compare(right, leftConstant);
        if (result == ILogicalBinaryComparator.Result.LT) {
            return ILogicalBinaryComparator.Result.GT;
        }
        if (result == ILogicalBinaryComparator.Result.GT) {
            return ILogicalBinaryComparator.Result.LT;
        }
        return result;
    }

    @Override
    public ILogicalBinaryComparator.Result compare(IAObject leftConstant, IAObject rightConstant) {
        ATypeTag rightTag;
        ATypeTag leftTag = leftConstant.getType().getTypeTag();
        ILogicalBinaryComparator.Result comparisonResult = ComparatorUtil.returnMissingOrNullOrMismatch(leftTag, rightTag = rightConstant.getType().getTypeTag());
        if (comparisonResult != null) {
            return comparisonResult;
        }
        if (LogicalScalarBinaryComparator.comparisonUndefined(leftTag, rightTag, this.isEquality)) {
            return ILogicalBinaryComparator.Result.NULL;
        }
        if (ATypeHierarchy.getTypeDomain(leftTag) == ATypeHierarchy.Domain.NUMERIC) {
            return ComparatorUtil.compareConstants(leftConstant, rightConstant);
        }
        return ILogicalBinaryComparator.Result.NULL;
    }

    private static boolean comparisonUndefined(ATypeTag leftTag, ATypeTag rightTag, boolean isEquality) {
        return !isEquality && (ILogicalBinaryComparator.inequalityUndefined(leftTag) || ILogicalBinaryComparator.inequalityUndefined(rightTag));
    }
}

