/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.algebra.operators.physical;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.optimizer.rules.util.IntervalPartitions;
import org.apache.asterix.runtime.operators.joins.interval.IntervalMergeJoinOperatorDescriptor;
import org.apache.asterix.runtime.operators.joins.interval.utils.IIntervalJoinUtilFactory;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.IHyracksJobBuilder;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.base.PhysicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.operators.physical.AbstractJoinPOperator;
import org.apache.hyracks.algebricks.core.algebra.properties.INodeDomain;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.IPartitioningRequirementsCoordinator;
import org.apache.hyracks.algebricks.core.algebra.properties.IPhysicalPropertiesVector;
import org.apache.hyracks.algebricks.core.algebra.properties.LocalOrderProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderColumn;
import org.apache.hyracks.algebricks.core.algebra.properties.OrderedPartitionedProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PartialBroadcastOrderedFollowingProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PartialBroadcastOrderedIntersectProperty;
import org.apache.hyracks.algebricks.core.algebra.properties.PhysicalRequirements;
import org.apache.hyracks.algebricks.core.algebra.properties.StructuralPropertiesVector;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenContext;
import org.apache.hyracks.algebricks.core.jobgen.impl.JobGenHelper;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.api.job.JobSpecification;
import org.apache.hyracks.dataflow.common.data.partition.range.RangeMap;

public class IntervalMergeJoinPOperator
extends AbstractJoinPOperator {
    private final List<LogicalVariable> keysLeftBranch;
    private final List<LogicalVariable> keysRightBranch;
    protected final IIntervalJoinUtilFactory mjcf;
    protected final IntervalPartitions intervalPartitions;
    private final int memSizeInFrames;

    public IntervalMergeJoinPOperator(AbstractBinaryJoinOperator.JoinKind kind, AbstractJoinPOperator.JoinPartitioningType partitioningType, List<LogicalVariable> sideLeftOfEqualities, List<LogicalVariable> sideRightOfEqualities, int memSizeInFrames, IIntervalJoinUtilFactory mjcf, IntervalPartitions intervalPartitions) {
        super(kind, partitioningType);
        this.keysLeftBranch = sideLeftOfEqualities;
        this.keysRightBranch = sideRightOfEqualities;
        this.mjcf = mjcf;
        this.intervalPartitions = intervalPartitions;
        this.memSizeInFrames = memSizeInFrames;
    }

    public IIntervalJoinUtilFactory getIntervalMergeJoinCheckerFactory() {
        return this.mjcf;
    }

    public PhysicalOperatorTag getOperatorTag() {
        return PhysicalOperatorTag.INTERVAL_MERGE_JOIN;
    }

    public String toString() {
        return "INTERVAL_MERGE_JOIN " + this.keysLeftBranch + " " + this.keysRightBranch;
    }

    public boolean isMicroOperator() {
        return false;
    }

    public void computeDeliveredProperties(ILogicalOperator iop, IOptimizationContext context) {
        List<OrderColumn> order = this.intervalPartitions.getLeftStartColumn();
        OrderedPartitionedProperty pp = new OrderedPartitionedProperty(order, null, this.intervalPartitions.getRangeMap());
        ArrayList<LocalOrderProperty> propsLocal = new ArrayList<LocalOrderProperty>();
        propsLocal.add(new LocalOrderProperty(this.intervalPartitions.getLeftStartColumn()));
        this.deliveredProperties = new StructuralPropertiesVector((IPartitioningProperty)pp, propsLocal);
    }

    public PhysicalRequirements getRequiredPropertiesForChildren(ILogicalOperator iop, IPhysicalPropertiesVector reqdByParent, IOptimizationContext context) {
        StructuralPropertiesVector[] pv = new StructuralPropertiesVector[2];
        AbstractLogicalOperator op = (AbstractLogicalOperator)iop;
        OrderedPartitionedProperty ppLeft = null;
        ArrayList<LocalOrderProperty> ispLeft = new ArrayList<LocalOrderProperty>();
        ArrayList<OrderColumn> leftLocalOrderColumn = new ArrayList<OrderColumn>();
        for (LogicalVariable v : this.keysLeftBranch) {
            leftLocalOrderColumn.add(new OrderColumn(v, this.intervalPartitions.getLeftIntervalColumn().get(0).getOrder()));
        }
        ispLeft.add(new LocalOrderProperty(leftLocalOrderColumn));
        OrderedPartitionedProperty ppRight = null;
        ArrayList<LocalOrderProperty> ispRight = new ArrayList<LocalOrderProperty>();
        ArrayList<OrderColumn> rightLocalOrderColumn = new ArrayList<OrderColumn>();
        for (LogicalVariable v : this.keysRightBranch) {
            rightLocalOrderColumn.add(new OrderColumn(v, this.intervalPartitions.getRightIntervalColumn().get(0).getOrder()));
        }
        ispRight.add(new LocalOrderProperty(rightLocalOrderColumn));
        if (op.getExecutionMode() == AbstractLogicalOperator.ExecutionMode.PARTITIONED) {
            INodeDomain targetNodeDomain = context.getComputationNodeDomain();
            RangeMap rangeMapHint = this.intervalPartitions.getRangeMap();
            switch (this.intervalPartitions.getLeftPartitioningType()) {
                case ORDERED_PARTITIONED: {
                    ppLeft = new OrderedPartitionedProperty(this.intervalPartitions.getLeftStartColumn(), targetNodeDomain, rangeMapHint);
                    break;
                }
                case PARTIAL_BROADCAST_ORDERED_FOLLOWING: {
                    ppLeft = new PartialBroadcastOrderedFollowingProperty(this.intervalPartitions.getLeftStartColumn(), targetNodeDomain, rangeMapHint);
                    break;
                }
                case PARTIAL_BROADCAST_ORDERED_INTERSECT: {
                    ppLeft = new PartialBroadcastOrderedIntersectProperty(this.intervalPartitions.getLeftIntervalColumn(), targetNodeDomain, rangeMapHint);
                }
            }
            switch (this.intervalPartitions.getRightPartitioningType()) {
                case ORDERED_PARTITIONED: {
                    ppRight = new OrderedPartitionedProperty(this.intervalPartitions.getRightStartColumn(), targetNodeDomain, rangeMapHint);
                    break;
                }
                case PARTIAL_BROADCAST_ORDERED_FOLLOWING: {
                    ppRight = new PartialBroadcastOrderedFollowingProperty(this.intervalPartitions.getRightStartColumn(), targetNodeDomain, rangeMapHint);
                    break;
                }
                case PARTIAL_BROADCAST_ORDERED_INTERSECT: {
                    ppRight = new PartialBroadcastOrderedIntersectProperty(this.intervalPartitions.getRightIntervalColumn(), targetNodeDomain, rangeMapHint);
                }
            }
        }
        pv[0] = new StructuralPropertiesVector(ppLeft, ispLeft);
        pv[1] = new StructuralPropertiesVector(ppRight, ispRight);
        IPartitioningRequirementsCoordinator prc = IPartitioningRequirementsCoordinator.NO_COORDINATION;
        return new PhysicalRequirements((IPhysicalPropertiesVector[])pv, prc);
    }

    public void contributeRuntimeOperator(IHyracksJobBuilder builder, JobGenContext context, ILogicalOperator op, IOperatorSchema opSchema, IOperatorSchema[] inputSchemas, IOperatorSchema outerPlanSchema) throws AlgebricksException {
        int[] keysBuild = JobGenHelper.variablesToFieldIndexes(this.keysLeftBranch, (IOperatorSchema)inputSchemas[0]);
        int[] keysProbe = JobGenHelper.variablesToFieldIndexes(this.keysRightBranch, (IOperatorSchema)inputSchemas[1]);
        JobSpecification spec = builder.getJobSpec();
        RecordDescriptor recordDescriptor = JobGenHelper.mkRecordDescriptor((IVariableTypeEnvironment)context.getTypeEnvironment(op), (IOperatorSchema)opSchema, (JobGenContext)context);
        IOperatorDescriptor opDesc = this.getIntervalOperatorDescriptor(keysBuild, keysProbe, (IOperatorDescriptorRegistry)spec, recordDescriptor, this.mjcf);
        this.contributeOpDesc(builder, (AbstractLogicalOperator)op, opDesc);
        ILogicalOperator src1 = (ILogicalOperator)((Mutable)op.getInputs().get(0)).getValue();
        builder.contributeGraphEdge(src1, 0, op, 0);
        ILogicalOperator src2 = (ILogicalOperator)((Mutable)op.getInputs().get(1)).getValue();
        builder.contributeGraphEdge(src2, 0, op, 1);
    }

    IOperatorDescriptor getIntervalOperatorDescriptor(int[] keysBuild, int[] keysProbe, IOperatorDescriptorRegistry spec, RecordDescriptor recordDescriptor, IIntervalJoinUtilFactory mjcf) {
        return new IntervalMergeJoinOperatorDescriptor(spec, this.memSizeInFrames, keysBuild, keysProbe, recordDescriptor, mjcf);
    }
}

