/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.dataflow;

import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.active.ActiveRuntimeId;
import org.apache.asterix.common.memory.ConcurrentFramePool;
import org.apache.asterix.common.memory.FrameAction;
import org.apache.asterix.external.feed.dataflow.FeedExceptionHandler;
import org.apache.asterix.external.feed.dataflow.FrameSpiller;
import org.apache.asterix.external.feed.management.FeedConnectionId;
import org.apache.asterix.external.feed.policy.FeedPolicyAccessor;
import org.apache.asterix.external.util.FeedUtils;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryInputUnaryOutputOperatorNodePushable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FeedRuntimeInputHandler
extends AbstractUnaryInputUnaryOutputOperatorNodePushable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final double MAX_SPILL_USED_BEFORE_RESUME = 0.8;
    private static final boolean DEBUG = false;
    private static final ByteBuffer POISON_PILL = ByteBuffer.allocate(0);
    private static final ByteBuffer SPILLED = ByteBuffer.allocate(0);
    private static final ByteBuffer FAIL = ByteBuffer.allocate(0);
    private final FeedExceptionHandler exceptionHandler;
    private final FrameSpiller spiller;
    private final FeedPolicyAccessor fpa;
    private final FrameAction frameAction;
    private final int initialFrameSize;
    private final FrameTransporter consumer;
    private final Thread consumerThread;
    private final BlockingQueue<ByteBuffer> inbox;
    private final ConcurrentFramePool framePool;
    private FeedUtils.Mode mode = FeedUtils.Mode.PROCESS;
    private int total = 0;
    private int numDiscarded = 0;
    private int numSpilled = 0;
    private int numProcessedInMemory = 0;
    private int numStalled = 0;

    public FeedRuntimeInputHandler(IHyracksTaskContext ctx, FeedConnectionId connectionId, ActiveRuntimeId runtimeId, IFrameWriter writer, FeedPolicyAccessor fpa, FrameTupleAccessor fta, ConcurrentFramePool framePool) throws HyracksDataException {
        this.writer = writer;
        this.spiller = fpa.spillToDiskOnCongestion() ? new FrameSpiller(ctx, connectionId.getFeedId() + "_" + connectionId.getDatasetName() + "_" + runtimeId.getPartition(), fpa.getMaxSpillOnDisk()) : null;
        this.exceptionHandler = new FeedExceptionHandler(ctx, fta);
        this.fpa = fpa;
        this.framePool = framePool;
        this.inbox = new LinkedBlockingQueue<ByteBuffer>();
        this.consumer = new FrameTransporter();
        this.consumerThread = new Thread((Runnable)this.consumer, "FeedRuntimeInputHandler-FrameTransporter");
        this.initialFrameSize = ctx.getInitialFrameSize();
        this.frameAction = new FrameAction();
    }

    public void open() throws HyracksDataException {
        this.writer.open();
        this.consumerThread.start();
    }

    public void fail() throws HyracksDataException {
        ByteBuffer buffer = (ByteBuffer)this.inbox.poll();
        while (buffer != null) {
            if (buffer != SPILLED) {
                this.framePool.release(buffer);
            }
            buffer = (ByteBuffer)this.inbox.poll();
        }
        try {
            this.inbox.put(FAIL);
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARN, "interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void close() throws HyracksDataException {
        try {
            this.inbox.put(POISON_PILL);
            this.consumerThread.join();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.WARN, "interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            if (this.spiller != null) {
                this.spiller.close();
            }
        }
        catch (Throwable th) {
            LOGGER.log(Level.WARN, "exception closing spiller", th);
        }
        finally {
            this.writer.close();
        }
    }

    public void nextFrame(ByteBuffer frame) throws HyracksDataException {
        try {
            ++this.total;
            if (this.consumer.cause() != null) {
                throw this.consumer.cause();
            }
            switch (this.mode) {
                case PROCESS: {
                    this.process(frame);
                    break;
                }
                case SPILL: {
                    this.spill(frame);
                    break;
                }
                case DISCARD: {
                    this.discard(frame);
                    break;
                }
                default: {
                    if (LOGGER.isWarnEnabled()) {
                        LOGGER.warn("Ignoring incoming tuples in " + this.mode + " mode");
                    }
                    break;
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw HyracksDataException.create((Throwable)e);
        }
        catch (Throwable th) {
            throw HyracksDataException.create((Throwable)th);
        }
    }

    public int framesOnDisk() {
        return this.spiller.remaining();
    }

    private ByteBuffer getFreeBuffer(int frameSize) throws HyracksDataException {
        int numFrames = frameSize / this.initialFrameSize;
        if (numFrames == 1) {
            return this.framePool.get();
        }
        return this.framePool.get(frameSize);
    }

    private void discard(ByteBuffer frame) throws HyracksDataException, InterruptedException {
        if (this.fpa.spillToDiskOnCongestion()) {
            if (this.spiller.spill(frame)) {
                ++this.numSpilled;
                this.mode = FeedUtils.Mode.SPILL;
                return;
            }
        } else {
            ByteBuffer next = this.getFreeBuffer(frame.capacity());
            if (next != null) {
                ++this.numProcessedInMemory;
                next.put(frame);
                this.inbox.put(next);
                this.mode = FeedUtils.Mode.PROCESS;
                return;
            }
        }
        if (((double)this.numDiscarded + 1.0) / (double)this.total > (double)this.fpa.getMaxFractionDiscard()) {
            this.stall(frame);
        } else {
            ++this.numDiscarded;
        }
    }

    private void exitProcessState(ByteBuffer frame) throws HyracksDataException, InterruptedException {
        if (this.fpa.spillToDiskOnCongestion()) {
            this.mode = FeedUtils.Mode.SPILL;
            this.spiller.open();
            this.spill(frame);
        } else {
            this.discardOrStall(frame);
        }
    }

    private void discardOrStall(ByteBuffer frame) throws HyracksDataException, InterruptedException {
        if (this.fpa.discardOnCongestion()) {
            this.mode = FeedUtils.Mode.DISCARD;
            this.discard(frame);
        } else {
            this.stall(frame);
        }
    }

    private void stall(ByteBuffer frame) throws HyracksDataException, InterruptedException {
        ++this.numStalled;
        if (this.fpa.spillToDiskOnCongestion()) {
            this.waitforSpillSpace();
            this.spiller.spill(frame);
            ++this.numSpilled;
            this.inbox.put(SPILLED);
            return;
        }
        this.frameAction.setFrame(frame);
        this.framePool.subscribe(this.frameAction);
        ByteBuffer temp = this.frameAction.retrieve();
        this.inbox.put(temp);
        ++this.numProcessedInMemory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitforSpillSpace() throws InterruptedException {
        FrameSpiller frameSpiller = this.spiller;
        synchronized (frameSpiller) {
            while (this.spiller.usedBudget() > 0.8) {
                this.spiller.wait();
            }
        }
    }

    private void process(ByteBuffer frame) throws HyracksDataException, InterruptedException {
        ByteBuffer next;
        ByteBuffer byteBuffer = next = frame.capacity() <= this.framePool.getMaxFrameSize() ? this.getFreeBuffer(frame.capacity()) : null;
        if (next != null) {
            ++this.numProcessedInMemory;
            next.put(frame);
            this.inbox.put(next);
        } else {
            this.exitProcessState(frame);
        }
    }

    private void spill(ByteBuffer frame) throws HyracksDataException, InterruptedException {
        if (this.spiller.switchToMemory()) {
            ByteBuffer next = null;
            if (frame.capacity() <= this.framePool.getMaxFrameSize()) {
                next = this.getFreeBuffer(frame.capacity());
            }
            if (next != null) {
                this.spiller.close();
                ++this.numProcessedInMemory;
                next.put(frame);
                this.inbox.put(next);
                this.mode = FeedUtils.Mode.PROCESS;
            } else {
                this.spiller.spill(frame);
                ++this.numSpilled;
                this.inbox.put(SPILLED);
            }
        } else if (this.spiller.spill(frame)) {
            this.inbox.put(SPILLED);
            ++this.numSpilled;
        } else if (this.fpa.discardOnCongestion()) {
            this.mode = FeedUtils.Mode.DISCARD;
            this.discard(frame);
        } else {
            this.stall(frame);
        }
    }

    public int getNumDiscarded() {
        return this.numDiscarded;
    }

    public int getNumSpilled() {
        return this.numSpilled;
    }

    public int getNumProcessedInMemory() {
        return this.numProcessedInMemory;
    }

    public int getNumStalled() {
        return this.numStalled;
    }

    public int getTotal() {
        return this.total;
    }

    public BlockingQueue<ByteBuffer> getInternalBuffer() {
        return this.inbox;
    }

    private class FrameTransporter
    implements Runnable {
        private volatile Throwable cause;
        private int consumed = 0;

        private FrameTransporter() {
        }

        public Throwable cause() {
            return this.cause;
        }

        private Throwable consume(ByteBuffer frame) {
            while (frame != null) {
                try {
                    FeedRuntimeInputHandler.this.writer.nextFrame(frame);
                    ++this.consumed;
                    frame = null;
                }
                catch (HyracksDataException e) {
                    if ((frame = FeedRuntimeInputHandler.this.exceptionHandler.handle(e, frame)) != null) continue;
                    this.cause = e;
                    return e;
                }
                catch (Throwable th) {
                    this.cause = th;
                    return th;
                }
            }
            return null;
        }

        private boolean clearLocalFrames() throws HyracksDataException {
            ByteBuffer frame = FeedRuntimeInputHandler.this.spiller.next();
            while (frame != null) {
                if (this.consume(frame) != null) {
                    return false;
                }
                frame = FeedRuntimeInputHandler.this.spiller.next();
            }
            return true;
        }

        @Override
        public void run() {
            try {
                boolean running = true;
                while (running) {
                    ByteBuffer frame = (ByteBuffer)FeedRuntimeInputHandler.this.inbox.poll();
                    if (frame == null) {
                        FeedRuntimeInputHandler.this.writer.flush();
                        frame = FeedRuntimeInputHandler.this.inbox.take();
                    }
                    if (frame == SPILLED) {
                        running = this.clearLocalFrames();
                        continue;
                    }
                    if (frame == POISON_PILL) {
                        running = false;
                        if (FeedRuntimeInputHandler.this.spiller == null) continue;
                        this.clearLocalFrames();
                        continue;
                    }
                    if (frame == FAIL) {
                        running = false;
                        FeedRuntimeInputHandler.this.writer.fail();
                        continue;
                    }
                    try {
                        running = this.consume(frame) == null;
                    }
                    finally {
                        FeedRuntimeInputHandler.this.framePool.release(frame);
                    }
                }
            }
            catch (Throwable th) {
                this.cause = th;
            }
        }

        public String toString() {
            return "consumed: " + this.consumed;
        }
    }
}

