/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.context;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.asterix.common.api.IDatasetInfoProvider;
import org.apache.asterix.common.api.IDatasetLifecycleManager;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.context.DatasetInfo;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;

public class DatasetInfoProvider
implements IDatasetInfoProvider {
    private static final long serialVersionUID = 1L;
    private final int datasetId;

    public DatasetInfoProvider(int datasetId) {
        this.datasetId = datasetId;
    }

    @Override
    public DatasetInfo getDatasetInfo(INCServiceContext serviceCtx) {
        IDatasetLifecycleManager dslcManager = ((INcApplicationContext)serviceCtx.getApplicationContext()).getDatasetLifecycleManager();
        return dslcManager.getDatasetInfo(this.datasetId);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put("datasetId", this.datasetId);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return new DatasetInfoProvider(json.get("datasetId").asInt());
    }
}

