/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.util;

import java.util.List;
import org.apache.asterix.common.metadata.DataverseName;

public class SqlppStatementUtil {
    public static final String IF_EXISTS = " IF EXISTS ";
    public static final String IF_NOT_EXISTS = " IF NOT EXISTS ";
    public static final String CREATE_DATAVERSE = "CREATE DATAVERSE ";
    public static final String CREATE_DATASET = "CREATE DATASET ";
    public static final String DROP_DATASET = "DROP DATASET ";
    public static final String CREATE_INDEX = "CREATE INDEX ";
    public static final String CREATE_PRIMARY_INDEX = "CREATE PRIMARY INDEX ";
    public static final String DROP_INDEX = "DROP INDEX ";
    public static final String ON = " ON ";
    public static final String WHERE = " WHERE ";
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    public static final String NOT = " NOT ";
    public static final char SEMI_COLON = ';';
    public static final char DOT = '.';
    public static final char COLON = ':';
    public static final char COMMA = ',';
    public static final char L_PARENTHESIS = '(';
    public static final char R_PARENTHESIS = ')';
    public static final char L_BRACE = '{';
    public static final char R_BRACE = '}';
    public static final char QUOTE = '\"';
    public static final char BACK_TICK = '`';

    private SqlppStatementUtil() {
    }

    public static StringBuilder getCreateDataverseStatement(StringBuilder stringBuilder, DataverseName dataverseName, boolean ifNotExists, int version) {
        stringBuilder.append(CREATE_DATAVERSE);
        SqlppStatementUtil.encloseDataverseName(stringBuilder, dataverseName);
        return SqlppStatementUtil.ifNotExists(stringBuilder, ifNotExists).append(';');
    }

    public static StringBuilder getDropDatasetStatement(StringBuilder stringBuilder, DataverseName dataverseName, String datasetName, boolean ifExists, int version) {
        stringBuilder.append(DROP_DATASET);
        SqlppStatementUtil.enclose(stringBuilder, dataverseName, datasetName);
        return SqlppStatementUtil.ifExists(stringBuilder, ifExists).append(';');
    }

    public static StringBuilder getCreateIndexStatement(StringBuilder stringBuilder, DataverseName dataverseName, String datasetName, String indexName, String fields, int version) {
        stringBuilder.append(CREATE_INDEX);
        SqlppStatementUtil.enclose(stringBuilder, indexName).append(ON);
        return SqlppStatementUtil.enclose(stringBuilder, dataverseName, datasetName).append(fields).append(';');
    }

    public static StringBuilder getCreatePrimaryIndexStatement(StringBuilder stringBuilder, DataverseName dataverseName, String datasetName, String indexName, int version) {
        stringBuilder.append(CREATE_PRIMARY_INDEX);
        SqlppStatementUtil.enclose(stringBuilder, indexName).append(ON);
        return SqlppStatementUtil.enclose(stringBuilder, dataverseName, datasetName).append(';');
    }

    public static StringBuilder getDropIndexStatement(StringBuilder stringBuilder, DataverseName dataverseName, String datasetName, String indexName, boolean ifExists, int version) {
        stringBuilder.append(DROP_INDEX);
        SqlppStatementUtil.enclose(stringBuilder, dataverseName, datasetName, indexName);
        return SqlppStatementUtil.ifExists(stringBuilder, ifExists).append(';');
    }

    private static StringBuilder ifExists(StringBuilder stringBuilder, boolean ifExists) {
        return ifExists ? stringBuilder.append(IF_EXISTS) : stringBuilder;
    }

    private static StringBuilder ifNotExists(StringBuilder stringBuilder, boolean ifNotExists) {
        return ifNotExists ? stringBuilder.append(IF_NOT_EXISTS) : stringBuilder;
    }

    public static StringBuilder enclose(StringBuilder stringBuilder, String identifier) {
        return stringBuilder.append('`').append(identifier).append('`');
    }

    public static StringBuilder encloseDataverseName(StringBuilder stringBuilder, DataverseName dataverseName) {
        List parts = dataverseName.getParts();
        int ln = parts.size();
        for (int i = 0; i < ln; ++i) {
            if (i > 0) {
                stringBuilder.append('.');
            }
            SqlppStatementUtil.enclose(stringBuilder, (String)parts.get(i));
        }
        return stringBuilder;
    }

    public static StringBuilder enclose(StringBuilder stringBuilder, DataverseName dataverseName, String identifier) {
        SqlppStatementUtil.encloseDataverseName(stringBuilder, dataverseName).append('.');
        return SqlppStatementUtil.enclose(stringBuilder, identifier);
    }

    public static StringBuilder enclose(StringBuilder stringBuilder, DataverseName dataverseName, String identifier1, String identifier2) {
        SqlppStatementUtil.enclose(stringBuilder, dataverseName, identifier1).append('.');
        return SqlppStatementUtil.enclose(stringBuilder, identifier2);
    }

    public static String enclose(String identifier) {
        return "`" + identifier + "`";
    }

    public static String enclose(String identifier1, String identifier2) {
        return "`" + identifier1 + "`.`" + identifier2 + "`";
    }

    public static StringBuilder quote(StringBuilder stringBuilder, String text) {
        return stringBuilder.append('\"').append(text).append('\"');
    }

    public static String quote(String text) {
        return "\"" + text + "\"";
    }
}

