/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.invertedindex.search;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.dataflow.common.io.RunFileReader;
import org.apache.hyracks.dataflow.common.io.RunFileWriter;
import org.apache.hyracks.dataflow.std.buffermanager.BufferManagerBackedVSizeFrame;
import org.apache.hyracks.dataflow.std.buffermanager.ISimpleFrameBufferManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import org.apache.hyracks.storage.am.common.tuples.TypeAwareTupleWriter;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListSearchResultFrameTupleAppender;
import org.apache.hyracks.storage.am.lsm.invertedindex.api.IInvertedListTupleReference;
import org.apache.hyracks.storage.am.lsm.invertedindex.ondisk.InvertedListSearchResultFrameTupleAppender;
import org.apache.hyracks.storage.am.lsm.invertedindex.util.InvertedIndexUtils;

public class InvertedIndexSearchResult {
    protected static final int ELEMENT_COUNT_SIZE = 4;
    protected static final int IO_BUFFER_IDX = 0;
    protected static final String FILE_PREFIX = "InvertedIndexSearchResult";
    protected final IHyracksTaskContext ctx;
    protected final IInvertedListSearchResultFrameTupleAppender appender;
    protected final IFrameTupleAccessor accessor;
    protected final IInvertedListTupleReference tuple;
    protected final ISimpleFrameBufferManager bufferManager;
    protected ITypeTraits[] typeTraits;
    protected ITypeTraits[] invListFields;
    protected int currentWriterBufIdx;
    protected int currentReaderBufIdx;
    protected int numResults;
    protected IFrame ioBufferFrame = null;
    protected ByteBuffer ioBuffer = null;
    protected ArrayList<ByteBuffer> buffers;
    protected RunFileWriter searchResultWriter;
    protected RunFileReader searchResultReader;
    protected boolean isInMemoryOpMode;
    protected boolean isInReadMode;
    protected boolean isWriteFinished;
    protected boolean isFileOpened;
    protected ITreeIndexTupleWriter tupleWriter;
    protected byte[] tempBytes;

    public InvertedIndexSearchResult(ITypeTraits[] invListFields, IHyracksTaskContext ctx, ISimpleFrameBufferManager bufferManager) throws HyracksDataException {
        this.invListFields = invListFields;
        this.tupleWriter = new TypeAwareTupleWriter(invListFields);
        this.initTypeTraits(invListFields);
        this.ctx = ctx;
        this.appender = new InvertedListSearchResultFrameTupleAppender(ctx.getInitialFrameSize());
        this.accessor = InvertedIndexUtils.createInvertedListFrameTupleAccessor(ctx.getInitialFrameSize(), this.typeTraits);
        this.tuple = InvertedIndexUtils.createInvertedListTupleReference(this.typeTraits);
        this.bufferManager = bufferManager;
        this.isInReadMode = false;
        this.isWriteFinished = false;
        this.isInMemoryOpMode = false;
        this.isFileOpened = false;
        this.ioBufferFrame = null;
        this.ioBuffer = null;
        this.buffers = null;
        this.currentWriterBufIdx = 0;
        this.currentReaderBufIdx = 0;
        this.numResults = 0;
        this.tempBytes = new byte[ctx.getInitialFrameSize()];
        this.prepareIOBuffer();
    }

    protected void initTypeTraits(ITypeTraits[] invListFields) {
        this.typeTraits = new ITypeTraits[invListFields.length + 1];
        for (int i = 0; i < invListFields.length; ++i) {
            this.typeTraits[i] = invListFields[i];
        }
        this.typeTraits[invListFields.length] = IntegerPointable.TYPE_TRAITS;
    }

    public int getExpectedNumPages(int numExpectedElements) {
        if (InvertedIndexUtils.checkTypeTraitsAllFixed(this.invListFields)) {
            int sizeElement = 0;
            for (int i = 0; i < this.invListFields.length; ++i) {
                sizeElement += this.invListFields[i].getFixedLength();
            }
            int frameSize = this.ctx.getInitialFrameSize();
            frameSize = frameSize - 4 - 4;
            int numPossibleElementPerPage = (int)Math.floor((double)frameSize / (double)(sizeElement + 4));
            return (int)Math.ceil((double)numExpectedElements / (double)numPossibleElementPerPage);
        }
        return -1;
    }

    public void prepareWrite(int numExpectedPages) throws HyracksDataException {
        if (this.isInReadMode || this.isWriteFinished || this.searchResultWriter != null) {
            return;
        }
        this.isInMemoryOpMode = InvertedIndexUtils.checkTypeTraitsAllFixed(this.typeTraits) ? this.tryAllocateBuffers(numExpectedPages) : false;
        if (!this.isInMemoryOpMode) {
            this.createAndOpenFile();
        }
        this.appender.reset(this.ioBuffer);
        this.isWriteFinished = false;
    }

    protected int getNumBytesRequired(ITupleReference invListElement) {
        if (this.invListFields[0].isFixedLength()) {
            return invListElement.getFieldLength(0);
        }
        return this.tupleWriter.bytesRequired(invListElement, 0, 1);
    }

    protected boolean appendInvertedListElement(ITupleReference invListElement) throws HyracksDataException {
        int numBytesRequired = this.getNumBytesRequired(invListElement);
        if (this.invListFields[0].isFixedLength()) {
            if (!this.appender.append(invListElement.getFieldData(0), invListElement.getFieldStart(0), invListElement.getFieldLength(0))) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ADD_ELEMENT_TO_INVERTED_INDEX_SEARCH_RESULT, (Serializable[])new Serializable[0]);
            }
        } else {
            this.tupleWriter.writeTupleFields(invListElement, 0, 1, this.tempBytes, 0);
            if (!this.appender.append(this.tempBytes, 0, numBytesRequired)) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ADD_ELEMENT_TO_INVERTED_INDEX_SEARCH_RESULT, (Serializable[])new Serializable[0]);
            }
        }
        return true;
    }

    public boolean append(ITupleReference invListElement, int count) throws HyracksDataException {
        int numBytesRequired = this.getNumBytesRequired(invListElement);
        if (!this.appender.hasSpace(numBytesRequired + 4)) {
            ByteBuffer currentBuffer;
            ++this.currentWriterBufIdx;
            if (this.isInMemoryOpMode) {
                currentBuffer = this.buffers.get(this.currentWriterBufIdx);
            } else {
                this.searchResultWriter.nextFrame(this.ioBuffer);
                currentBuffer = this.ioBuffer;
            }
            this.appender.reset(currentBuffer);
        }
        this.appendInvertedListElement(invListElement);
        if (!this.appender.append(count)) {
            throw HyracksDataException.create((ErrorCode)ErrorCode.CANNOT_ADD_ELEMENT_TO_INVERTED_INDEX_SEARCH_RESULT, (Serializable[])new Serializable[0]);
        }
        this.appender.incrementTupleCount(1);
        ++this.numResults;
        return true;
    }

    public void finalizeWrite() throws HyracksDataException {
        if (this.isWriteFinished) {
            return;
        }
        if (!this.isInMemoryOpMode && this.searchResultWriter != null) {
            this.searchResultWriter.nextFrame(this.ioBuffer);
            this.searchResultWriter.close();
        }
        this.isWriteFinished = true;
    }

    public void prepareResultRead() throws HyracksDataException {
        if (this.isInReadMode) {
            return;
        }
        if (!this.isInMemoryOpMode && this.searchResultWriter != null) {
            if (!this.isWriteFinished) {
                this.finalizeWrite();
            }
            this.searchResultReader = this.searchResultWriter.createDeleteOnCloseReader();
            this.searchResultReader.open();
            this.searchResultReader.setDeleteAfterClose(true);
        }
        this.currentReaderBufIdx = 0;
        this.isInReadMode = true;
    }

    public ByteBuffer getNextFrame() throws HyracksDataException {
        ByteBuffer returnedBuffer = null;
        if (this.isInMemoryOpMode) {
            returnedBuffer = this.buffers.get(this.currentReaderBufIdx);
            ++this.currentReaderBufIdx;
        } else if (this.searchResultReader != null && this.searchResultReader.nextFrame(this.ioBufferFrame)) {
            returnedBuffer = this.ioBufferFrame.getBuffer();
        }
        return returnedBuffer;
    }

    public void closeResultRead(boolean deallocateIOBufferNeeded) throws HyracksDataException {
        if (this.isInMemoryOpMode) {
            this.deallocateBuffers();
        } else if (this.searchResultReader != null) {
            this.searchResultReader.close();
        }
        if (deallocateIOBufferNeeded) {
            this.deallocateIOBuffer();
        }
    }

    public int getCurrentBufferIndex() {
        return this.currentWriterBufIdx;
    }

    public ITypeTraits[] getTypeTraits() {
        return this.typeTraits;
    }

    public int getNumResults() {
        return this.numResults;
    }

    public void close() throws HyracksDataException {
        if (this.isInMemoryOpMode) {
            this.deallocateBuffers();
        } else if (this.searchResultReader != null) {
            this.searchResultReader.close();
        } else if (this.searchResultWriter != null) {
            this.searchResultWriter.erase();
        }
        this.deallocateIOBuffer();
    }

    public void reset() throws HyracksDataException {
        if (this.searchResultReader != null) {
            this.searchResultReader.close();
        } else if (this.searchResultWriter != null) {
            this.searchResultWriter.erase();
        } else if (this.buffers.size() > 1) {
            this.deallocateBuffers();
        }
        this.clearBuffer(this.ioBuffer);
        this.searchResultWriter = null;
        this.searchResultReader = null;
        this.isInReadMode = false;
        this.isWriteFinished = false;
        this.isInMemoryOpMode = false;
        this.isFileOpened = false;
        this.currentWriterBufIdx = 0;
        this.currentReaderBufIdx = 0;
        this.numResults = 0;
    }

    protected void prepareIOBuffer() throws HyracksDataException {
        if (this.ioBufferFrame != null) {
            this.clearBuffer(this.ioBuffer);
        } else {
            this.ioBufferFrame = new BufferManagerBackedVSizeFrame((IHyracksFrameMgrContext)this.ctx, this.bufferManager);
            this.ioBuffer = this.ioBufferFrame.getBuffer();
            if (this.ioBuffer == null) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.NOT_ENOUGH_BUDGET_FOR_TEXTSEARCH, (Serializable[])new Serializable[]{this.getClass().getSimpleName()});
            }
            this.clearBuffer(this.ioBuffer);
            this.buffers = new ArrayList();
            this.buffers.add(this.ioBuffer);
        }
    }

    protected boolean tryAllocateBuffers(int numExpectedPages) throws HyracksDataException {
        assert (numExpectedPages >= 0);
        boolean allBufferAllocated = true;
        while (this.buffers.size() < numExpectedPages) {
            ByteBuffer tmpBuffer = this.bufferManager.acquireFrame(this.ctx.getInitialFrameSize());
            if (tmpBuffer == null) {
                allBufferAllocated = false;
                this.deallocateBuffers();
                break;
            }
            this.clearBuffer(tmpBuffer);
            this.buffers.add(tmpBuffer);
        }
        return allBufferAllocated;
    }

    protected void createAndOpenFile() throws HyracksDataException {
        if (this.isInMemoryOpMode) {
            return;
        }
        if (this.searchResultWriter == null) {
            FileReference file = this.ctx.getJobletContext().createManagedWorkspaceFile(FILE_PREFIX);
            this.searchResultWriter = new RunFileWriter(file, this.ctx.getIoManager());
            this.searchResultWriter.open();
            this.isFileOpened = true;
        }
    }

    protected void deallocateIOBuffer() throws HyracksDataException {
        if (this.ioBufferFrame != null) {
            this.bufferManager.releaseFrame(this.ioBuffer);
            this.buffers.clear();
            this.ioBufferFrame = null;
            this.ioBuffer = null;
        }
    }

    protected void deallocateBuffers() throws HyracksDataException {
        int toDeleteCount = this.buffers.size() - 1;
        ListIterator<ByteBuffer> iter = this.buffers.listIterator(this.buffers.size());
        for (int deletedCount = 0; iter.hasPrevious() && deletedCount < toDeleteCount; ++deletedCount) {
            ByteBuffer next = iter.previous();
            this.bufferManager.releaseFrame(next);
            iter.remove();
        }
    }

    public IFrameTupleAccessor getAccessor() {
        return this.accessor;
    }

    public IInvertedListSearchResultFrameTupleAppender getAppender() {
        return this.appender;
    }

    public IInvertedListTupleReference getTuple() {
        return this.tuple;
    }

    protected void clearBuffer(ByteBuffer bufferToClear) {
        Arrays.fill(bufferToClear.array(), (byte)0);
        bufferToClear.clear();
    }

    protected void resetAppenderLocation(int bufferIdx) {
        this.accessor.reset(this.buffers.get(bufferIdx));
        this.appender.reset(this.buffers.get(bufferIdx), false, this.accessor.getTupleCount(), this.accessor.getTupleEndOffset(this.accessor.getTupleCount() - 1));
    }
}

