/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.transaction.management.service.locking;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.asterix.common.transactions.ITransactionContext;
import org.apache.asterix.transaction.management.service.locking.ConcurrentLockManager;
import org.apache.asterix.transaction.management.service.locking.TypeUtil;

class ResourceGroup {
    private final ReentrantLock latch = new ReentrantLock();
    private final Condition condition = this.latch.newCondition();
    volatile long firstResourceIndex = -1L;

    ResourceGroup() {
    }

    void getLatch() {
        this.log("latch");
        this.latch.lock();
    }

    boolean tryLatch(long timeout, TimeUnit unit) throws InterruptedException {
        this.log("tryLatch");
        try {
            return this.latch.tryLock(timeout, unit);
        }
        catch (InterruptedException e) {
            ConcurrentLockManager.LOGGER.trace("interrupted while wating on ResourceGroup");
            throw e;
        }
    }

    void releaseLatch() {
        this.log("release");
        this.latch.unlock();
    }

    boolean hasWaiters() {
        return this.latch.hasQueuedThreads();
    }

    void await(ITransactionContext txnContext) throws InterruptedException {
        this.log("wait for");
        try {
            this.condition.await();
        }
        catch (InterruptedException e) {
            ConcurrentLockManager.LOGGER.trace("interrupted while waiting on ResourceGroup");
            throw e;
        }
    }

    void wakeUp() {
        this.log("notify");
        this.condition.signalAll();
    }

    void log(String s) {
        if (ConcurrentLockManager.LOGGER.isEnabled(ConcurrentLockManager.LVL)) {
            ConcurrentLockManager.LOGGER.log(ConcurrentLockManager.LVL, s + " " + this.toString());
        }
    }

    public String toString() {
        return "{ id : " + this.hashCode() + ", first : " + TypeUtil.Global.toString(this.firstResourceIndex) + ", waiters : " + (this.hasWaiters() ? "true" : "false") + " }";
    }
}

