/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMHarness;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndex;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexOperationContext;
import org.apache.hyracks.storage.common.ISearchOperationCallback;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.util.trace.ITracer;

public class ExternalBTreeOpContext
extends AbstractLSMIndexOperationContext {
    private IBTreeLeafFrame insertLeafFrame;
    private IBTreeLeafFrame deleteLeafFrame;
    private final MultiComparator cmp;
    private final MultiComparator bloomFilterCmp;
    private final int targetIndexVersion;
    private LSMBTreeCursorInitialState searchInitialState;

    public ExternalBTreeOpContext(ILSMIndex index, ITreeIndexFrameFactory insertLeafFrameFactory, ITreeIndexFrameFactory deleteLeafFrameFactory, ISearchOperationCallback searchCallback, int numBloomFilterKeyFields, IBinaryComparatorFactory[] cmpFactories, int targetIndexVersion, ILSMHarness lsmHarness, ITracer tracer) {
        super(index, null, null, null, searchCallback, null, tracer);
        this.cmp = cmpFactories != null ? MultiComparator.create((IBinaryComparatorFactory[])cmpFactories) : null;
        this.bloomFilterCmp = MultiComparator.create((IBinaryComparatorFactory[])cmpFactories, (int)0, (int)numBloomFilterKeyFields);
        this.insertLeafFrame = (IBTreeLeafFrame)insertLeafFrameFactory.createFrame();
        this.deleteLeafFrame = (IBTreeLeafFrame)deleteLeafFrameFactory.createFrame();
        if (this.insertLeafFrame != null && this.cmp != null) {
            this.insertLeafFrame.setMultiComparator(this.cmp);
        }
        if (this.deleteLeafFrame != null && this.cmp != null) {
            this.deleteLeafFrame.setMultiComparator(this.cmp);
        }
        this.targetIndexVersion = targetIndexVersion;
        this.searchInitialState = new LSMBTreeCursorInitialState(insertLeafFrameFactory, this.cmp, this.bloomFilterCmp, lsmHarness, null, searchCallback, null);
    }

    public void setCurrentMutableComponentId(int currentMutableComponentId) {
    }

    public int getTargetIndexVersion() {
        return this.targetIndexVersion;
    }

    public LSMBTreeCursorInitialState getSearchInitialState() {
        return this.searchInitialState;
    }

    public void destroy() throws HyracksDataException {
    }
}

