/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.app.message;

import com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.asterix.app.message.GetJobSummariesResponse;
import org.apache.asterix.common.dataflow.ICcApplicationContext;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.messaging.CCMessageBroker;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.control.cc.ClusterControllerService;
import org.apache.hyracks.control.cc.work.GetJobSummariesJSONWork;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GetJobSummariesRequest
implements ICcAddressedMessage {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private final String nodeId;
    private final long reqId;

    public GetJobSummariesRequest(String nodeId, long reqId) {
        this.nodeId = nodeId;
        this.reqId = reqId;
    }

    public void handle(ICcApplicationContext appCtx) throws HyracksDataException, InterruptedException {
        ClusterControllerService ccs = (ClusterControllerService)appCtx.getServiceContext().getControllerService();
        GetJobSummariesJSONWork gjse = new GetJobSummariesJSONWork(ccs.getJobManager());
        try {
            ccs.getWorkQueue().scheduleAndSync((SynchronizableWork)gjse);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure getting jobs", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
        ArrayNode gjseSummaries = gjse.getSummaries();
        int size = gjseSummaries.size();
        String[] summaries = new String[size];
        for (int i = 0; i < size; ++i) {
            summaries[i] = gjseSummaries.get(i).toString();
        }
        GetJobSummariesResponse response = new GetJobSummariesResponse(this.reqId, summaries);
        CCMessageBroker messageBroker = (CCMessageBroker)appCtx.getServiceContext().getMessageBroker();
        try {
            messageBroker.sendApplicationMessageToNC(response, this.nodeId);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Failure sending response to nc", (Throwable)e);
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

