/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.rtree.linearize;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparator;
import org.apache.hyracks.api.dataflow.value.ILinearizeComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.storage.am.rtree.linearize.ZCurveIntComparator;

public class ZCurveIntComparatorFactory
implements ILinearizeComparatorFactory {
    private static final long serialVersionUID = 1L;
    private int dim;

    public static ZCurveIntComparatorFactory get(int dim) {
        return new ZCurveIntComparatorFactory(dim);
    }

    public ZCurveIntComparatorFactory(int dim) {
        this.dim = dim;
    }

    public ILinearizeComparator createBinaryComparator() {
        return new ZCurveIntComparator(this.dim);
    }

    public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
        ObjectNode json = registry.getClassIdentifier(this.getClass(), 1L);
        json.put("dim", this.dim);
        return json;
    }

    public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
        return ZCurveIntComparatorFactory.get(json.get("dim").asInt());
    }
}

