/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.data.std.primitive;

import com.fasterxml.jackson.databind.JsonNode;
import it.unimi.dsi.fastutil.ints.IntCollection;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hyracks.api.dataflow.value.ITypeTraits;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IJsonSerializable;
import org.apache.hyracks.api.io.IPersistedResourceRegistry;
import org.apache.hyracks.data.std.api.AbstractPointable;
import org.apache.hyracks.data.std.api.IComparable;
import org.apache.hyracks.data.std.api.IHashable;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IPointableFactory;
import org.apache.hyracks.data.std.primitive.VarLengthTypeTrait;
import org.apache.hyracks.data.std.util.GrowableArray;
import org.apache.hyracks.data.std.util.UTF8StringBuilder;
import org.apache.hyracks.util.string.UTF8StringUtil;

public final class UTF8StringPointable
extends AbstractPointable
implements IHashable,
IComparable {
    public static final UTF8StringPointableFactory FACTORY = new UTF8StringPointableFactory();
    public static final ITypeTraits TYPE_TRAITS = VarLengthTypeTrait.INSTANCE;
    private int utf8Length;
    private int metaLength;
    private int hashValue;
    private int stringLength;
    public static final UTF8StringPointable SPACE_STRING_POINTABLE = UTF8StringPointable.generateUTF8Pointable(" ");
    public static final Charset CESU8_CHARSET = Charset.forName("CESU8");

    @Override
    protected void afterReset() {
        this.utf8Length = UTF8StringUtil.getUTFLength((byte[])this.bytes, (int)this.start);
        this.metaLength = UTF8StringUtil.getNumBytesToStoreLength((int)this.getUTF8Length());
        this.hashValue = 0;
        this.stringLength = -1;
    }

    public static UTF8StringPointable generateUTF8Pointable(String string) {
        byte[] bytes = UTF8StringUtil.writeStringToBytes((String)string);
        UTF8StringPointable ptr = new UTF8StringPointable();
        ptr.set(bytes, 0, bytes.length);
        return ptr;
    }

    public char charAt(int offset) {
        return UTF8StringUtil.charAt((byte[])this.bytes, (int)(this.start + offset));
    }

    public int charSize(int offset) {
        return UTF8StringUtil.charSize((byte[])this.bytes, (int)(this.start + offset));
    }

    public int codePointAt(int offset) {
        return UTF8StringUtil.codePointAt((byte[])this.bytes, (int)(this.start + offset));
    }

    public int codePointSize(int offset) {
        return UTF8StringUtil.codePointSize((byte[])this.bytes, (int)(this.start + offset));
    }

    public void getCodePoints(IntCollection codePointSet) {
        int byteIdx;
        for (byteIdx = 0; byteIdx < this.utf8Length; byteIdx += this.codePointSize(this.metaLength + byteIdx)) {
            codePointSet.add(this.codePointAt(this.metaLength + byteIdx));
        }
        if (byteIdx != this.utf8Length) {
            throw new IllegalArgumentException("Decoding error: malformed bytes");
        }
    }

    public int getStringLength() {
        if (this.stringLength < 0) {
            this.stringLength = UTF8StringUtil.getStringLength((byte[])this.bytes, (int)this.start);
        }
        return this.stringLength;
    }

    public int getUTF8Length() {
        return this.utf8Length;
    }

    public int getMetaDataLength() {
        return this.metaLength;
    }

    public int getCharStartOffset() {
        return this.getStartOffset() + this.getMetaDataLength();
    }

    @Override
    public int compareTo(IPointable pointer) {
        return this.compareTo(pointer.getByteArray(), pointer.getStartOffset(), pointer.getLength());
    }

    @Override
    public int compareTo(byte[] bytes, int start, int length) {
        return UTF8StringUtil.compareTo((byte[])this.bytes, (int)this.start, (byte[])bytes, (int)start);
    }

    @Override
    public int hash() {
        if (this.hashValue == 0) {
            this.hashValue = UTF8StringUtil.hash((byte[])this.bytes, (int)this.start);
        }
        return this.hashValue;
    }

    public void toString(StringBuilder buffer) {
        UTF8StringUtil.toString((StringBuilder)buffer, (byte[])this.bytes, (int)this.start);
    }

    public String toString() {
        return new String(this.bytes, this.getCharStartOffset(), this.getUTF8Length(), CESU8_CHARSET);
    }

    public int ignoreCaseCompareTo(UTF8StringPointable other) {
        return UTF8StringUtil.lowerCaseCompareTo((byte[])this.getByteArray(), (int)this.getStartOffset(), (byte[])other.getByteArray(), (int)other.getStartOffset());
    }

    public int find(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.find(this, pattern, ignoreCase);
    }

    public static int compare(byte[] bytes, int start, int length, byte[] thatBytes, int thatStart, int thatLength) {
        return UTF8StringUtil.compareTo((byte[])bytes, (int)start, (byte[])thatBytes, (int)thatStart);
    }

    public static int compare(UTF8StringPointable pointable1, UTF8StringPointable pointable2) {
        return UTF8StringUtil.compareTo((byte[])pointable1.bytes, (int)(pointable1.start + pointable1.metaLength), (int)pointable1.utf8Length, (byte[])pointable2.bytes, (int)(pointable2.start + pointable2.metaLength), (int)pointable2.utf8Length);
    }

    public static int find(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.find(src, pattern, ignoreCase, 0);
    }

    public static int findInCodePoint(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.findInByteOrCodePoint(src, pattern, ignoreCase, 0, false);
    }

    public static int find(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase, int startMatch) {
        return UTF8StringPointable.findInByteOrCodePoint(src, pattern, ignoreCase, startMatch, true);
    }

    public static int findInCodePoint(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase, int startMatch) {
        return UTF8StringPointable.findInByteOrCodePoint(src, pattern, ignoreCase, startMatch, false);
    }

    private static int findInByteOrCodePoint(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase, int startMatch, boolean resultInByte) {
        int srcUtfLen = src.getUTF8Length();
        int pttnUtfLen = pattern.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        int pttnStart = pattern.getMetaDataLength();
        int codePointCount = 0;
        int maxStart = srcUtfLen - pttnUtfLen;
        boolean prevHighSurrogate = false;
        for (int startMatchPos = startMatch; startMatchPos <= maxStart; startMatchPos += src.charSize(srcStart + startMatchPos)) {
            char ch2;
            char ch1;
            int c2;
            int c1 = startMatchPos;
            for (c2 = 0; c1 < srcUtfLen && c2 < pttnUtfLen && ((ch1 = src.charAt(srcStart + c1)) == (ch2 = pattern.charAt(pttnStart + c2)) || ignoreCase && Character.toLowerCase(ch1) == Character.toLowerCase(ch2)); c1 += src.charSize(srcStart + c1), c2 += pattern.charSize(pttnStart + c2)) {
            }
            if (c2 == pttnUtfLen) {
                if (resultInByte) {
                    return startMatchPos;
                }
                if (prevHighSurrogate) {
                    throw new IllegalArgumentException("Decoding error: got a high surrogate without a following low surrogate");
                }
                return codePointCount;
            }
            if (resultInByte) continue;
            char ch = src.charAt(srcStart + startMatchPos);
            if (Character.isHighSurrogate(ch)) {
                prevHighSurrogate = true;
                continue;
            }
            if (Character.isLowSurrogate(ch)) {
                if (prevHighSurrogate) {
                    ++codePointCount;
                    prevHighSurrogate = false;
                    continue;
                }
                throw new IllegalArgumentException("Decoding error: got a low surrogate without a leading high surrogate");
            }
            ++codePointCount;
        }
        return -1;
    }

    public boolean contains(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.contains(this, pattern, ignoreCase);
    }

    public static boolean contains(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.find(src, pattern, ignoreCase) >= 0;
    }

    public boolean startsWith(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.startsWith(this, pattern, ignoreCase);
    }

    public static boolean startsWith(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        char ch2;
        char ch1;
        int c2;
        int utflen1 = src.getUTF8Length();
        int utflen2 = pattern.getUTF8Length();
        if (utflen2 > utflen1) {
            return false;
        }
        int s1Start = src.getMetaDataLength();
        int s2Start = pattern.getMetaDataLength();
        int c1 = 0;
        for (c2 = 0; c1 < utflen1 && c2 < utflen2 && ((ch1 = src.charAt(s1Start + c1)) == (ch2 = pattern.charAt(s2Start + c2)) || ignoreCase && Character.toLowerCase(ch1) == Character.toLowerCase(ch2)); c1 += src.charSize(s1Start + c1), c2 += pattern.charSize(s2Start + c2)) {
        }
        return c2 == utflen2;
    }

    public boolean endsWith(UTF8StringPointable pattern, boolean ignoreCase) {
        return UTF8StringPointable.endsWith(this, pattern, ignoreCase);
    }

    public static boolean endsWith(UTF8StringPointable src, UTF8StringPointable pattern, boolean ignoreCase) {
        char ch2;
        char ch1;
        int c2;
        int len1 = src.getUTF8Length();
        int len2 = pattern.getUTF8Length();
        if (len2 > len1) {
            return false;
        }
        int s1Start = src.getMetaDataLength();
        int s2Start = pattern.getMetaDataLength();
        int c1 = len1 - len2;
        for (c2 = 0; c1 < len1 && c2 < len2 && ((ch1 = src.charAt(s1Start + c1)) == (ch2 = pattern.charAt(s2Start + c2)) || ignoreCase && Character.toLowerCase(ch1) == Character.toLowerCase(ch2)); c1 += src.charSize(s1Start + c1), c2 += pattern.charSize(s2Start + c2)) {
        }
        return c2 == len2;
    }

    public void concat(UTF8StringPointable next, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.concat(this, next, builder, out);
    }

    public static void concat(UTF8StringPointable first, UTF8StringPointable next, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int firstUtfLen = first.getUTF8Length();
        int nextUtfLen = next.getUTF8Length();
        builder.reset(out, firstUtfLen + nextUtfLen);
        builder.appendUtf8StringPointable(first);
        builder.appendUtf8StringPointable(next);
        builder.finish();
    }

    public boolean substr(int codePointOffset, int codePointLength, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        return UTF8StringPointable.substr(this, codePointOffset, codePointLength, builder, out);
    }

    public static boolean substr(UTF8StringPointable src, int codePointOffset, int codePointLength, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int byteIdx;
        if (codePointOffset < 0 || codePointLength < 0) {
            return false;
        }
        int utfLen = src.getUTF8Length();
        int codePointIdx = 0;
        for (byteIdx = 0; byteIdx < utfLen && codePointIdx < codePointOffset; byteIdx += src.codePointSize(src.getMetaDataLength() + byteIdx), ++codePointIdx) {
        }
        if (byteIdx >= utfLen) {
            return false;
        }
        builder.reset(out, Math.min(utfLen - byteIdx, (int)((double)codePointLength * 1.0 * (double)byteIdx / (double)codePointIdx)));
        for (codePointIdx = 0; byteIdx < utfLen && codePointIdx < codePointLength; ++codePointIdx, byteIdx += src.codePointSize(src.getMetaDataLength() + byteIdx)) {
            builder.appendCodePoint(src.codePointAt(src.getMetaDataLength() + byteIdx));
        }
        builder.finish();
        return true;
    }

    public void substrBefore(UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.substrBefore(this, match, builder, out);
    }

    public static void substrBefore(UTF8StringPointable src, UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int byteOffset = UTF8StringPointable.find(src, match, false);
        if (byteOffset < 0) {
            builder.reset(out, 0);
            builder.finish();
            return;
        }
        int srcMetaLen = src.getMetaDataLength();
        builder.reset(out, byteOffset);
        for (int idx = 0; idx < byteOffset; idx += src.charSize(srcMetaLen + idx)) {
            builder.appendChar(src.charAt(srcMetaLen + idx));
        }
        builder.finish();
    }

    public void substrAfter(UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.substrAfter(this, match, builder, out);
    }

    public static void substrAfter(UTF8StringPointable src, UTF8StringPointable match, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int byteOffset = UTF8StringPointable.find(src, match, false);
        if (byteOffset < 0) {
            builder.reset(out, 0);
            builder.finish();
            return;
        }
        int srcUtfLen = src.getUTF8Length();
        int matchUtfLen = match.getUTF8Length();
        int resultLen = srcUtfLen - byteOffset - matchUtfLen;
        builder.reset(out, resultLen);
        builder.appendUtf8StringPointable(src, src.getCharStartOffset() + byteOffset + matchUtfLen, resultLen);
        builder.finish();
    }

    public void lowercase(UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.lowercase(this, builder, out);
    }

    public static void lowercase(UTF8StringPointable src, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int srcUtfLen = src.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        builder.reset(out, srcUtfLen);
        for (int byteIndex = 0; byteIndex < srcUtfLen; byteIndex += src.charSize(srcStart + byteIndex)) {
            builder.appendChar(Character.toLowerCase(src.charAt(srcStart + byteIndex)));
        }
        builder.finish();
    }

    public void uppercase(UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.uppercase(this, builder, out);
    }

    public static void uppercase(UTF8StringPointable src, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int srcUtfLen = src.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        builder.reset(out, srcUtfLen);
        for (int byteIndex = 0; byteIndex < srcUtfLen; byteIndex += src.charSize(srcStart + byteIndex)) {
            builder.appendChar(Character.toUpperCase(src.charAt(srcStart + byteIndex)));
        }
        builder.finish();
    }

    public void initCap(UTF8StringBuilder builder, GrowableArray out) throws IOException {
        UTF8StringPointable.initCap(this, builder, out);
    }

    public static void initCap(UTF8StringPointable src, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int srcUtfLen = src.getUTF8Length();
        int srcStart = src.getMetaDataLength();
        builder.reset(out, srcUtfLen);
        boolean toUpperCase = true;
        for (int byteIndex = 0; byteIndex < srcUtfLen; byteIndex += src.charSize(srcStart + byteIndex)) {
            char originalChar = src.charAt(srcStart + byteIndex);
            boolean isLetter = Character.isLetter(originalChar);
            char resultChar = toUpperCase && isLetter ? Character.toUpperCase(originalChar) : (isLetter ? Character.toLowerCase(originalChar) : originalChar);
            builder.appendChar(resultChar);
            toUpperCase = !isLetter;
        }
        builder.finish();
    }

    public static void trim(UTF8StringPointable srcPtr, UTF8StringBuilder builder, GrowableArray out, boolean left, boolean right, IntCollection codePointSet) throws IOException {
        int startIndex;
        int srcUtfLen = srcPtr.getUTF8Length();
        int srcStart = srcPtr.getMetaDataLength();
        if (left) {
            int codepoint;
            for (startIndex = 0; startIndex < srcUtfLen && codePointSet.contains(codepoint = srcPtr.codePointAt(srcStart + startIndex)); startIndex += srcPtr.codePointSize(srcStart + startIndex)) {
            }
        }
        int endIndex = srcUtfLen;
        if (right) {
            endIndex = startIndex;
            for (int cursorIndex = startIndex; cursorIndex < srcUtfLen; cursorIndex += srcPtr.codePointSize(srcStart + cursorIndex)) {
                int codePioint = srcPtr.codePointAt(srcStart + cursorIndex);
                if (codePointSet.contains(codePioint)) continue;
                endIndex = cursorIndex;
            }
        }
        int len = endIndex - startIndex;
        builder.reset(out, len);
        builder.appendUtf8StringPointable(srcPtr, srcPtr.getStartOffset() + srcStart + startIndex, len);
        builder.finish();
    }

    public void trim(UTF8StringBuilder builder, GrowableArray out, boolean left, boolean right, IntCollection codePointSet) throws IOException {
        UTF8StringPointable.trim(this, builder, out, left, right, codePointSet);
    }

    public static void reverse(UTF8StringPointable srcPtr, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int srcEnd;
        builder.reset(out, srcPtr.getUTF8Length());
        int srcStart = srcPtr.getCharStartOffset();
        for (int cursorIndex = srcEnd = srcPtr.getStartOffset() + srcPtr.getLength() - 1; cursorIndex >= srcStart; --cursorIndex) {
            if (!UTF8StringUtil.isCharStart((byte[])srcPtr.bytes, (int)cursorIndex)) continue;
            char ch = UTF8StringUtil.charAt((byte[])srcPtr.bytes, (int)cursorIndex);
            int charSize = UTF8StringUtil.charSize((byte[])srcPtr.bytes, (int)cursorIndex);
            if (Character.isLowSurrogate(ch)) {
                while (cursorIndex >= srcStart) {
                    if (!UTF8StringUtil.isCharStart((byte[])srcPtr.bytes, (int)(--cursorIndex))) continue;
                    ch = UTF8StringUtil.charAt((byte[])srcPtr.bytes, (int)cursorIndex);
                    if (!Character.isHighSurrogate(ch)) {
                        throw new IllegalArgumentException("Decoding Error: no corresponding high surrogate found for the following low surrogate");
                    }
                    charSize += UTF8StringUtil.charSize((byte[])srcPtr.bytes, (int)cursorIndex);
                    break;
                }
            } else if (Character.isHighSurrogate(ch)) {
                throw new IllegalArgumentException("Decoding Error: get a high surrogate without low surrogate");
            }
            builder.appendUtf8StringPointable(srcPtr, cursorIndex, charSize);
        }
        builder.finish();
    }

    public boolean findAndReplace(UTF8StringPointable searchPtr, UTF8StringPointable replacePtr, int replaceLimit, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        return UTF8StringPointable.findAndReplace(this, searchPtr, replacePtr, replaceLimit, builder, out);
    }

    public static boolean findAndReplace(UTF8StringPointable srcPtr, UTF8StringPointable searchPtr, UTF8StringPointable replacePtr, int replaceLimit, UTF8StringBuilder builder, GrowableArray out) throws IOException {
        int nextIdx;
        int curIdx;
        if (replaceLimit == 0) {
            return false;
        }
        if (replaceLimit < 0) {
            replaceLimit = Integer.MAX_VALUE;
        }
        if ((curIdx = UTF8StringPointable.find(srcPtr, searchPtr, false)) < 0) {
            return false;
        }
        int searchUtfLen = searchPtr.getUTF8Length();
        int replaceUtfLen = replacePtr.getUTF8Length();
        int estimatedLen = searchUtfLen > 0 && replaceUtfLen > searchUtfLen ? (int)((long)srcPtr.getUTF8Length() * (long)replaceUtfLen / (long)searchUtfLen) : srcPtr.getUTF8Length();
        builder.reset(out, estimatedLen);
        builder.appendUtf8StringPointable(srcPtr, srcPtr.getCharStartOffset(), curIdx);
        builder.appendUtf8StringPointable(replacePtr);
        curIdx += searchUtfLen;
        for (int limit = replaceLimit - 1; limit > 0 && (nextIdx = UTF8StringPointable.find(srcPtr, searchPtr, false, curIdx)) > 0; --limit) {
            builder.appendUtf8StringPointable(srcPtr, srcPtr.getCharStartOffset() + curIdx, nextIdx - curIdx);
            builder.appendUtf8StringPointable(replacePtr);
            curIdx = nextIdx + searchUtfLen;
        }
        builder.appendUtf8StringPointable(srcPtr, srcPtr.getCharStartOffset() + curIdx, srcPtr.getUTF8Length() - curIdx);
        builder.finish();
        return true;
    }

    public static class UTF8StringPointableFactory
    implements IPointableFactory {
        private static final long serialVersionUID = 1L;

        private UTF8StringPointableFactory() {
        }

        @Override
        public UTF8StringPointable createPointable() {
            return new UTF8StringPointable();
        }

        @Override
        public ITypeTraits getTypeTraits() {
            return TYPE_TRAITS;
        }

        public JsonNode toJson(IPersistedResourceRegistry registry) throws HyracksDataException {
            return registry.getClassIdentifier(this.getClass(), 1L);
        }

        public static IJsonSerializable fromJson(IPersistedResourceRegistry registry, JsonNode json) {
            return FACTORY;
        }
    }
}

