/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.aggregates.serializable.std;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.base.ANull;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.om.types.EnumDeserializer;
import org.apache.asterix.runtime.aggregates.serializable.std.AbstractSerializableAggregateFunction;
import org.apache.asterix.runtime.aggregates.serializable.std.BufferSerDeUtil;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractSerializableCountAggregateFunction
extends AbstractSerializableAggregateFunction {
    private static final int MET_NULL_OFFSET = 0;
    private static final int COUNT_OFFSET = 1;
    private AMutableInt64 result = new AMutableInt64(-1L);
    private ISerializerDeserializer<AInt64> int64Serde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    private ISerializerDeserializer<ANull> nullSerde = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.ANULL);
    private IPointable inputVal = new VoidPointable();
    private IScalarEvaluator eval;

    public AbstractSerializableCountAggregateFunction(IScalarEvaluatorFactory[] args, IEvaluatorContext context, SourceLocation sourceLoc) throws HyracksDataException {
        super(sourceLoc);
        this.eval = args[0].createScalarEvaluator(context);
    }

    public void init(DataOutput state) throws HyracksDataException {
        try {
            state.writeBoolean(false);
            state.writeLong(0L);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void step(IFrameTupleReference tuple, byte[] state, int start, int len) throws HyracksDataException {
        boolean metNull = BufferSerDeUtil.getBoolean(state, start);
        long cnt = BufferSerDeUtil.getLong(state, start + 1);
        this.eval.evaluate(tuple, this.inputVal);
        ATypeTag typeTag = (ATypeTag)EnumDeserializer.ATYPETAGDESERIALIZER.deserialize(this.inputVal.getByteArray()[this.inputVal.getStartOffset()]);
        if (typeTag == ATypeTag.MISSING || typeTag == ATypeTag.NULL) {
            this.processNull(state, start);
        } else {
            ++cnt;
        }
        BufferSerDeUtil.writeBoolean(metNull, state, start + 0);
        BufferSerDeUtil.writeLong(cnt, state, start + 1);
    }

    public void finish(byte[] state, int start, int len, DataOutput out) throws HyracksDataException {
        boolean metNull = BufferSerDeUtil.getBoolean(state, start);
        long cnt = BufferSerDeUtil.getLong(state, start + 1);
        try {
            if (metNull) {
                this.nullSerde.serialize((Object)ANull.NULL, out);
            } else {
                this.result.setValue(cnt);
                this.int64Serde.serialize((Object)this.result, out);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void finishPartial(byte[] state, int start, int len, DataOutput out) throws HyracksDataException {
        this.finish(state, start, len, out);
    }

    protected void processNull(byte[] state, int start) {
        BufferSerDeUtil.writeBoolean(true, state, start + 0);
    }
}

