/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.CompilerProperties;
import org.apache.asterix.om.base.AOrderedList;
import org.apache.asterix.om.base.AString;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.IFunctionDescriptor;
import org.apache.asterix.om.functions.IFunctionTypeInferer;
import org.apache.asterix.om.pointables.base.DefaultOpenFieldType;
import org.apache.asterix.om.typecomputer.base.TypeCastUtils;
import org.apache.asterix.om.typecomputer.impl.TypeComputeUtils;
import org.apache.asterix.om.types.ARecordType;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.AUnionType;
import org.apache.asterix.om.types.IAType;
import org.apache.asterix.om.utils.ConstantExpressionUtil;
import org.apache.asterix.om.utils.RecordUtil;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.common.exceptions.NotImplementedException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;

public final class FunctionTypeInferers {
    public static final IFunctionTypeInferer SET_EXPRESSION_TYPE = new IFunctionTypeInferer(){

        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            fd.setImmutableStates(new Object[]{context.getType(expr)});
        }
    };
    public static final IFunctionTypeInferer SET_ARGUMENT_TYPE = new IFunctionTypeInferer(){

        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
            IAType t = (IAType)context.getType((ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue());
            fd.setImmutableStates(new Object[]{TypeComputeUtils.getActualType((IAType)t)});
        }
    };
    public static final IFunctionTypeInferer SET_ARGUMENTS_TYPE = new IFunctionTypeInferer(){

        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
            fd.setImmutableStates((Object[])FunctionTypeInferers.getArgumentsTypes(fce, context));
        }
    };
    public static final IFunctionTypeInferer SET_SORTING_PARAMETERS = new IFunctionTypeInferer(){

        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment ctx, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression funExp = (AbstractFunctionCallExpression)expr;
            Object[] sortingParameters = funExp.getOpaqueParameters();
            fd.setImmutableStates(new Object[]{sortingParameters[0], sortingParameters[1], FunctionTypeInferers.getArgumentsTypes(funExp, ctx)});
        }
    };
    public static final IFunctionTypeInferer SET_NUM_SAMPLES = new IFunctionTypeInferer(){

        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression funCallExpr = (AbstractFunctionCallExpression)expr;
            Object[] samplingParameters = funCallExpr.getOpaqueParameters();
            fd.setImmutableStates(new Object[]{samplingParameters[0]});
        }
    };
    public static final IFunctionTypeInferer LISTIFY_INFERER = new IFunctionTypeInferer(){

        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression listifyExpression = (AbstractFunctionCallExpression)expr;
            IAType outputListType = (IAType)context.getType((ILogicalExpression)listifyExpression);
            IAType itemType = (IAType)context.getType((ILogicalExpression)((Mutable)listifyExpression.getArguments().get(0)).getValue());
            fd.setImmutableStates(new Object[]{outputListType, TypeComputeUtils.getActualType((IAType)itemType)});
        }
    };

    private FunctionTypeInferers() {
    }

    private static IAType[] getArgumentsTypes(AbstractFunctionCallExpression funExp, IVariableTypeEnvironment ctx) throws AlgebricksException {
        IAType[] argsTypes = new IAType[funExp.getArguments().size()];
        int i = 0;
        for (Mutable arg : funExp.getArguments()) {
            argsTypes[i] = TypeComputeUtils.getActualType((IAType)((IAType)ctx.getType((ILogicalExpression)arg.getValue())));
            ++i;
        }
        return argsTypes;
    }

    public static final class FullTextContainsTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
            fd.setImmutableStates(new Object[]{funcExpr.getOpaqueParameters()[0]});
        }
    }

    public static final class RecordConcatTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
            List args = f.getArguments();
            int n = args.size();
            ARecordType[] argRecordTypes = new ARecordType[n];
            for (int i = 0; i < n; ++i) {
                IAType argType = (IAType)context.getType((ILogicalExpression)((Mutable)args.get(i)).getValue());
                IAType t = TypeComputeUtils.getActualType((IAType)argType);
                if (t.getTypeTag() != ATypeTag.OBJECT) continue;
                argRecordTypes[i] = (ARecordType)t;
            }
            fd.setImmutableStates((Object[])argRecordTypes);
        }
    }

    public static final class RecordRemoveFieldsTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
            IAType outType = (IAType)context.getType(expr);
            IAType type0 = (IAType)context.getType((ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue());
            ILogicalExpression le = (ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue();
            IAType type1 = (IAType)context.getType(le);
            if (type0.getTypeTag().equals((Object)ATypeTag.ANY)) {
                type0 = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
            }
            if (type1.getTypeTag().equals((Object)ATypeTag.ANY)) {
                type1 = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
            }
            fd.setImmutableStates(new Object[]{outType, type0, type1});
        }
    }

    public static final class RecordMergeTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
            IAType outType = (IAType)context.getType(expr);
            IAType type0 = (IAType)context.getType((ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue());
            IAType type1 = (IAType)context.getType((ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue());
            fd.setImmutableStates(new Object[]{outType, type0, type1});
        }
    }

    public static final class RecordAddFieldsTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
            IAType outType = (IAType)context.getType(expr);
            IAType type0 = (IAType)context.getType((ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue());
            ILogicalExpression listExpr = (ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue();
            IAType type1 = (IAType)context.getType(listExpr);
            if (type0.getTypeTag().equals((Object)ATypeTag.ANY)) {
                type0 = DefaultOpenFieldType.NESTED_OPEN_RECORD_TYPE;
            }
            if (type1.getTypeTag().equals((Object)ATypeTag.ANY)) {
                type1 = DefaultOpenFieldType.NESTED_OPEN_AORDERED_LIST_TYPE;
            }
            fd.setImmutableStates(new Object[]{outType, type0, type1});
        }
    }

    public static final class OpenRecordConstructorTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            ARecordType rt = (ARecordType)context.getType(expr);
            fd.setImmutableStates(new Object[]{rt, this.computeOpenFields((AbstractFunctionCallExpression)expr, rt)});
        }

        private boolean[] computeOpenFields(AbstractFunctionCallExpression expr, ARecordType recType) {
            int n = expr.getArguments().size() / 2;
            boolean[] open = new boolean[n];
            block0: for (int i = 0; i < n; ++i) {
                Mutable argRef = (Mutable)expr.getArguments().get(2 * i);
                ILogicalExpression arg = (ILogicalExpression)argRef.getValue();
                open[i] = true;
                String fn = ConstantExpressionUtil.getStringConstant((ILogicalExpression)arg);
                if (fn == null) continue;
                for (String s : recType.getFieldNames()) {
                    if (!s.equals(fn)) continue;
                    open[i] = false;
                    continue block0;
                }
            }
            return open;
        }
    }

    public static final class RecordAccessorTypeInferer
    implements IFunctionTypeInferer {
        public static final IFunctionTypeInferer INSTANCE_STRICT = new RecordAccessorTypeInferer(true);
        public static final IFunctionTypeInferer INSTANCE_LAX = new RecordAccessorTypeInferer(false);
        private final boolean strict;

        private RecordAccessorTypeInferer(boolean strict) {
            this.strict = strict;
        }

        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
            IAType t = TypeComputeUtils.getActualType((IAType)((IAType)context.getType((ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue())));
            ATypeTag typeTag = t.getTypeTag();
            switch (typeTag) {
                case OBJECT: {
                    fd.setImmutableStates(new Object[]{t});
                    break;
                }
                case ANY: {
                    fd.setImmutableStates(new Object[]{RecordUtil.FULLY_OPEN_RECORD_TYPE});
                    break;
                }
                default: {
                    if (this.strict) {
                        throw new NotImplementedException(fd.getIdentifier().getName() + " for data of type " + t);
                    }
                    fd.setImmutableStates(new Object[]{null});
                }
            }
        }
    }

    public static final class FieldAccessNestedTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
            AOrderedList fieldPath = (AOrderedList)((AsterixConstantValue)((ConstantExpression)((Mutable)fce.getArguments().get(1)).getValue()).getValue()).getObject();
            ArrayList<String> listFieldPath = new ArrayList<String>();
            for (int i = 0; i < fieldPath.size(); ++i) {
                listFieldPath.add(((AString)fieldPath.getItem(i)).getStringValue());
            }
            IAType t = TypeComputeUtils.getActualType((IAType)((IAType)context.getType((ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue())));
            switch (t.getTypeTag()) {
                case OBJECT: {
                    fd.setImmutableStates(new Object[]{t, listFieldPath});
                    break;
                }
                default: {
                    fd.setImmutableStates(new Object[]{RecordUtil.FULLY_OPEN_RECORD_TYPE, listFieldPath});
                }
            }
        }
    }

    public static final class FieldAccessByIndexTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression fce = (AbstractFunctionCallExpression)expr;
            IAType t = (IAType)context.getType((ILogicalExpression)((Mutable)fce.getArguments().get(0)).getValue());
            switch (t.getTypeTag()) {
                case OBJECT: {
                    fd.setImmutableStates(new Object[]{t});
                    break;
                }
                case UNION: {
                    IAType t2;
                    AUnionType unionT = (AUnionType)t;
                    if (!unionT.isUnknownableType() || (t2 = unionT.getActualType()).getTypeTag() != ATypeTag.OBJECT) break;
                    fd.setImmutableStates(new Object[]{t2});
                }
            }
        }
    }

    public static final class DeepEqualityTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression f = (AbstractFunctionCallExpression)expr;
            IAType type0 = (IAType)context.getType((ILogicalExpression)((Mutable)f.getArguments().get(0)).getValue());
            IAType type1 = (IAType)context.getType((ILogicalExpression)((Mutable)f.getArguments().get(1)).getValue());
            fd.setImmutableStates(new Object[]{type0, type1});
        }
    }

    public static final class CastTypeInferer
    implements IFunctionTypeInferer {
        public void infer(ILogicalExpression expr, IFunctionDescriptor fd, IVariableTypeEnvironment context, CompilerProperties compilerProps) throws AlgebricksException {
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
            IAType rt = TypeCastUtils.getRequiredType((AbstractFunctionCallExpression)funcExpr);
            IAType it = (IAType)context.getType((ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue());
            fd.setImmutableStates(new Object[]{rt, it});
        }
    }
}

