/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util.bytes;

import java.util.Arrays;

public class Base64Parser {
    private static final byte[] DECODE_MAP = Base64Parser.initDecodeMap();
    private static final byte PADDING = 127;
    private byte[] quadruplet = new byte[4];
    private byte[] storage;
    private int length = 0;

    private static byte[] initDecodeMap() {
        int i;
        byte[] map = new byte[128];
        Arrays.fill(map, (byte)-1);
        for (i = 65; i <= 90; ++i) {
            map[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            map[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            map[i] = (byte)(i - 48 + 52);
        }
        map[43] = 62;
        map[47] = 63;
        map[61] = 127;
        return map;
    }

    public int parseBase64String(char[] input, int start, int length, byte[] out, int offset) {
        int outLength = 0;
        int q = 0;
        for (int i = 0; i < length; ++i) {
            char ch = input[start + i];
            byte v = DECODE_MAP[ch];
            if (v == -1) {
                throw new IllegalArgumentException("Invalid Base64 character");
            }
            this.quadruplet[q++] = v;
            if (q != 4) continue;
            outLength += this.dumpQuadruplet(out, offset + outLength);
            q = 0;
        }
        return outLength;
    }

    public int parseBase64String(byte[] input, int start, int length, byte[] out, int offset) {
        int outLength = 0;
        int q = 0;
        for (int i = 0; i < length; ++i) {
            char ch = (char)input[start + i];
            byte v = DECODE_MAP[ch];
            if (v == -1) {
                throw new IllegalArgumentException("Invalid Base64 character");
            }
            this.quadruplet[q++] = v;
            if (q != 4) continue;
            outLength += this.dumpQuadruplet(out, offset + outLength);
            q = 0;
        }
        return outLength;
    }

    public static int guessLength(char[] chars, int start, int length) {
        int padSize;
        int j;
        for (j = length - 1; j >= 0; --j) {
            byte code = DECODE_MAP[chars[start + j]];
            if (code == 127) continue;
            if (code != -1) break;
            return length / 4 * 3;
        }
        if ((padSize = length - ++j) > 2) {
            return length / 4 * 3;
        }
        return length / 4 * 3 - padSize;
    }

    public static int guessLength(byte[] chars, int start, int length) {
        int padSize;
        int j;
        for (j = length - 1; j >= 0; --j) {
            byte code = DECODE_MAP[chars[start + j]];
            if (code == 127) continue;
            if (code != -1) break;
            return length / 4 * 3;
        }
        if ((padSize = length - ++j) > 2) {
            return length / 4 * 3;
        }
        return length / 4 * 3 - padSize;
    }

    public byte[] getByteArray() {
        return this.storage;
    }

    public int getLength() {
        return this.length;
    }

    public void generatePureByteArrayFromBase64String(byte[] input, int start, int length) {
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64 string, the length of the string should be a multiple of 4");
        }
        int buflen = Base64Parser.guessLength(input, start, length);
        this.ensureCapacity(buflen);
        this.length = this.parseBase64String(input, start, length, this.storage, 0);
    }

    public void generatePureByteArrayFromBase64String(char[] input, int start, int length) {
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Invalid Base64 string, the length of the string should be a multiple of 4");
        }
        int buflen = Base64Parser.guessLength(input, start, length);
        this.ensureCapacity(buflen);
        this.length = this.parseBase64String(input, start, length, this.storage, 0);
    }

    private void ensureCapacity(int length) {
        if (this.storage == null || this.storage.length < length) {
            this.storage = new byte[length];
        }
    }

    private int dumpQuadruplet(byte[] out, int offset) {
        int outLength = 0;
        out[offset + outLength++] = (byte)(this.quadruplet[0] << 2 | this.quadruplet[1] >> 4);
        if (this.quadruplet[2] != 127) {
            out[offset + outLength++] = (byte)(this.quadruplet[1] << 4 | this.quadruplet[2] >> 2);
        }
        if (this.quadruplet[3] != 127) {
            out[offset + outLength++] = (byte)(this.quadruplet[2] << 6 | this.quadruplet[3]);
        }
        return outLength;
    }
}

