/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.hyracks.bootstrap;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.api.IClusterManagementWork;
import org.apache.asterix.metadata.cluster.AddNodeWork;
import org.apache.asterix.metadata.cluster.RemoveNodeWork;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClusterWorkExecutor
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LinkedBlockingQueue<Set<IClusterManagementWork>> inbox;

    public ClusterWorkExecutor(LinkedBlockingQueue<Set<IClusterManagementWork>> inbox) {
        this.inbox = inbox;
    }

    @Override
    public void run() {
        while (true) {
            try {
                block8: while (true) {
                    Set<IClusterManagementWork> workSet = this.inbox.take();
                    int nodesToAdd = 0;
                    HashSet nodesToRemove = new HashSet();
                    HashSet<IClusterManagementWork> nodeAdditionRequests = new HashSet<IClusterManagementWork>();
                    HashSet<IClusterManagementWork> nodeRemovalRequests = new HashSet<IClusterManagementWork>();
                    Iterator<IClusterManagementWork> iterator = workSet.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block8;
                        IClusterManagementWork w = iterator.next();
                        switch (w.getClusterManagementWorkType()) {
                            case ADD_NODE: {
                                if (nodesToAdd < ((AddNodeWork)w).getNumberOfNodesRequested()) {
                                    nodesToAdd = ((AddNodeWork)w).getNumberOfNodesRequested();
                                }
                                nodeAdditionRequests.add(w);
                                break;
                            }
                            case REMOVE_NODE: {
                                nodesToRemove.addAll(((RemoveNodeWork)w).getNodesToBeRemoved());
                                nodeRemovalRequests.add(w);
                            }
                        }
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("interruped" + e.getMessage());
                }
                throw new IllegalStateException(e);
            }
            catch (Exception e) {
                if (!LOGGER.isErrorEnabled()) continue;
                LOGGER.error("Unexpected exception in handling cluster event" + e.getMessage());
                continue;
            }
            break;
        }
    }
}

