/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.hadoop.fs.azure.WasbRemoteCallException;
import org.apache.hadoop.fs.azure.WasbRemoteCallHelper;
import org.apache.hadoop.fs.azure.security.SpnegoToken;
import org.apache.hadoop.fs.azure.security.WasbDelegationTokenIdentifier;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.delegation.web.KerberosDelegationTokenAuthenticator;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureWasbRemoteCallHelper
extends WasbRemoteCallHelper {
    public static final Logger LOG = LoggerFactory.getLogger(SecureWasbRemoteCallHelper.class);
    private static final String DELEGATION_TOKEN_QUERY_PARAM_NAME = "delegation";
    private Token<?> delegationToken = null;
    private boolean alwaysRequiresKerberosAuth;
    private boolean isSpnegoTokenCachingEnabled;
    private SpnegoToken spnegoToken;

    public SecureWasbRemoteCallHelper(RetryPolicy retryPolicy, boolean alwaysRequiresKerberosAuth, boolean isSpnegoTokenCachingEnabled) {
        super(retryPolicy);
        this.alwaysRequiresKerberosAuth = alwaysRequiresKerberosAuth;
        this.isSpnegoTokenCachingEnabled = isSpnegoTokenCachingEnabled;
    }

    @Override
    public String makeRemoteRequest(final String[] urls, final String path, final List<NameValuePair> queryParams, final String httpMethod) throws IOException {
        final UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation connectUgi = ugi.getRealUser();
        if (connectUgi != null) {
            queryParams.add(new NameValuePair(){

                public String getName() {
                    return "doas";
                }

                public String getValue() {
                    return ugi.getShortUserName();
                }
            });
        } else {
            connectUgi = ugi;
        }
        Token<?> delegationToken = this.getDelegationToken(ugi);
        if (!this.alwaysRequiresKerberosAuth && delegationToken != null) {
            final String delegationTokenEncodedUrlString = delegationToken.encodeToUrlString();
            queryParams.add(new NameValuePair(){

                public String getName() {
                    return SecureWasbRemoteCallHelper.DELEGATION_TOKEN_QUERY_PARAM_NAME;
                }

                public String getValue() {
                    return delegationTokenEncodedUrlString;
                }
            });
        }
        if (delegationToken == null) {
            connectUgi.checkTGTAndReloginFromKeytab();
        }
        String s = null;
        try {
            s = (String)connectUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

                @Override
                public String run() throws Exception {
                    return SecureWasbRemoteCallHelper.this.retryableRequest(urls, path, queryParams, httpMethod);
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IOException(e.getMessage(), e);
        }
        return s;
    }

    @Override
    public HttpUriRequest getHttpRequest(String[] urls, String path, List<NameValuePair> queryParams, int urlIndex, String httpMethod, boolean requiresNewAuth) throws URISyntaxException, IOException {
        URIBuilder uriBuilder = new URIBuilder(urls[urlIndex]).setPath(path).setParameters(queryParams);
        if (uriBuilder.getHost().equals("localhost")) {
            uriBuilder.setHost(InetAddress.getLocalHost().getCanonicalHostName());
        }
        HttpPut httpUriRequest = null;
        switch (httpMethod) {
            case "PUT": {
                httpUriRequest = new HttpPut(uriBuilder.build());
                break;
            }
            case "POST": {
                httpUriRequest = new HttpPost(uriBuilder.build());
                break;
            }
            default: {
                httpUriRequest = new HttpGet(uriBuilder.build());
            }
        }
        LOG.debug("SecureWasbRemoteCallHelper#getHttpRequest() {}", (Object)uriBuilder.build().toURL());
        if (this.alwaysRequiresKerberosAuth || this.delegationToken == null) {
            AuthenticatedURL.Token token = null;
            KerberosDelegationTokenAuthenticator kerberosAuthenticator = new KerberosDelegationTokenAuthenticator();
            try {
                if (this.isSpnegoTokenCachingEnabled && !requiresNewAuth && this.spnegoToken != null && this.spnegoToken.isTokenValid()) {
                    token = this.spnegoToken.getToken();
                } else {
                    token = new AuthenticatedURL.Token();
                    kerberosAuthenticator.authenticate(uriBuilder.build().toURL(), token);
                    this.spnegoToken = new SpnegoToken(token);
                }
            }
            catch (AuthenticationException e) {
                throw new WasbRemoteCallException("Authentication Failed ", e);
            }
            Validate.isTrue((boolean)token.isSet(), (String)"Authenticated Token is NOT present. The request cannot proceed.", (Object[])new Object[0]);
            httpUriRequest.setHeader("Cookie", "hadoop.auth=" + token);
        }
        return httpUriRequest;
    }

    private Token<?> getDelegationToken(UserGroupInformation userGroupInformation) throws IOException {
        if (this.delegationToken == null) {
            Token token = null;
            for (Token iterToken : userGroupInformation.getTokens()) {
                if (!iterToken.getKind().equals((Object)WasbDelegationTokenIdentifier.TOKEN_KIND)) continue;
                token = iterToken;
                LOG.debug("{} token found in cache : {}", (Object)WasbDelegationTokenIdentifier.TOKEN_KIND, (Object)iterToken);
                break;
            }
            LOG.debug("UGI Information: {}", (Object)userGroupInformation.toString());
            if (token != null) {
                LOG.debug("Using UGI token: {}", (Object)token);
                this.setDelegationToken(token);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Delegation token from cache - {}", (Object)(this.delegationToken != null ? this.delegationToken.encodeToUrlString() : "null"));
        }
        return this.delegationToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        SecureWasbRemoteCallHelper secureWasbRemoteCallHelper = this;
        synchronized (secureWasbRemoteCallHelper) {
            this.delegationToken = token;
        }
    }
}

